/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;

public final class BaseNodes {
    private BaseNodes() {
    }

    public static abstract class IntSeq
    extends ExternalMethod2Node {
        @Specialization
        protected VmIntSeq eval(VirtualFrame frame, VmTyped self, long first2, long second2) {
            return new VmIntSeq(first2, second2, 1L);
        }
    }

    public static abstract class Pair
    extends ExternalMethod2Node {
        @Specialization
        protected VmPair eval(VirtualFrame frame, VmTyped self, Object first2, Object second2) {
            return new VmPair(first2, second2);
        }
    }

    public static abstract class Map
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VirtualFrame frame, VmTyped self, Object args2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().bug("Node `BaseNodes.Map` should never be executed.", new Object[0]).build();
        }
    }

    public static abstract class Set
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VirtualFrame frame, VmTyped self, Object args2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().bug("Node `BaseNodes.Set` should never be executed.", new Object[0]).build();
        }
    }

    public static abstract class List
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VirtualFrame frame, VmTyped self, Object args2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().bug("Node `BaseNodes.List` should never be executed.", new Object[0]).build();
        }
    }

    public static abstract class Null
    extends ExternalMethod1Node {
        @Specialization
        protected VmNull eval(VmTyped self, Object defaultValue) {
            return VmNull.withDefault(defaultValue);
        }
    }

    public static abstract class Undefined
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self) {
            throw this.exceptionBuilder().undefinedValue().build();
        }
    }

    public static abstract class Regex
    extends ExternalMethod1Node {
        @Specialization(guards={"pattern.equals(cachedPattern)"})
        protected VmRegex evalCached(VirtualFrame frame, VmTyped self, String pattern2, @Cached(value="pattern") String cachedPattern, @Cached(value="createRegex(frame, pattern)") VmRegex cachedRegex) {
            return cachedRegex;
        }

        @Specialization(replaces={"evalCached"})
        protected VmRegex eval(VirtualFrame frame, VmTyped self, String pattern2) {
            return this.createRegex(frame, pattern2);
        }

        protected VmRegex createRegex(VirtualFrame frame, String pattern2) {
            return new VmRegex(VmUtils.compilePattern(pattern2, this.getArg1Node()));
        }
    }

    public static abstract class Infinity
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(VmTyped self) {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static abstract class NaN
    extends ExternalPropertyNode {
        @Specialization
        protected double eval(VmTyped self) {
            return Double.NaN;
        }
    }
}

