/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.pkl.core.parser.Lexer;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmEvalException;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.util.Nullable;

public final class VmUndefinedValueException
extends VmEvalException {
    @Nullable
    private final Object receiver;

    public VmUndefinedValueException(String message, @Nullable Throwable cause, boolean isExternalMessage, Object[] messageArguments, List<VmException.ProgramValue> programValues, @Nullable Node location, @Nullable SourceSection sourceSection, @Nullable String memberName, @Nullable String hint, @Nullable Object receiver) {
        super(message, cause, isExternalMessage, messageArguments, programValues, location, sourceSection, memberName, hint);
        this.receiver = receiver;
    }

    public VmUndefinedValueException fillInHint(Deque<Object> path2, Object topLevelValue) {
        VmTyped typed;
        if (this.hint != null) {
            return this;
        }
        Object memberKey = this.getMessageArguments()[0];
        path2.push(memberKey);
        StringBuilder builder = new StringBuilder();
        builder.append("The above error occurred when rendering path `");
        this.renderPath(builder, path2);
        builder.append('`');
        path2.pop();
        if (topLevelValue instanceof VmTyped && (typed = (VmTyped)topLevelValue).isModuleObject()) {
            builder.append(" of module `").append(typed.getModuleInfo().getModuleSchema(typed).getModuleUri()).append('`');
        }
        builder.append('.');
        this.hint = builder.toString();
        return this;
    }

    private void renderPath(StringBuilder builder, Deque<Object> path2) {
        Iterator<Object> iter = path2.descendingIterator();
        boolean isTrailingPath = false;
        while (iter.hasNext()) {
            Object pathPart = iter.next();
            if (pathPart == VmValueConverter.TOP_LEVEL_VALUE) continue;
            if (pathPart instanceof Identifier) {
                if (isTrailingPath) {
                    builder.append('.');
                } else {
                    isTrailingPath = true;
                }
                builder.append(Lexer.maybeQuoteIdentifier(pathPart.toString()));
                continue;
            }
            builder.append('[').append(pathPart).append(']');
        }
    }

    @Nullable
    public Object getReceiver() {
        return this.receiver;
    }
}

