/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.packages;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.concurrent.GuardedBy;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.FileResolver;
import org.pkl.core.module.PathElement;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageAssetUri;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.runtime.FileSystemManager;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.ByteArrayUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.HttpUtils;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;
import org.pkl.core.util.json.Json;

final class PackageResolvers {
    private PackageResolvers() {
    }

    static final class DiskCachedPackageResolver
    extends AbstractPackageResolver {
        private final Path cacheDir;
        private final Path tmpDir;
        private static final String CACHE_DIR_PREFIX = "package-2";
        @GuardedBy(value="lock")
        private final EconomicMap<PackageUri, FileSystem> fileSystems = EconomicMaps.create();
        private static final Set<PosixFilePermission> FILE_PERMISSIONS = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ);

        public DiskCachedPackageResolver(SecurityManager securityManager2, HttpClient httpClient2, Path cacheDir) {
            super(securityManager2, httpClient2);
            this.cacheDir = cacheDir;
            this.tmpDir = cacheDir.resolve("tmp");
        }

        private String getEffectivePackageUriPath(PackageUri packageUri) {
            String path2 = packageUri.getUri().getPath();
            assert (path2 != null);
            if (packageUri.getChecksums() == null) {
                return path2;
            }
            int checksumIdx = path2.lastIndexOf("::");
            return IoUtils.encodePath(path2.substring(0, checksumIdx));
        }

        private Path getRelativePath(PackageUri uri) {
            return Path.of(CACHE_DIR_PREFIX, IoUtils.encodePath(uri.getUri().getAuthority()), this.getEffectivePackageUriPath(uri));
        }

        private String getLastSegmentName(PackageUri packageUri) {
            String path2 = this.getEffectivePackageUriPath(packageUri);
            int lastSep = path2.lastIndexOf("/");
            return path2.substring(lastSep + 1);
        }

        private byte[] downloadUriToPathAndComputeChecksum(URI downloadUri, Path path2) throws IOException, SecurityManagerException {
            InputStream inputStream2 = this.openExternalUri(downloadUri);
            try (DigestInputStream digestInputStream = this.newDigestInputStream(inputStream2);){
                Files.copy(digestInputStream, path2, StandardCopyOption.REPLACE_EXISTING);
                byte[] byArray = digestInputStream.getMessageDigest().digest();
                return byArray;
            }
        }

        private void downloadMetadata(PackageUri packageUri, URI downloadUri, Path path2, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            InputStream inputStream2 = this.openExternalUri(downloadUri);
            if (checksums != null) {
                inputStream2 = this.newDigestInputStream(inputStream2);
            }
            try (InputStream in = inputStream2;){
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                Files.copy(in, path2, StandardCopyOption.REPLACE_EXISTING);
                if (checksums != null) {
                    DigestInputStream digestInputStream = (DigestInputStream)inputStream2;
                    byte[] checksumBytes = digestInputStream.getMessageDigest().digest();
                    this.verifyPackageMetadataBytes(packageUri, downloadUri, checksums, checksumBytes);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Path getMetadataPath(PackageUri packageUri, URI requestUri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            String metadataFileName = this.getLastSegmentName(packageUri) + ".json";
            Path metadataRelativePath = this.getRelativePath(packageUri).resolve(metadataFileName);
            Path cachePath = this.cacheDir.resolve(metadataRelativePath);
            if (Files.exists(cachePath, new LinkOption[0])) {
                return cachePath;
            }
            Files.createDirectories(this.tmpDir, new FileAttribute[0]);
            Path tmpPath = Files.createTempFile(this.tmpDir, IoUtils.encodePath(packageUri.toString().replaceAll("/", "-")), ".json", new FileAttribute[0]);
            try {
                this.downloadMetadata(packageUri, requestUri, tmpPath, checksums);
                Files.createDirectories(cachePath.getParent(), new FileAttribute[0]);
                Files.move(tmpPath, cachePath, StandardCopyOption.ATOMIC_MOVE);
                if (!IoUtils.isWindows().booleanValue()) {
                    Files.setPosixFilePermissions(cachePath, FILE_PERMISSIONS);
                }
                Path path2 = cachePath;
                return path2;
            }
            finally {
                Files.deleteIfExists(tmpPath);
            }
        }

        @Override
        protected DependencyMetadata doGetDependencyMetadata(PackageUri packageUri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            DependencyMetadata metadata;
            URI requestUri = packageUri.getMetadataRequestUri();
            Path metadataPath = this.getMetadataPath(packageUri, requestUri, checksums);
            String metadataStr = Files.readString(metadataPath, StandardCharsets.UTF_8);
            try {
                metadata = DependencyMetadata.parse(metadataStr);
            }
            catch (Json.JsonParseException e2) {
                Files.deleteIfExists(metadataPath);
                throw new PackageLoadError(e2, "invalidDependencyMetadata", packageUri.getDisplayName(), requestUri, e2.getMessage());
            }
            if (!metadata.getPackageZipUrl().getScheme().equalsIgnoreCase("https")) {
                Files.deleteIfExists(metadataPath);
                throw this.invalidPackageZipUrl(packageUri, metadata);
            }
            return metadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Path getZipFilePath(PackageUri packageUri, DependencyMetadata dependencyMetadata) throws IOException, SecurityManagerException {
            String packageZipName = this.getLastSegmentName(packageUri) + ".zip";
            Path relativePath = this.getRelativePath(packageUri).resolve(packageZipName);
            Path cachePath = this.cacheDir.resolve(relativePath);
            if (Files.exists(cachePath, new LinkOption[0])) {
                return cachePath;
            }
            Files.createDirectories(this.tmpDir, new FileAttribute[0]);
            Path tmpPath = Files.createTempFile(this.tmpDir, IoUtils.encodePath(packageUri.toString().replaceAll("/", "-")), ".zip", new FileAttribute[0]);
            try {
                byte[] checksumBytes = this.downloadUriToPathAndComputeChecksum(dependencyMetadata.getPackageZipUrl(), tmpPath);
                this.verifyPackageZipBytes(packageUri, dependencyMetadata, checksumBytes);
                Files.createDirectories(cachePath.getParent(), new FileAttribute[0]);
                Files.move(tmpPath, cachePath, StandardCopyOption.ATOMIC_MOVE);
                if (!IoUtils.isWindows().booleanValue()) {
                    Files.setPosixFilePermissions(cachePath, FILE_PERMISSIONS);
                }
                Path path2 = cachePath;
                return path2;
            }
            finally {
                Files.deleteIfExists(tmpPath);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FileSystem getZipFileSystem(PackageAssetUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            PackageUri packageUri = uri.getPackageUri();
            Object object = this.lock;
            synchronized (object) {
                FileSystem fs = (FileSystem)this.fileSystems.get(packageUri);
                if (fs == null) {
                    DependencyMetadata metadata = this.getDependencyMetadata(packageUri, checksums);
                    Path zipFilePath = this.getZipFilePath(packageUri, metadata);
                    URI jarFileUri = URI.create("jar:" + zipFilePath.toUri());
                    fs = FileSystemManager.getFileSystem(jarFileUri);
                    this.fileSystems.put(packageUri, fs);
                }
                return fs;
            }
        }

        @Override
        public void downloadPackage(PackageUri uri, @Nullable Checksums checksums, boolean noTransitive) throws IOException, SecurityManagerException {
            DependencyMetadata metadata = this.getDependencyMetadata(uri, checksums);
            this.getZipFilePath(uri, metadata);
            if (noTransitive) {
                return;
            }
            for (Dependency.RemoteDependency dependency : metadata.getDependencies().values()) {
                this.downloadPackage(dependency.getPackageUri(), dependency.getChecksums(), false);
            }
        }

        @Override
        public Pair<DependencyMetadata, Checksums> getDependencyMetadataAndComputeChecksum(PackageUri packageUri) throws IOException, SecurityManagerException {
            Path packageDir = this.cacheDir.resolve(this.getRelativePath(packageUri));
            Path cacheFile = packageDir.resolve(packageDir.getFileName() + ".json");
            if (Files.exists(cacheFile, new LinkOption[0])) {
                return this.readDependencyMetadataAndComputeChecksum(packageUri, Files.newInputStream(cacheFile, new OpenOption[0]));
            }
            return super.getDependencyMetadataAndComputeChecksum(packageUri);
        }

        @Override
        public byte[] getBytes(PackageAssetUri uri, boolean allowDirectories, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            Path path2 = this.getZipFileSystem(uri, checksums).getPath(uri.getUri().getFragment(), new String[0]);
            if (Files.isDirectory(path2, new LinkOption[0])) {
                if (allowDirectories) {
                    try (Stream<Path> paths = Files.list(path2);){
                        String text = paths.map(it -> it.getFileName().toString()).sorted().collect(Collectors.joining("\n")) + "\n";
                        byte[] byArray = text.getBytes(StandardCharsets.UTF_8);
                        return byArray;
                    }
                }
                throw this.fileIsADirectory();
            }
            try {
                return Files.readAllBytes(path2);
            }
            catch (NoSuchFileException e2) {
                throw new FileNotFoundException();
            }
        }

        @Override
        protected List<PathElement> doListElements(PackageAssetUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            Path path2 = this.getZipFileSystem(uri, checksums).getPath(uri.getUri().getFragment(), new String[0]);
            return FileResolver.listElements(path2);
        }

        @Override
        public boolean doHasElement(PackageAssetUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            Path path2 = this.getZipFileSystem(uri, checksums).getPath(uri.getUri().getFragment(), new String[0]);
            return FileResolver.hasElement(path2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            super.close();
            Object object = this.lock;
            synchronized (object) {
                UnmodifiableMapCursor cursor = this.fileSystems.getEntries();
                while (cursor.advance()) {
                    ((FileSystem)cursor.getValue()).close();
                }
                this.fileSystems.clear();
            }
        }
    }

    static final class InMemoryPackageResolver
    extends AbstractPackageResolver {
        @GuardedBy(value="lock")
        private final EconomicMap<PackageUri, EconomicMap<String, ByteBuffer>> cachedEntries = EconomicMaps.create();
        @GuardedBy(value="lock")
        private final EconomicMap<PackageUri, PathElement.TreePathElement> cachedTreePathElementRoots = EconomicMaps.create();

        InMemoryPackageResolver(SecurityManager securityManager2, HttpClient httpClient2) {
            super(securityManager2, httpClient2);
        }

        private byte[] getPackageBytes(PackageUri packageUri, DependencyMetadata metadata) throws IOException, SecurityManagerException {
            InputStream httpInputStream = this.openExternalUri(metadata.getPackageZipUrl());
            try (DigestInputStream digestInputStream = this.newDigestInputStream(httpInputStream);){
                byte[] packageBytes = digestInputStream.readAllBytes();
                byte[] checksumBytes = digestInputStream.getMessageDigest().digest();
                this.verifyPackageZipBytes(packageUri, metadata, checksumBytes);
                byte[] byArray = packageBytes;
                return byArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensurePackageDownloaded(PackageUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            Object object = this.lock;
            synchronized (object) {
                if (this.cachedEntries.containsKey(uri)) {
                    return;
                }
                DependencyMetadata metadata = this.getDependencyMetadata(uri, checksums);
                EconomicMap<CallSite, ByteBuffer> cachedEntrySet = EconomicMaps.create();
                byte[] packageBytes = this.getPackageBytes(uri, metadata);
                try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(packageBytes));){
                    PathElement.TreePathElement rootPathElement = new PathElement.TreePathElement("", true);
                    this.cachedTreePathElementRoots.put(uri, rootPathElement);
                    ZipEntry entry = zipInputStream.getNextEntry();
                    while (entry != null) {
                        PathElement.TreePathElement pathElement = rootPathElement;
                        String[] nameParts = entry.getName().split("/");
                        int nameCount = nameParts.length;
                        for (int i = 0; i < nameCount; ++i) {
                            String name = nameParts[i];
                            boolean isDirectory = entry.isDirectory() || i < nameCount - 1;
                            pathElement = pathElement.putIfAbsent(name, new PathElement.TreePathElement(name, isDirectory));
                        }
                        if (!entry.isDirectory()) {
                            byte[] entryBytes = zipInputStream.readAllBytes();
                            cachedEntrySet.put((CallSite)((Object)("/" + entry.getName())), ByteBuffer.wrap(entryBytes));
                        }
                        entry = zipInputStream.getNextEntry();
                    }
                }
                this.cachedEntries.put(uri, cachedEntrySet);
            }
        }

        @Override
        public void downloadPackage(PackageUri uri, @Nullable Checksums checksums, boolean noTransitive) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getBytes(PackageAssetUri uri, boolean allowDirectories, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            PackageUri packageUri = uri.getPackageUri();
            this.ensurePackageDownloaded(packageUri, checksums);
            PathElement.TreePathElement elem = ((PathElement.TreePathElement)this.cachedTreePathElementRoots.get(uri.getPackageUri())).getElement(uri.getAssetPath());
            if (elem == null) {
                throw new FileNotFoundException();
            }
            if (elem.isDirectory()) {
                if (allowDirectories) {
                    String text = StreamSupport.stream(elem.getChildren().getKeys().spliterator(), false).sorted().collect(Collectors.joining("\n")) + "\n";
                    return text.getBytes(StandardCharsets.UTF_8);
                }
                throw this.fileIsADirectory();
            }
            EconomicMap entries2 = (EconomicMap)this.cachedEntries.get(packageUri);
            String path2 = IoUtils.toNormalizedPathString(Path.of(uri.getAssetPath(), new String[0]).normalize());
            return ((ByteBuffer)entries2.get(path2)).array();
        }

        @Override
        public List<PathElement> doListElements(PackageAssetUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            PackageUri packageUri = uri.getPackageUri();
            this.ensurePackageDownloaded(packageUri, checksums);
            PathElement.TreePathElement element = ((PathElement.TreePathElement)this.cachedTreePathElementRoots.get(packageUri)).getElement(uri.getAssetPath());
            if (element == null) {
                return Collections.emptyList();
            }
            return element.getChildrenValues();
        }

        @Override
        public boolean doHasElement(PackageAssetUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            PackageUri packageUri = uri.getPackageUri();
            this.ensurePackageDownloaded(packageUri, checksums);
            PathElement.TreePathElement element = ((PathElement.TreePathElement)this.cachedTreePathElementRoots.get(packageUri)).getElement(uri.getAssetPath());
            return element != null;
        }

        @Override
        protected DependencyMetadata doGetDependencyMetadata(PackageUri packageUri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            DependencyMetadata dependencyMetadata;
            block11: {
                URI requestUri = packageUri.getMetadataRequestUri();
                InputStream inputStream2 = this.openExternalUri(requestUri);
                if (checksums != null) {
                    inputStream2 = this.newDigestInputStream(inputStream2);
                }
                InputStream in = inputStream2;
                try {
                    DependencyMetadata metadata;
                    String metadataStr = IoUtils.readString(in);
                    if (checksums != null) {
                        DigestInputStream digestInputStream = (DigestInputStream)in;
                        byte[] checksumBytes = digestInputStream.getMessageDigest().digest();
                        this.verifyPackageMetadataBytes(packageUri, requestUri, checksums, checksumBytes);
                    }
                    if (!(metadata = DependencyMetadata.parse(metadataStr)).getPackageZipUrl().getScheme().equalsIgnoreCase("https")) {
                        throw this.invalidPackageZipUrl(packageUri, metadata);
                    }
                    dependencyMetadata = metadata;
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Json.JsonParseException e2) {
                        throw new PackageLoadError(e2, "invalidDependencyMetadata", packageUri.getDisplayName(), requestUri, e2.getMessage());
                    }
                }
                in.close();
            }
            return dependencyMetadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            super.close();
            Object object = this.lock;
            synchronized (object) {
                this.cachedEntries.clear();
                this.cachedTreePathElementRoots.clear();
            }
        }
    }

    static abstract class AbstractPackageResolver
    implements PackageResolver {
        @GuardedBy(value="lock")
        private final EconomicMap<PackageUri, DependencyMetadata> cachedDependencyMetadata;
        private final SecurityManager securityManager;
        protected final HttpClient httpClient;
        private final AtomicBoolean isClosed = new AtomicBoolean();
        protected final Object lock = new Object();

        protected AbstractPackageResolver(SecurityManager securityManager2, HttpClient httpClient2) {
            this.securityManager = securityManager2;
            this.httpClient = httpClient2;
            this.cachedDependencyMetadata = EconomicMaps.create();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DependencyMetadata getDependencyMetadata(PackageUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            this.checkNotClosed();
            Object object = this.lock;
            synchronized (object) {
                DependencyMetadata metadata = (DependencyMetadata)this.cachedDependencyMetadata.get(uri);
                if (metadata == null) {
                    metadata = this.doGetDependencyMetadata(uri, checksums);
                    this.cachedDependencyMetadata.put(uri, metadata);
                }
                return metadata;
            }
        }

        @Override
        public Pair<DependencyMetadata, Checksums> getDependencyMetadataAndComputeChecksum(PackageUri packageUri) throws IOException, SecurityManagerException {
            URI requestUri = packageUri.getMetadataRequestUri();
            InputStream inputStream2 = this.openExternalUri(requestUri);
            return this.readDependencyMetadataAndComputeChecksum(packageUri, inputStream2);
        }

        protected Pair<DependencyMetadata, Checksums> readDependencyMetadataAndComputeChecksum(PackageUri packageUri, InputStream inputStream2) throws IOException {
            Pair<DependencyMetadata, Checksums> pair2;
            block8: {
                DigestInputStream in = this.newDigestInputStream(inputStream2);
                try {
                    byte[] bytes = in.readAllBytes();
                    DependencyMetadata dependencyMetadata = DependencyMetadata.parse(new String(bytes, StandardCharsets.UTF_8));
                    Checksums checksums = new Checksums(ByteArrayUtils.toHex(in.getMessageDigest().digest()));
                    pair2 = Pair.of(dependencyMetadata, checksums);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Json.JsonParseException e2) {
                        throw new PackageLoadError(e2, "invalidDependencyMetadata", packageUri.getDisplayName(), packageUri.getMetadataRequestUri(), e2.getMessage());
                    }
                }
                in.close();
            }
            return pair2;
        }

        @Override
        public List<PathElement> listElements(PackageAssetUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            this.checkNotClosed();
            return this.doListElements(uri, checksums);
        }

        @Override
        public boolean hasElement(PackageAssetUri uri, @Nullable Checksums checksums) throws IOException, SecurityManagerException {
            this.checkNotClosed();
            return this.doHasElement(uri, checksums);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.isClosed.getAndSet(true)) {
                Object object = this.lock;
                synchronized (object) {
                    this.cachedDependencyMetadata.clear();
                }
            }
        }

        protected DigestInputStream newDigestInputStream(InputStream in) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                return new DigestInputStream(in, md);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new VmExceptionBuilder().unreachableCode().build();
            }
        }

        protected void verifyPackageZipBytes(PackageUri packageUri, DependencyMetadata dependencyMetadata, byte[] computedChecksum) {
            String expectedChecksum;
            String checksum = ByteArrayUtils.toHex(computedChecksum);
            if (!checksum.equals(expectedChecksum = dependencyMetadata.getPackageZipChecksums().getSha256())) {
                throw new PackageLoadError("invalidPackageZipChecksum", packageUri.getDisplayName(), checksum, expectedChecksum, dependencyMetadata.getPackageZipUrl());
            }
        }

        protected void verifyPackageMetadataBytes(PackageUri packageUri, URI requestUri, Checksums checksums, byte[] computedChecksum) {
            String expectedChecksum = checksums.getSha256();
            String checksum = ByteArrayUtils.toHex(computedChecksum);
            if (IoUtils.isTestMode() && expectedChecksum.equals("$skipChecksumVerification")) {
                return;
            }
            if (!checksum.equals(expectedChecksum)) {
                throw new PackageLoadError("invalidPackageMetadataChecksum", packageUri.getDisplayName(), checksum, expectedChecksum, requestUri);
            }
        }

        protected InputStream openExternalUri(URI uri) throws SecurityManagerException {
            HttpResponse<InputStream> response;
            if (!HttpUtils.isHttpUrl(uri)) {
                throw new IllegalArgumentException("Expected HTTP(S) URL, but got: " + uri);
            }
            this.securityManager.checkReadResource(uri);
            HttpRequest request = HttpRequest.newBuilder(uri).build();
            try {
                response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            }
            catch (IOException e2) {
                throw new PackageLoadError(e2, "ioErrorMakingHttpGet", uri, e2.getMessage());
            }
            try {
                HttpUtils.checkHasStatusCode200(response);
            }
            catch (IOException e3) {
                throw new PackageLoadError("badHttpStatusCode", response.statusCode(), response.uri());
            }
            return response.body();
        }

        protected IOException fileIsADirectory() {
            return new IOException("Is a directory");
        }

        protected abstract DependencyMetadata doGetDependencyMetadata(PackageUri var1, @Nullable Checksums var2) throws IOException, SecurityManagerException;

        protected abstract List<PathElement> doListElements(PackageAssetUri var1, @Nullable Checksums var2) throws IOException, SecurityManagerException;

        protected abstract boolean doHasElement(PackageAssetUri var1, @Nullable Checksums var2) throws IOException, SecurityManagerException;

        protected PackageLoadError invalidPackageZipUrl(PackageUri packageUri, DependencyMetadata dependencyMetadata) {
            return new PackageLoadError("invalidPackageZipUrl", packageUri.getDisplayName(), dependencyMetadata.getPackageZipUrl());
        }

        private void checkNotClosed() {
            if (this.isClosed.get()) {
                throw new IllegalStateException("Package resolver has already been closed.");
            }
        }
    }
}

