/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.http;

import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.pkl.core.Release;
import org.pkl.core.http.HttpClient;
import org.pkl.core.http.JdkHttpClient;
import org.pkl.core.http.LazyHttpClient;
import org.pkl.core.http.ProxySelector;
import org.pkl.core.http.RequestRewritingClient;

final class HttpClientBuilder
implements HttpClient.Builder {
    private String userAgent;
    private Duration connectTimeout = Duration.ofSeconds(60L);
    private Duration requestTimeout = Duration.ofSeconds(60L);
    private final List<Path> certificateFiles = new ArrayList<Path>();
    private final List<ByteBuffer> certificateBytes = new ArrayList<ByteBuffer>();
    private int testPort = -1;
    private java.net.ProxySelector proxySelector;

    HttpClientBuilder() {
        Release release = Release.current();
        this.userAgent = "Pkl/" + release.version() + " (" + release.os() + "; " + release.flavor() + ")";
    }

    @Override
    public HttpClient.Builder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public HttpClient.Builder setConnectTimeout(Duration timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    @Override
    public HttpClient.Builder setRequestTimeout(Duration timeout) {
        this.requestTimeout = timeout;
        return this;
    }

    @Override
    public HttpClient.Builder addCertificates(Path path2) {
        this.certificateFiles.add(path2);
        return this;
    }

    @Override
    public HttpClient.Builder addCertificates(byte[] certificateBytes) {
        this.certificateBytes.add(ByteBuffer.wrap(certificateBytes));
        return this;
    }

    @Override
    public HttpClient.Builder setTestPort(int port) {
        this.testPort = port;
        return this;
    }

    @Override
    public HttpClient.Builder setProxySelector(java.net.ProxySelector proxySelector) {
        this.proxySelector = proxySelector;
        return this;
    }

    @Override
    public HttpClient.Builder setProxy(URI proxyAddress2, List<String> noProxy2) {
        this.proxySelector = new ProxySelector(proxyAddress2, noProxy2);
        return this;
    }

    @Override
    public HttpClient build() {
        return this.doBuild().get();
    }

    @Override
    public HttpClient buildLazily() {
        return new LazyHttpClient(this.doBuild());
    }

    private Supplier<HttpClient> doBuild() {
        List<Path> certificateFiles = List.copyOf(this.certificateFiles);
        java.net.ProxySelector proxySelector = this.proxySelector != null ? this.proxySelector : java.net.ProxySelector.getDefault();
        return () -> {
            JdkHttpClient jdkClient = new JdkHttpClient(certificateFiles, this.certificateBytes, this.connectTimeout, proxySelector);
            return new RequestRewritingClient(this.userAgent, this.requestTimeout, this.testPort, jdkClient);
        };
    }
}

