/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.List;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public final class TypeAliasNode
extends ExpressionNode {
    private final SourceSection headerSection;
    @Nullable
    private final SourceSection docComment;
    @Node.Children
    private final ExpressionNode[] annotationNodes;
    private final int modifiers;
    private final String simpleName;
    private final String qualifiedName;
    private final List<TypeParameter> typeParameters;
    @Node.Child
    private UnresolvedTypeNode typeAnnotationNode;
    @CompilerDirectives.CompilationFinal
    @Nullable
    private VmTypeAlias cachedTypeAlias;

    public TypeAliasNode(SourceSection sourceSection, SourceSection headerSection, @Nullable SourceSection docComment, ExpressionNode[] annotationNodes, int modifiers, String simpleName2, String qualifiedName, List<TypeParameter> typeParameters, UnresolvedTypeNode typeAnnotationNode) {
        super(sourceSection);
        this.headerSection = headerSection;
        this.docComment = docComment;
        this.annotationNodes = annotationNodes;
        this.modifiers = modifiers;
        this.simpleName = simpleName2;
        this.qualifiedName = qualifiedName;
        this.typeParameters = typeParameters;
        this.typeAnnotationNode = typeAnnotationNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.cachedTypeAlias != null) {
            return this.cachedTypeAlias;
        }
        CompilerDirectives.transferToInterpreter();
        ArrayList<VmTyped> annotations = new ArrayList<VmTyped>();
        VmTyped module = VmUtils.getTypedObjectReceiver(frame);
        this.cachedTypeAlias = new VmTypeAlias(this.getSourceSection(), this.headerSection, this.docComment, this.modifiers, annotations, this.simpleName, module, this.qualifiedName, this.typeParameters, frame.materialize());
        VmUtils.evaluateAnnotations(frame, this.annotationNodes, annotations);
        this.cachedTypeAlias.initTypeCheckNode(this.typeAnnotationNode.execute(frame));
        return this.cachedTypeAlias;
    }
}

