/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.frame;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.frame.WriteFrameSlotNode;
import org.pkl.core.runtime.VmTypesGen;

@GeneratedBy(value=WriteFrameSlotNode.class)
public final class WriteFrameSlotNodeGen
extends WriteFrameSlotNode {
    @Node.Child
    private ExpressionNode valueNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private WriteFrameSlotNodeGen(SourceSection sourceSection, int slot, ExpressionNode valueNode) {
        super(sourceSection, slot);
        this.valueNode_ = valueNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0xE) == 0 && state_0 != 0) {
            return this.executeGeneric_long0(state_0, frameValue);
        }
        if ((state_0 & 0xB) == 0 && state_0 != 0) {
            return this.executeGeneric_double1(state_0, frameValue);
        }
        if ((state_0 & 7) == 0 && state_0 != 0) {
            return this.executeGeneric_boolean2(state_0, frameValue);
        }
        return this.executeGeneric_generic3(state_0, frameValue);
    }

    private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
        long valueNodeValue_;
        int state_0 = state_0__;
        try {
            valueNodeValue_ = this.valueNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        if (this.isIntOrIllegal(frameValue)) {
            return this.evalInt(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valueNodeValue_);
    }

    private Object executeGeneric_double1(int state_0__, VirtualFrame frameValue) {
        double valueNodeValue_;
        int state_0 = state_0__;
        try {
            valueNodeValue_ = this.valueNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        if (this.isFloatOrIllegal(frameValue)) {
            return this.evalFloat(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valueNodeValue_);
    }

    private Object executeGeneric_boolean2(int state_0__, VirtualFrame frameValue) {
        boolean valueNodeValue_;
        int state_0 = state_0__;
        try {
            valueNodeValue_ = this.valueNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        if (this.isBooleanOrIllegal(frameValue)) {
            return this.evalBoolean(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valueNodeValue_);
    }

    private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && valueNodeValue_ instanceof Long) {
                long valueNodeValue__ = (Long)valueNodeValue_;
                if (this.isIntOrIllegal(frameValue)) {
                    return this.evalInt(frameValue, valueNodeValue__);
                }
            }
            if ((state_0 & 4) != 0 && valueNodeValue_ instanceof Double) {
                double valueNodeValue__ = (Double)valueNodeValue_;
                if (this.isFloatOrIllegal(frameValue)) {
                    return this.evalFloat(frameValue, valueNodeValue__);
                }
            }
            if ((state_0 & 8) != 0 && valueNodeValue_ instanceof Boolean) {
                boolean valueNodeValue__ = (Boolean)valueNodeValue_;
                if (this.isBooleanOrIllegal(frameValue)) {
                    return this.evalBoolean(frameValue, valueNodeValue__);
                }
            }
            if ((state_0 & 2) != 0) {
                return this.evalGeneric(frameValue, valueNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, valueNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean valueNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 2) != 0) {
            return VmTypesGen.expectBoolean(this.executeGeneric(frameValue));
        }
        try {
            valueNodeValue_ = this.valueNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return VmTypesGen.expectBoolean(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 8) != 0 && this.isBooleanOrIllegal(frameValue)) {
            return this.evalBoolean(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return VmTypesGen.expectBoolean(this.executeAndSpecialize(frameValue, valueNodeValue_));
    }

    @Override
    public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
        double valueNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 2) != 0) {
            return VmTypesGen.expectDouble(this.executeGeneric(frameValue));
        }
        try {
            valueNodeValue_ = this.valueNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return VmTypesGen.expectDouble(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 4) != 0 && this.isFloatOrIllegal(frameValue)) {
            return this.evalFloat(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return VmTypesGen.expectDouble(this.executeAndSpecialize(frameValue, valueNodeValue_));
    }

    @Override
    public long executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        long valueNodeValue_;
        int state_0 = this.state_0_;
        if ((state_0 & 2) != 0) {
            return VmTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        try {
            valueNodeValue_ = this.valueNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return VmTypesGen.expectLong(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state_0 & 1) != 0 && this.isIntOrIllegal(frameValue)) {
            return this.evalInt(frameValue, valueNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return VmTypesGen.expectLong(this.executeAndSpecialize(frameValue, valueNodeValue_));
    }

    @Override
    public void executeWithValue(VirtualFrame frameValue, Object valueNodeValue) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                if (this.isIntOrIllegal(frameValue)) {
                    this.evalInt(frameValue, valueNodeValue_);
                    return;
                }
            }
            if ((state_0 & 4) != 0 && valueNodeValue instanceof Double) {
                double valueNodeValue_ = (Double)valueNodeValue;
                if (this.isFloatOrIllegal(frameValue)) {
                    this.evalFloat(frameValue, valueNodeValue_);
                    return;
                }
            }
            if ((state_0 & 8) != 0 && valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                if (this.isBooleanOrIllegal(frameValue)) {
                    this.evalBoolean(frameValue, valueNodeValue_);
                    return;
                }
            }
            if ((state_0 & 2) != 0) {
                this.evalGeneric(frameValue, valueNodeValue);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, valueNodeValue);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object valueNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0 && valueNodeValue instanceof Long) {
            long valueNodeValue_ = (Long)valueNodeValue;
            if (this.isIntOrIllegal(frameValue)) {
                this.state_0_ = state_0 |= 1;
                return this.evalInt(frameValue, valueNodeValue_);
            }
        }
        if ((state_0 & 2) == 0 && valueNodeValue instanceof Double) {
            double valueNodeValue_ = (Double)valueNodeValue;
            if (this.isFloatOrIllegal(frameValue)) {
                this.state_0_ = state_0 |= 4;
                return this.evalFloat(frameValue, valueNodeValue_);
            }
        }
        if ((state_0 & 2) == 0 && valueNodeValue instanceof Boolean) {
            boolean valueNodeValue_ = (Boolean)valueNodeValue;
            if (this.isBooleanOrIllegal(frameValue)) {
                this.state_0_ = state_0 |= 8;
                return this.evalBoolean(frameValue, valueNodeValue_);
            }
        }
        state_0 &= 0xFFFFFFF2;
        this.state_0_ = state_0 |= 2;
        return this.evalGeneric(frameValue, valueNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @NeverDefault
    public static WriteFrameSlotNode create(SourceSection sourceSection, int slot, ExpressionNode valueNode) {
        return new WriteFrameSlotNodeGen(sourceSection, slot, valueNode);
    }
}

