/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.expression.unary.AbstractImportNode;
import org.pkl.core.ast.expression.unary.ImportGlobMemberBodyNode;
import org.pkl.core.ast.member.SharedMemberNode;
import org.pkl.core.http.HttpClientInitException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmObjectBuilder;
import org.pkl.core.util.GlobResolver;
import org.pkl.core.util.LateInit;

@NodeInfo(shortName="import*")
public class ImportGlobNode
extends AbstractImportNode {
    private final String globPattern;
    @Node.Child
    @LateInit
    private SharedMemberNode memberNode;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private VmMapping cachedResult;

    public ImportGlobNode(SourceSection sourceSection, ResolvedModuleKey currentModule, URI importUri, String globPattern) {
        super(sourceSection, currentModule, importUri);
        this.globPattern = globPattern;
    }

    private SharedMemberNode getMemberNode() {
        if (this.memberNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            VmLanguage language = VmLanguage.get(this);
            this.memberNode = new SharedMemberNode(this.sourceSection, this.sourceSection, "", language, new FrameDescriptor(), new ImportGlobMemberBodyNode(this.sourceSection, language, this.currentModule));
        }
        return this.memberNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.cachedResult != null) {
            return this.cachedResult;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        VmContext context2 = VmContext.get(this);
        try {
            ModuleKey moduleKey = context2.getModuleResolver().resolve(this.importUri);
            if (!moduleKey.isGlobbable()) {
                throw this.exceptionBuilder().evalError("cannotGlobUri", this.importUri, this.importUri.getScheme()).build();
            }
            Map<String, GlobResolver.ResolvedGlobElement> resolvedElements = GlobResolver.resolveGlob(context2.getSecurityManager(), moduleKey, this.currentModule.getOriginal(), this.currentModule.getUri(), this.globPattern);
            VmObjectBuilder builder = new VmObjectBuilder(resolvedElements.size());
            for (Map.Entry<String, GlobResolver.ResolvedGlobElement> entry : resolvedElements.entrySet()) {
                builder.addEntry((Object)entry.getKey(), this.getMemberNode());
            }
            this.cachedResult = builder.toMapping(resolvedElements);
            return this.cachedResult;
        }
        catch (IOException e2) {
            throw this.exceptionBuilder().evalError("ioErrorResolvingGlob", this.importUri).withCause(e2).build();
        }
        catch (SecurityManagerException | HttpClientInitException e3) {
            throw this.exceptionBuilder().withCause(e3).build();
        }
        catch (PackageLoadError e4) {
            throw this.exceptionBuilder().adhocEvalError(e4.getMessage(), new Object[0]).build();
        }
        catch (GlobResolver.InvalidGlobPatternException e5) {
            throw this.exceptionBuilder().evalError("invalidGlobPattern", this.globPattern).withHint(e5.getMessage()).build();
        }
    }
}

