/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.util.LateInit;

public final class InferParentWithinMethodNode
extends ExpressionNode {
    private final VmLanguage language;
    private final Identifier methodName;
    @Node.Child
    private ExpressionNode ownerNode;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private Object inferredParent;

    public InferParentWithinMethodNode(SourceSection sourceSection, VmLanguage language, Identifier methodName, ExpressionNode ownerNode) {
        super(sourceSection);
        this.language = language;
        this.methodName = methodName;
        this.ownerNode = ownerNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.inferredParent != null) {
            return this.inferredParent;
        }
        CompilerDirectives.transferToInterpreter();
        VmObjectLike owner = (VmObjectLike)this.ownerNode.executeGeneric(frame);
        assert (owner.isPrototype());
        ClassMethod method = owner.getVmClass().getDeclaredMethod(this.methodName);
        assert (method != null);
        TypeNode returnTypeNode = method.getReturnTypeNode();
        if (returnTypeNode == null || returnTypeNode instanceof TypeNode.UnknownTypeNode) {
            this.inferredParent = VmDynamic.empty();
            this.ownerNode = null;
            return this.inferredParent;
        }
        Object returnTypeDefaultValue = returnTypeNode.createDefaultValue(this.language, method.getHeaderSection(), method.getQualifiedName());
        if (returnTypeDefaultValue != null) {
            this.inferredParent = returnTypeDefaultValue;
            this.ownerNode = null;
            return this.inferredParent;
        }
        throw this.exceptionBuilder().evalError("cannotInferParent", new Object[0]).build();
    }
}

