/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.source.SourceSection;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.AmendFunctionNode;
import org.pkl.core.ast.expression.literal.PropertiesLiteralNodeGen;
import org.pkl.core.ast.expression.literal.SpecializedObjectLiteralNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.util.Nullable;

public abstract class PropertiesLiteralNode
extends SpecializedObjectLiteralNode {
    public PropertiesLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes, UnmodifiableEconomicMap<Object, ObjectMember> properties) {
        super(sourceSection, language, qualifiedScopeName, isCustomThisScope, parametersDescriptor, parameterTypes, properties);
    }

    @Override
    public PropertiesLiteralNode copy(ExpressionNode newParentNode) {
        return PropertiesLiteralNodeGen.create(this.sourceSection, this.language, this.qualifiedScopeName, this.isCustomThisScope, null, new UnresolvedTypeNode[0], this.members, newParentNode);
    }

    @Specialization(guards={"parentClass == parent.getVmClass()", "checkIsValidTypedAmendment(parentClass)"})
    protected Object evalTypedObjectCached(VirtualFrame frame, VmTyped parent, @Cached(value="parent.getVmClass()") VmClass parentClass) {
        assert (PropertiesLiteralNode.isTypedObjectClass(parentClass));
        return new VmTyped(frame.materialize(), parent, parentClass, this.members);
    }

    @Specialization(guards={"checkIsValidTypedAmendment(parent)"})
    protected Object evalTypedObjectUncached(VirtualFrame frame, VmTyped parent) {
        assert (PropertiesLiteralNode.isTypedObjectClass(parent.getVmClass()));
        return new VmTyped(frame.materialize(), parent, parent.getVmClass(), this.members);
    }

    @Specialization
    protected Object evalDynamic(VirtualFrame frame, VmDynamic parent) {
        return new VmDynamic(frame.materialize(), (VmObject)parent, (UnmodifiableEconomicMap<Object, ObjectMember>)this.members, parent.getLength());
    }

    @Specialization(guards={"checkIsValidListingAmendment()"})
    protected Object evalListing(VirtualFrame frame, VmListing parent) {
        return new VmListing(frame.materialize(), (VmObject)parent, (UnmodifiableEconomicMap<Object, ObjectMember>)this.members, parent.getLength());
    }

    @ExplodeLoop
    @Specialization(guards={"checkIsValidMappingAmendment()"})
    protected Object evalMapping(VirtualFrame frame, VmMapping parent) {
        return new VmMapping(frame.materialize(), parent, this.members);
    }

    @Specialization
    protected Object evalNull(VirtualFrame frame, VmNull parent) {
        return this.executeWithParent(frame, parent.getDefaultValue());
    }

    @Specialization(guards={"checkIsValidFunctionAmendment(parent)"})
    protected VmFunction evalFunction(VirtualFrame frame, VmFunction parent, @Cached(value="createAmendFunctionNode(frame)", neverDefault=true) AmendFunctionNode amendFunctionNode) {
        return amendFunctionNode.execute(frame, parent);
    }

    @Specialization(guards={"parent == cachedParent", "isTypedObjectClass(cachedParent)", "checkIsValidTypedAmendment(cachedParent)"})
    protected VmTyped evalTypedObjectClassCached(VirtualFrame frame, VmClass parent, @Cached(value="parent") VmClass cachedParent) {
        return new VmTyped(frame.materialize(), parent.getPrototype(), parent, this.members);
    }

    @Specialization(guards={"parent == cachedParent", "cachedParent.isListingClass()", "checkIsValidListingAmendment()"})
    protected VmListing evalListingClass(VirtualFrame frame, VmClass parent, @Cached(value="parent") VmClass cachedParent) {
        return new VmListing(frame.materialize(), (VmObject)BaseModule.getListingClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)this.members, 0);
    }

    @Specialization(guards={"parent == cachedParent", "cachedParent.isMappingClass()", "checkIsValidMappingAmendment()"})
    protected VmMapping evalMappingClass(VirtualFrame frame, VmClass parent, @Cached(value="parent") VmClass cachedParent) {
        return new VmMapping(frame.materialize(), BaseModule.getMappingClass().getPrototype(), this.members);
    }

    @Specialization(guards={"parent == cachedParent", "cachedParent.isDynamicClass()"})
    protected VmDynamic evalDynamicClass(VirtualFrame frame, VmClass parent, @Cached(value="parent") VmClass cachedParent) {
        return new VmDynamic(frame.materialize(), (VmObject)BaseModule.getDynamicClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)this.members, 0);
    }

    @Specialization
    protected Object evalClassUncached(VirtualFrame frame, VmClass parent) {
        if (parent.isListingClass()) {
            this.checkIsValidListingAmendment();
            this.checkMaxListingMemberIndex(0);
            return this.evalListingClass(frame, parent, parent);
        }
        if (parent.isMappingClass()) {
            this.checkIsValidMappingAmendment();
            return this.evalMappingClass(frame, parent, parent);
        }
        if (parent.isDynamicClass()) {
            return new VmDynamic(frame.materialize(), (VmObject)BaseModule.getDynamicClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)this.members, 0);
        }
        this.checkIsValidTypedAmendment(parent);
        return new VmTyped(frame.materialize(), parent.getPrototype(), parent, this.members);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected void fallback(Object parent) {
        this.checkIsValidTypedAmendment(parent);
        throw this.exceptionBuilder().unreachableCode().build();
    }
}

