/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.expression.generator.GeneratorObjectLiteralNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;

@ImportStatic(value={BaseModule.class, GeneratorObjectLiteralNode.class})
public abstract class GeneratorPropertyNode
extends GeneratorMemberNode {
    protected final ObjectMember member;

    protected GeneratorPropertyNode(ObjectMember member) {
        super(member.getSourceSection());
        this.member = member;
        assert (member.isProp());
    }

    @Specialization
    protected void evalDynamic(VmDynamic parent, GeneratorMemberNode.ObjectData data) {
        this.addProperty(data);
    }

    @Specialization(guards={"checkIsValidTypedProperty(parent.getVmClass(), member)"})
    protected void evalTyped(VmTyped parent, GeneratorMemberNode.ObjectData data) {
        this.addProperty(data);
    }

    @Specialization(guards={"checkIsValidMappingProperty()"})
    protected void evalMapping(VmMapping parent, GeneratorMemberNode.ObjectData data) {
        this.addProperty(data);
    }

    @Specialization(guards={"checkIsValidListingProperty()"})
    protected void evalListing(VmListing parent, GeneratorMemberNode.ObjectData data) {
        this.addProperty(data);
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected void evalDynamicClass(VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addProperty(data);
    }

    @Specialization(guards={"parent == getMappingClass()", "checkIsValidMappingProperty()"})
    protected void evalMappingClass(VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addProperty(data);
    }

    @Specialization(guards={"parent == getListingClass()", "checkIsValidListingProperty()"})
    protected void evalListingClass(VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addProperty(data);
    }

    @Specialization(guards={"isTypedObjectClass(parent)", "checkIsValidTypedProperty(parent, member)"})
    protected void evalTypedObjectClass(VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addProperty(data);
    }

    @Fallback
    void fallback(Object parent, GeneratorMemberNode.ObjectData data) {
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("objectCannotHaveProperty", parent instanceof VmClass ? parent : VmUtils.getClass(parent)).withSourceSection(this.member.getHeaderSection()).build();
    }

    @Idempotent
    protected boolean checkIsValidListingProperty() {
        if (this.member.isLocal() || this.member.getName() == Identifier.DEFAULT) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("objectCannotHaveProperty", BaseModule.getListingClass()).withSourceSection(this.member.getHeaderSection()).build();
    }

    @Idempotent
    protected boolean checkIsValidMappingProperty() {
        if (this.member.isLocal() || this.member.getName() == Identifier.DEFAULT) {
            return true;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("objectCannotHaveProperty", BaseModule.getMappingClass()).withSourceSection(this.member.getHeaderSection()).build();
    }

    private void addProperty(GeneratorMemberNode.ObjectData data) {
        if (EconomicMaps.put(data.members, this.member.getName(), this.member) == null) {
            return;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.duplicateDefinition(this.member.getName(), this.member);
    }
}

