/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.List;
import java.util.Objects;
import org.pkl.core.util.Nullable;

public final class StackFrame {
    private final String moduleUri;
    @Nullable
    private final String memberName;
    private final List<String> sourceLines;
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;

    public StackFrame(String moduleUri, @Nullable String memberName, List<String> sourceLines, int startLine, int startColumn, int endLine, int endColumn) {
        assert (startLine >= 1);
        assert (startColumn >= 1);
        assert (endLine >= 1);
        assert (endColumn >= 1);
        assert (startLine <= endLine);
        assert (startLine < endLine || startColumn <= endColumn);
        this.moduleUri = moduleUri;
        this.memberName = memberName;
        this.sourceLines = sourceLines;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public String getModuleUri() {
        return this.moduleUri;
    }

    public StackFrame withModuleUri(String moduleUri) {
        return new StackFrame(moduleUri, this.memberName, this.sourceLines, this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    @Nullable
    public String getMemberName() {
        return this.memberName;
    }

    public List<String> getSourceLines() {
        return this.sourceLines;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StackFrame)) {
            return false;
        }
        StackFrame other = (StackFrame)obj;
        if (this.startLine != other.startLine) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.endColumn != other.endColumn) {
            return false;
        }
        if (!this.moduleUri.equals(other.moduleUri)) {
            return false;
        }
        if (!Objects.equals(this.memberName, other.memberName)) {
            return false;
        }
        return this.sourceLines.equals(other.sourceLines);
    }

    public int hashCode() {
        int result = this.moduleUri.hashCode();
        result = 31 * result + Objects.hashCode(this.memberName);
        result = 31 * result + this.sourceLines.hashCode();
        result = 31 * result + this.startLine;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endColumn;
        return result;
    }
}

