/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.Serializable;
import java.util.List;
import org.pkl.core.PClass;
import org.pkl.core.TypeAlias;
import org.pkl.core.TypeParameter;

public abstract class PType
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final PType UNKNOWN = new PType(){
        private static final long serialVersionUID = 0L;
    };
    public static final PType NOTHING = new PType(){
        private static final long serialVersionUID = 0L;
    };
    public static final PType MODULE = new PType(){
        private static final long serialVersionUID = 0L;
    };

    private PType() {
    }

    public List<PType> getTypeArguments() {
        return List.of();
    }

    public static final class TypeVariable
    extends PType {
        private static final long serialVersionUID = 0L;
        private final TypeParameter typeParameter;

        public TypeVariable(TypeParameter typeParameter) {
            this.typeParameter = typeParameter;
        }

        public String getName() {
            return this.typeParameter.getName();
        }

        public TypeParameter getTypeParameter() {
            return this.typeParameter;
        }
    }

    public static final class Union
    extends PType {
        private static final long serialVersionUID = 0L;
        private final List<PType> elementTypes;

        public Union(List<PType> elementTypes) {
            this.elementTypes = elementTypes;
        }

        public List<PType> getElementTypes() {
            return this.elementTypes;
        }
    }

    public static final class Function
    extends PType {
        private static final long serialVersionUID = 0L;
        private final List<PType> parameterTypes;
        private final PType returnType;

        public Function(List<PType> parameterTypes, PType returnType) {
            this.parameterTypes = parameterTypes;
            this.returnType = returnType;
        }

        public List<PType> getParameterTypes() {
            return this.parameterTypes;
        }

        public PType getReturnType() {
            return this.returnType;
        }
    }

    public static final class Alias
    extends PType {
        private static final long serialVersionUID = 0L;
        private final TypeAlias typeAlias;
        private final List<PType> typeArguments;
        private final PType aliasedType;

        public Alias(TypeAlias typeAlias) {
            this(typeAlias, List.of(), typeAlias.getAliasedType());
        }

        public Alias(TypeAlias typeAlias, List<PType> typeArguments, PType aliasedType) {
            this.typeAlias = typeAlias;
            this.typeArguments = typeArguments;
            this.aliasedType = aliasedType;
        }

        public TypeAlias getTypeAlias() {
            return this.typeAlias;
        }

        @Override
        public List<PType> getTypeArguments() {
            return this.typeArguments;
        }

        public PType getAliasedType() {
            return this.aliasedType;
        }
    }

    public static final class Constrained
    extends PType {
        private static final long serialVersionUID = 0L;
        private final PType baseType;
        private final List<String> constraints;

        public Constrained(PType baseType, List<String> constraints) {
            this.baseType = baseType;
            this.constraints = constraints;
        }

        public PType getBaseType() {
            return this.baseType;
        }

        public List<String> getConstraints() {
            return this.constraints;
        }
    }

    public static final class Nullable
    extends PType {
        private static final long serialVersionUID = 0L;
        private final PType baseType;

        public Nullable(PType baseType) {
            this.baseType = baseType;
        }

        public PType getBaseType() {
            return this.baseType;
        }
    }

    public static final class Class
    extends PType {
        private static final long serialVersionUID = 0L;
        private final PClass pClass;
        private final List<PType> typeArguments;

        public Class(PClass pClass, List<PType> typeArguments) {
            this.pClass = pClass;
            this.typeArguments = typeArguments;
        }

        public Class(PClass pClass) {
            this(pClass, List.of());
        }

        public Class(PClass pClass, PType typeArgument1) {
            this(pClass, List.of(typeArgument1));
        }

        public Class(PClass pClass, PType typeArgument1, PType typeArgument2) {
            this(pClass, List.of(typeArgument1, typeArgument2));
        }

        public PClass getPClass() {
            return this.pClass;
        }

        @Override
        public List<PType> getTypeArguments() {
            return this.typeArguments;
        }
    }

    public static final class StringLiteral
    extends PType {
        private static final long serialVersionUID = 0L;
        private final String literal;

        public StringLiteral(String literal) {
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }
    }
}

