/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.commons.cli;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pkl.commons.cli.CliBaseOptions;
import org.pkl.commons.cli.CliBugException;
import org.pkl.commons.cli.CliException;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.Loggers;
import org.pkl.core.ModuleSource;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.project.Project;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.settings.PklSettings;
import org.pkl.core.util.IoUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010M\u001a\u00020NH$J\b\u0010O\u001a\u00020PH\u0004J\u0010\u0010Q\u001a\u0002002\u0006\u0010R\u001a\u00020%H\u0004J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020T0\u00062\u0006\u0010U\u001a\u00020VH\u0004J\u0016\u0010W\u001a\b\u0012\u0004\u0012\u00020X0\u00062\u0006\u0010U\u001a\u00020VH\u0002J\u0006\u0010Y\u001a\u00020NJ\f\u0010Z\u001a\u00020N*\u00020[H\u0002R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R'\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00128DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000b\u001a\u0004\b\u0019\u0010\u001aR'\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00128DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000b\u001a\u0004\b\u001d\u0010\u0015R\u001b\u0010\u001f\u001a\u00020 8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u000b\u001a\u0004\b!\u0010\"R\u001d\u0010$\u001a\u0004\u0018\u00010%8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\u000b\u001a\u0004\b&\u0010'R!\u0010)\u001a\b\u0012\u0004\u0012\u00020%0\u00068DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u000b\u001a\u0004\b*\u0010\tR#\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u000b\u001a\u0004\b-\u0010\tR\u001d\u0010/\u001a\u0004\u0018\u0001008DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u0010\u000b\u001a\u0004\b1\u00102R\u001d\u00104\u001a\u0004\u0018\u0001058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u000b\u001a\u0004\b6\u00107R\u001d\u00109\u001a\u0004\u0018\u00010%8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u000b\u001a\u0004\b:\u0010'R\u001b\u0010<\u001a\u00020=8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u000b\u001a\u0004\b>\u0010?R!\u0010A\u001a\u00020B8DX\u0084\u0084\u0002\u00a2\u0006\u0012\n\u0004\bG\u0010\u000b\u0012\u0004\bC\u0010D\u001a\u0004\bE\u0010FR\u001b\u0010H\u001a\u00020I8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\bL\u0010\u000b\u001a\u0004\bJ\u0010K\u00a8\u0006\\"}, d2={"Lorg/pkl/commons/cli/CliCommand;", "", "cliOptions", "Lorg/pkl/commons/cli/CliBaseOptions;", "(Lorg/pkl/commons/cli/CliBaseOptions;)V", "allowedModules", "", "Ljava/util/regex/Pattern;", "getAllowedModules", "()Ljava/util/List;", "allowedModules$delegate", "Lkotlin/Lazy;", "allowedResources", "getAllowedResources", "allowedResources$delegate", "getCliOptions", "()Lorg/pkl/commons/cli/CliBaseOptions;", "environmentVariables", "", "", "getEnvironmentVariables", "()Ljava/util/Map;", "environmentVariables$delegate", "evaluatorSettings", "Lorg/pkl/core/evaluatorSettings/PklEvaluatorSettings;", "getEvaluatorSettings", "()Lorg/pkl/core/evaluatorSettings/PklEvaluatorSettings;", "evaluatorSettings$delegate", "externalProperties", "getExternalProperties", "externalProperties$delegate", "httpClient", "Lorg/pkl/core/http/HttpClient;", "getHttpClient", "()Lorg/pkl/core/http/HttpClient;", "httpClient$delegate", "moduleCacheDir", "Ljava/nio/file/Path;", "getModuleCacheDir", "()Ljava/nio/file/Path;", "moduleCacheDir$delegate", "modulePath", "getModulePath", "modulePath$delegate", "noProxy", "getNoProxy", "noProxy$delegate", "project", "Lorg/pkl/core/project/Project;", "getProject", "()Lorg/pkl/core/project/Project;", "project$delegate", "proxyAddress", "Ljava/net/URI;", "getProxyAddress", "()Ljava/net/URI;", "proxyAddress$delegate", "rootDir", "getRootDir", "rootDir$delegate", "securityManager", "Lorg/pkl/core/SecurityManager;", "getSecurityManager", "()Lorg/pkl/core/SecurityManager;", "securityManager$delegate", "settings", "Lorg/pkl/core/settings/PklSettings;", "getSettings$annotations", "()V", "getSettings", "()Lorg/pkl/core/settings/PklSettings;", "settings$delegate", "stackFrameTransformer", "Lorg/pkl/core/StackFrameTransformer;", "getStackFrameTransformer", "()Lorg/pkl/core/StackFrameTransformer;", "stackFrameTransformer$delegate", "doRun", "", "evaluatorBuilder", "Lorg/pkl/core/EvaluatorBuilder;", "loadProject", "projectFile", "moduleKeyFactories", "Lorg/pkl/core/module/ModuleKeyFactory;", "modulePathResolver", "Lorg/pkl/core/module/ModulePathResolver;", "resourceReaders", "Lorg/pkl/core/resource/ResourceReader;", "run", "addDefaultCliCertificates", "Lorg/pkl/core/http/HttpClient$Builder;", "pkl-commons-cli"})
public abstract class CliCommand {
    @NotNull
    private final CliBaseOptions cliOptions;
    @NotNull
    private final Lazy settings$delegate;
    @NotNull
    private final Lazy project$delegate;
    @NotNull
    private final Lazy evaluatorSettings$delegate;
    @NotNull
    private final Lazy allowedModules$delegate;
    @NotNull
    private final Lazy allowedResources$delegate;
    @NotNull
    private final Lazy rootDir$delegate;
    @NotNull
    private final Lazy environmentVariables$delegate;
    @NotNull
    private final Lazy externalProperties$delegate;
    @NotNull
    private final Lazy moduleCacheDir$delegate;
    @NotNull
    private final Lazy modulePath$delegate;
    @NotNull
    private final Lazy stackFrameTransformer$delegate;
    @NotNull
    private final Lazy securityManager$delegate;
    @NotNull
    private final Lazy proxyAddress$delegate;
    @NotNull
    private final Lazy noProxy$delegate;
    @NotNull
    private final Lazy httpClient$delegate;

    public CliCommand(@NotNull CliBaseOptions cliOptions) {
        Intrinsics.checkNotNullParameter(cliOptions, "cliOptions");
        this.cliOptions = cliOptions;
        this.settings$delegate = LazyKt.lazy((Function0)new Function0<PklSettings>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PklSettings invoke() {
                PklSettings pklSettings;
                try {
                    pklSettings = this.this$0.getCliOptions().getNormalizedSettingsModule() != null ? PklSettings.load(ModuleSource.uri(this.this$0.getCliOptions().getNormalizedSettingsModule())) : PklSettings.loadFromPklHomeDir();
                }
                catch (PklException e2) {
                    throw new CliException(e2.toString(), 0, 2, null);
                }
                PklSettings pklSettings2 = pklSettings;
                Intrinsics.checkNotNullExpressionValue(pklSettings2, "try {\n      if (cliOptio\u2026ption(e.toString())\n    }");
                return pklSettings2;
            }
        });
        this.project$delegate = LazyKt.lazy((Function0)new Function0<Project>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Project invoke() {
                Project project2;
                if (this.this$0.getCliOptions().getNoProject()) {
                    project2 = null;
                } else {
                    Path path2 = this.this$0.getCliOptions().getNormalizedProjectFile();
                    if (path2 != null) {
                        Path path3 = path2;
                        CliCommand cliCommand = this.this$0;
                        Path it = path3;
                        boolean bl = false;
                        project2 = cliCommand.loadProject(it);
                    } else {
                        project2 = null;
                    }
                }
                return project2;
            }
        });
        this.evaluatorSettings$delegate = LazyKt.lazy((Function0)new Function0<PklEvaluatorSettings>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final PklEvaluatorSettings invoke() {
                PklEvaluatorSettings pklEvaluatorSettings;
                if (this.this$0.getCliOptions().getOmitProjectSettings()) {
                    pklEvaluatorSettings = null;
                } else {
                    Project project2 = this.this$0.getProject();
                    pklEvaluatorSettings = project2 != null ? project2.getEvaluatorSettings() : null;
                }
                return pklEvaluatorSettings;
            }
        });
        this.allowedModules$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Pattern>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<Pattern> invoke() {
                List<Pattern> list = this.this$0.getCliOptions().getAllowedModules();
                if (list == null) {
                    PklEvaluatorSettings pklEvaluatorSettings = CliCommand.access$getEvaluatorSettings(this.this$0);
                    list = pklEvaluatorSettings != null ? pklEvaluatorSettings.allowedModules() : null;
                    if (list == null) {
                        list = SecurityManagers.defaultAllowedModules;
                    }
                }
                return list;
            }
        });
        this.allowedResources$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Pattern>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<Pattern> invoke() {
                List<Pattern> list = this.this$0.getCliOptions().getAllowedResources();
                if (list == null) {
                    PklEvaluatorSettings pklEvaluatorSettings = CliCommand.access$getEvaluatorSettings(this.this$0);
                    list = pklEvaluatorSettings != null ? pklEvaluatorSettings.allowedResources() : null;
                    if (list == null) {
                        list = SecurityManagers.defaultAllowedResources;
                    }
                }
                return list;
            }
        });
        this.rootDir$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path2 = this.this$0.getCliOptions().getNormalizedRootDir();
                if (path2 == null) {
                    PklEvaluatorSettings pklEvaluatorSettings = CliCommand.access$getEvaluatorSettings(this.this$0);
                    path2 = pklEvaluatorSettings != null ? pklEvaluatorSettings.rootDir() : null;
                }
                return path2;
            }
        });
        this.environmentVariables$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<String, String> invoke() {
                Map<String, String> map2 = this.this$0.getCliOptions().getEnvironmentVariables();
                if (map2 == null) {
                    PklEvaluatorSettings pklEvaluatorSettings = CliCommand.access$getEvaluatorSettings(this.this$0);
                    map2 = pklEvaluatorSettings != null ? pklEvaluatorSettings.env() : null;
                    if (map2 == null) {
                        map2 = System.getenv();
                    }
                }
                return map2;
            }
        });
        this.externalProperties$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                Map<String, String> map2 = this.this$0.getCliOptions().getExternalProperties();
                if (map2 == null) {
                    PklEvaluatorSettings pklEvaluatorSettings = CliCommand.access$getEvaluatorSettings(this.this$0);
                    map2 = pklEvaluatorSettings != null ? pklEvaluatorSettings.externalProperties() : null;
                    if (map2 == null) {
                        map2 = MapsKt.emptyMap();
                    }
                }
                return map2;
            }
        });
        this.moduleCacheDir$delegate = LazyKt.lazy((Function0)new Function0<Path>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Path invoke() {
                Path path2;
                if (this.this$0.getCliOptions().getNoCache()) {
                    path2 = null;
                } else {
                    path2 = this.this$0.getCliOptions().getNormalizedModuleCacheDir();
                    if (path2 == null) {
                        Path path3;
                        PklEvaluatorSettings pklEvaluatorSettings = CliCommand.access$getEvaluatorSettings(this.this$0);
                        if (pklEvaluatorSettings != null) {
                            PklEvaluatorSettings settings2 = pklEvaluatorSettings;
                            boolean bl = false;
                            path3 = Intrinsics.areEqual(settings2.noCache(), true) ? null : settings2.moduleCacheDir();
                        } else {
                            path3 = path2 = null;
                        }
                        if (path3 == null) {
                            Path path4 = IoUtils.getDefaultModuleCacheDir();
                            path2 = path4;
                            Intrinsics.checkNotNullExpressionValue(path4, "getDefaultModuleCacheDir()");
                        }
                    }
                }
                return path2;
            }
        });
        this.modulePath$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Path>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<Path> invoke() {
                List<Path> list = this.this$0.getCliOptions().getNormalizedModulePath();
                if (list == null) {
                    PklEvaluatorSettings pklEvaluatorSettings = CliCommand.access$getEvaluatorSettings(this.this$0);
                    list = pklEvaluatorSettings != null ? pklEvaluatorSettings.modulePath() : null;
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                }
                return list;
            }
        });
        this.stackFrameTransformer$delegate = LazyKt.lazy((Function0)new Function0<StackFrameTransformer>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final StackFrameTransformer invoke() {
                return this.this$0.getCliOptions().getTestMode() ? StackFrameTransformers.empty : StackFrameTransformers.createDefault(this.this$0.getSettings());
            }
        });
        this.securityManager$delegate = LazyKt.lazy((Function0)new Function0<SecurityManager>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SecurityManager invoke() {
                SecurityManager securityManager2 = SecurityManagers.standard(this.this$0.getAllowedModules(), this.this$0.getAllowedResources(), SecurityManagers.defaultTrustLevels, this.this$0.getRootDir());
                Intrinsics.checkNotNullExpressionValue(securityManager2, "standard(\n      allowedM\u2026vels,\n      rootDir\n    )");
                return securityManager2;
            }
        });
        this.proxyAddress$delegate = LazyKt.lazy((Function0)new Function0<URI>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final URI invoke() {
                Object object;
                URI uRI = this.this$0.getCliOptions().getHttpProxy();
                if (uRI == null && ((object = this.this$0.getProject()) != null && (object = ((Project)object).getEvaluatorSettings()) != null && (object = ((PklEvaluatorSettings)object).http()) != null && (object = ((PklEvaluatorSettings.Http)object).proxy()) != null ? ((PklEvaluatorSettings.Proxy)object).address() : (uRI = null)) == null) {
                    Record record = this.this$0.getSettings().http();
                    uRI = record != null && (record = ((PklEvaluatorSettings.Http)record).proxy()) != null ? ((PklEvaluatorSettings.Proxy)record).address() : null;
                }
                return uRI;
            }
        });
        this.noProxy$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final List<String> invoke() {
                Object object;
                List<String> list = this.this$0.getCliOptions().getHttpNoProxy();
                if (list == null && ((object = this.this$0.getProject()) != null && (object = ((Project)object).getEvaluatorSettings()) != null && (object = ((PklEvaluatorSettings)object).http()) != null && (object = ((PklEvaluatorSettings.Http)object).proxy()) != null ? ((PklEvaluatorSettings.Proxy)object).noProxy() : (list = null)) == null) {
                    Record record = this.this$0.getSettings().http();
                    list = record != null && (record = ((PklEvaluatorSettings.Http)record).proxy()) != null ? ((PklEvaluatorSettings.Proxy)record).noProxy() : null;
                }
                return list;
            }
        });
        this.httpClient$delegate = LazyKt.lazy((Function0)new Function0<HttpClient>(this){
            final /* synthetic */ CliCommand this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final HttpClient invoke() {
                Object object;
                HttpClient.Builder builder = HttpClient.builder();
                CliCommand cliCommand = this.this$0;
                HttpClient.Builder $this$invoke_u24lambda_u2d0 = builder;
                boolean bl = false;
                $this$invoke_u24lambda_u2d0.setTestPort(cliCommand.getCliOptions().getTestPort());
                if (cliCommand.getCliOptions().getNormalizedCaCertificates().isEmpty()) {
                    Intrinsics.checkNotNullExpressionValue($this$invoke_u24lambda_u2d0, "");
                    CliCommand.access$addDefaultCliCertificates(cliCommand, $this$invoke_u24lambda_u2d0);
                } else {
                    for (Path file2 : cliCommand.getCliOptions().getNormalizedCaCertificates()) {
                        $this$invoke_u24lambda_u2d0.addCertificates(file2);
                    }
                }
                if ((object = CliCommand.access$getProxyAddress(cliCommand)) == null) {
                    object = CliCommand.access$getNoProxy(cliCommand);
                }
                if (object != null) {
                    URI uRI = CliCommand.access$getProxyAddress(cliCommand);
                    List<T> list = CliCommand.access$getNoProxy(cliCommand);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    $this$invoke_u24lambda_u2d0.setProxy(uRI, (List<String>)list);
                }
                HttpClient httpClient2 = $this$invoke_u24lambda_u2d0.buildLazily();
                Intrinsics.checkNotNullExpressionValue(httpClient2, "buildLazily()");
                return httpClient2;
            }
        });
    }

    @NotNull
    protected final CliBaseOptions getCliOptions() {
        return this.cliOptions;
    }

    public final void run() {
        if (this.cliOptions.getTestMode()) {
            IoUtils.setTestMode();
        }
        try {
            URI uRI = this.getProxyAddress();
            if (uRI != null) {
                URI p0 = uRI;
                boolean bl = false;
                IoUtils.setSystemProxy(p0);
            }
            this.doRun();
        }
        catch (PklException e2) {
            String string = e2.getMessage();
            Intrinsics.checkNotNull(string);
            throw new CliException(string, 0, 2, null);
        }
        catch (CliException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new CliBugException(e4, 0, 2, null);
        }
    }

    protected abstract void doRun();

    @NotNull
    protected final PklSettings getSettings() {
        Lazy lazy = this.settings$delegate;
        return (PklSettings)lazy.getValue();
    }

    protected static /* synthetic */ void getSettings$annotations() {
    }

    @Nullable
    protected final Project getProject() {
        Lazy lazy = this.project$delegate;
        return (Project)lazy.getValue();
    }

    @NotNull
    protected final Project loadProject(@NotNull Path projectFile) {
        List<Pattern> list;
        Intrinsics.checkNotNullParameter(projectFile, "projectFile");
        List<Pattern> list2 = this.cliOptions.getAllowedModules();
        if (list2 == null) {
            list2 = SecurityManagers.defaultAllowedModules;
        }
        if ((list = this.cliOptions.getAllowedResources()) == null) {
            list = SecurityManagers.defaultAllowedResources;
        }
        SecurityManager securityManager2 = SecurityManagers.standard(list2, list, SecurityManagers.defaultTrustLevels, this.cliOptions.getNormalizedRootDir());
        Intrinsics.checkNotNullExpressionValue(securityManager2, "standard(\n        cliOpt\u2026normalizedRootDir\n      )");
        SecurityManager securityManager3 = securityManager2;
        Map<String, String> map2 = this.cliOptions.getEnvironmentVariables();
        if (map2 == null) {
            map2 = System.getenv();
        }
        Map<String, String> envVars = map2;
        StackFrameTransformer stackFrameTransformer2 = IoUtils.isTestMode() ? StackFrameTransformers.empty : StackFrameTransformers.defaultTransformer;
        Project project2 = Project.loadFromPath(projectFile, securityManager3, this.cliOptions.getTimeout(), stackFrameTransformer2, envVars);
        Intrinsics.checkNotNullExpressionValue(project2, "loadFromPath(\n      proj\u2026rmer,\n      envVars\n    )");
        return project2;
    }

    private final PklEvaluatorSettings getEvaluatorSettings() {
        Lazy lazy = this.evaluatorSettings$delegate;
        return (PklEvaluatorSettings)lazy.getValue();
    }

    @NotNull
    protected final List<Pattern> getAllowedModules() {
        Lazy lazy = this.allowedModules$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-allowedModules>(...)");
        return (List)t;
    }

    @NotNull
    protected final List<Pattern> getAllowedResources() {
        Lazy lazy = this.allowedResources$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-allowedResources>(...)");
        return (List)t;
    }

    @Nullable
    protected final Path getRootDir() {
        Lazy lazy = this.rootDir$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    protected final Map<String, String> getEnvironmentVariables() {
        Lazy lazy = this.environmentVariables$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-environmentVariables>(...)");
        return (Map)t;
    }

    @NotNull
    protected final Map<String, String> getExternalProperties() {
        Lazy lazy = this.externalProperties$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    protected final Path getModuleCacheDir() {
        Lazy lazy = this.moduleCacheDir$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    protected final List<Path> getModulePath() {
        Lazy lazy = this.modulePath$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    protected final StackFrameTransformer getStackFrameTransformer() {
        Lazy lazy = this.stackFrameTransformer$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-stackFrameTransformer>(...)");
        return (StackFrameTransformer)t;
    }

    @NotNull
    protected final SecurityManager getSecurityManager() {
        Lazy lazy = this.securityManager$delegate;
        return (SecurityManager)lazy.getValue();
    }

    private final URI getProxyAddress() {
        Lazy lazy = this.proxyAddress$delegate;
        return (URI)lazy.getValue();
    }

    private final List<String> getNoProxy() {
        Lazy lazy = this.noProxy$delegate;
        return (List)lazy.getValue();
    }

    private final void addDefaultCliCertificates(HttpClient.Builder $this$addDefaultCliCertificates) {
        Path caCertsDir = IoUtils.getPklHomeDir().resolve("cacerts");
        Ref.BooleanRef certsAdded = new Ref.BooleanRef();
        if (Files.isDirectory(caCertsDir, new LinkOption[0])) {
            Files.list(caCertsDir).filter(CliCommand::addDefaultCliCertificates$lambda-0).forEach(arg_0 -> CliCommand.addDefaultCliCertificates$lambda-1(certsAdded, $this$addDefaultCliCertificates, arg_0));
        }
        if (!certsAdded.element) {
            InputStream inputStream2 = $this$addDefaultCliCertificates.getClass().getClassLoader().getResourceAsStream("org/pkl/commons/cli/PklCARoots.pem");
            if (inputStream2 == null) {
                throw new CliException("Could not find bundled certificates", 0, 2, null);
            }
            InputStream defaultCerts = inputStream2;
            $this$addDefaultCliCertificates.addCertificates(defaultCerts.readAllBytes());
        }
    }

    @NotNull
    public final HttpClient getHttpClient() {
        Lazy lazy = this.httpClient$delegate;
        return (HttpClient)lazy.getValue();
    }

    @NotNull
    protected final List<ModuleKeyFactory> moduleKeyFactories(@NotNull ModulePathResolver modulePathResolver) {
        List<ModuleKeyFactory> list;
        Intrinsics.checkNotNullParameter(modulePathResolver, "modulePathResolver");
        List<ModuleKeyFactory> $this$moduleKeyFactories_u24lambda_u2d2 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ModuleKeyFactory moduleKeyFactory = ModuleKeyFactories.standardLibrary;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory, "standardLibrary");
        $this$moduleKeyFactories_u24lambda_u2d2.add(moduleKeyFactory);
        ModuleKeyFactory moduleKeyFactory2 = ModuleKeyFactories.modulePath(modulePathResolver);
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory2, "modulePath(modulePathResolver)");
        $this$moduleKeyFactories_u24lambda_u2d2.add(moduleKeyFactory2);
        ModuleKeyFactory moduleKeyFactory3 = ModuleKeyFactories.pkg;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory3, "pkg");
        $this$moduleKeyFactories_u24lambda_u2d2.add(moduleKeyFactory3);
        ModuleKeyFactory moduleKeyFactory4 = ModuleKeyFactories.projectpackage;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory4, "projectpackage");
        $this$moduleKeyFactories_u24lambda_u2d2.add(moduleKeyFactory4);
        List<ModuleKeyFactory> list2 = ModuleKeyFactories.fromServiceProviders();
        Intrinsics.checkNotNullExpressionValue(list2, "fromServiceProviders()");
        $this$moduleKeyFactories_u24lambda_u2d2.addAll((Collection)list2);
        ModuleKeyFactory moduleKeyFactory5 = ModuleKeyFactories.file;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory5, "file");
        $this$moduleKeyFactories_u24lambda_u2d2.add(moduleKeyFactory5);
        ModuleKeyFactory moduleKeyFactory6 = ModuleKeyFactories.http;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory6, "http");
        $this$moduleKeyFactories_u24lambda_u2d2.add(moduleKeyFactory6);
        ModuleKeyFactory moduleKeyFactory7 = ModuleKeyFactories.genericUrl;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory7, "genericUrl");
        $this$moduleKeyFactories_u24lambda_u2d2.add(moduleKeyFactory7);
        return CollectionsKt.build(list);
    }

    private final List<ResourceReader> resourceReaders(ModulePathResolver modulePathResolver) {
        List<ResourceReader> list;
        List<ResourceReader> $this$resourceReaders_u24lambda_u2d3 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ResourceReader resourceReader = ResourceReaders.environmentVariable();
        Intrinsics.checkNotNullExpressionValue(resourceReader, "environmentVariable()");
        $this$resourceReaders_u24lambda_u2d3.add(resourceReader);
        ResourceReader resourceReader2 = ResourceReaders.externalProperty();
        Intrinsics.checkNotNullExpressionValue(resourceReader2, "externalProperty()");
        $this$resourceReaders_u24lambda_u2d3.add(resourceReader2);
        ResourceReader resourceReader3 = ResourceReaders.modulePath(modulePathResolver);
        Intrinsics.checkNotNullExpressionValue(resourceReader3, "modulePath(modulePathResolver)");
        $this$resourceReaders_u24lambda_u2d3.add(resourceReader3);
        ResourceReader resourceReader4 = ResourceReaders.pkg();
        Intrinsics.checkNotNullExpressionValue(resourceReader4, "pkg()");
        $this$resourceReaders_u24lambda_u2d3.add(resourceReader4);
        ResourceReader resourceReader5 = ResourceReaders.projectpackage();
        Intrinsics.checkNotNullExpressionValue(resourceReader5, "projectpackage()");
        $this$resourceReaders_u24lambda_u2d3.add(resourceReader5);
        ResourceReader resourceReader6 = ResourceReaders.file();
        Intrinsics.checkNotNullExpressionValue(resourceReader6, "file()");
        $this$resourceReaders_u24lambda_u2d3.add(resourceReader6);
        ResourceReader resourceReader7 = ResourceReaders.http();
        Intrinsics.checkNotNullExpressionValue(resourceReader7, "http()");
        $this$resourceReaders_u24lambda_u2d3.add(resourceReader7);
        ResourceReader resourceReader8 = ResourceReaders.https();
        Intrinsics.checkNotNullExpressionValue(resourceReader8, "https()");
        $this$resourceReaders_u24lambda_u2d3.add(resourceReader8);
        return CollectionsKt.build(list);
    }

    @NotNull
    protected final EvaluatorBuilder evaluatorBuilder() {
        EvaluatorBuilder evaluatorBuilder;
        ModulePathResolver modulePathResolver = new ModulePathResolver((Iterable<Path>)this.getModulePath());
        EvaluatorBuilder $this$evaluatorBuilder_u24lambda_u2d5 = evaluatorBuilder = EvaluatorBuilder.unconfigured().setStackFrameTransformer(this.getStackFrameTransformer());
        boolean bl = false;
        Project project2 = this.getProject();
        if (project2 != null) {
            Project it = project2;
            boolean bl2 = false;
            $this$evaluatorBuilder_u24lambda_u2d5.setProjectDependencies(it.getDependencies());
        }
        EvaluatorBuilder evaluatorBuilder2 = evaluatorBuilder.setSecurityManager(this.getSecurityManager()).setHttpClient(this.getHttpClient()).setExternalProperties(this.getExternalProperties()).setEnvironmentVariables(this.getEnvironmentVariables()).addModuleKeyFactories((Collection<ModuleKeyFactory>)this.moduleKeyFactories(modulePathResolver)).addResourceReaders((Collection<ResourceReader>)this.resourceReaders(modulePathResolver)).setLogger(Loggers.stdErr()).setTimeout(this.cliOptions.getTimeout()).setModuleCacheDir(this.getModuleCacheDir());
        Intrinsics.checkNotNullExpressionValue(evaluatorBuilder2, "unconfigured()\n      .se\u2026eCacheDir(moduleCacheDir)");
        return evaluatorBuilder2;
    }

    private static final boolean addDefaultCliCertificates$lambda-0(Path it) {
        Intrinsics.checkNotNullExpressionValue(it, "it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final void addDefaultCliCertificates$lambda-1(Ref.BooleanRef $certsAdded, HttpClient.Builder $this_addDefaultCliCertificates, Path cert) {
        Intrinsics.checkNotNullParameter($certsAdded, "$certsAdded");
        Intrinsics.checkNotNullParameter($this_addDefaultCliCertificates, "$this_addDefaultCliCertificates");
        $certsAdded.element = true;
        $this_addDefaultCliCertificates.addCertificates(cert);
    }

    public static final /* synthetic */ PklEvaluatorSettings access$getEvaluatorSettings(CliCommand $this) {
        return $this.getEvaluatorSettings();
    }

    public static final /* synthetic */ void access$addDefaultCliCertificates(CliCommand $this, HttpClient.Builder $receiver) {
        $this.addDefaultCliCertificates($receiver);
    }

    public static final /* synthetic */ URI access$getProxyAddress(CliCommand $this) {
        return $this.getProxyAddress();
    }

    public static final /* synthetic */ List access$getNoProxy(CliCommand $this) {
        return $this.getNoProxy();
    }
}

