/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pkl.commons.cli.CliBaseOptions;
import org.pkl.commons.cli.CliCommand;
import org.pkl.commons.cli.CliException;
import org.pkl.commons.cli.CliTestException;
import org.pkl.commons.cli.CliTestOptions;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.project.Project;
import org.pkl.core.runtime.TestResults;
import org.pkl.core.stdlib.test.report.JUnitReport;
import org.pkl.core.stdlib.test.report.SimpleReport;
import org.pkl.core.util.ErrorMessages;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/pkl/cli/CliTestRunner;", "Lorg/pkl/commons/cli/CliCommand;", "options", "Lorg/pkl/commons/cli/CliBaseOptions;", "testOptions", "Lorg/pkl/commons/cli/CliTestOptions;", "consoleWriter", "Ljava/io/Writer;", "errWriter", "(Lorg/pkl/commons/cli/CliBaseOptions;Lorg/pkl/commons/cli/CliTestOptions;Ljava/io/Writer;Ljava/io/Writer;)V", "doRun", "", "evalTest", "builder", "Lorg/pkl/core/EvaluatorBuilder;", "pkl-cli"})
public final class CliTestRunner
extends CliCommand {
    @NotNull
    private final CliBaseOptions options;
    @NotNull
    private final CliTestOptions testOptions;
    @NotNull
    private final Writer consoleWriter;
    @NotNull
    private final Writer errWriter;

    @JvmOverloads
    public CliTestRunner(@NotNull CliBaseOptions options, @NotNull CliTestOptions testOptions, @NotNull Writer consoleWriter, @NotNull Writer errWriter) {
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(testOptions, "testOptions");
        Intrinsics.checkNotNullParameter(consoleWriter, "consoleWriter");
        Intrinsics.checkNotNullParameter(errWriter, "errWriter");
        super(options);
        this.options = options;
        this.testOptions = testOptions;
        this.consoleWriter = consoleWriter;
        this.errWriter = errWriter;
    }

    public /* synthetic */ CliTestRunner(CliBaseOptions cliBaseOptions, CliTestOptions cliTestOptions2, Writer writer, Writer writer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Charset charset;
        OutputStream outputStream2;
        if ((n & 4) != 0) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            outputStream2 = printStream;
            charset = Charsets.UTF_8;
            writer = new OutputStreamWriter(outputStream2, charset);
        }
        if ((n & 8) != 0) {
            PrintStream printStream = System.err;
            Intrinsics.checkNotNullExpressionValue(printStream, "err");
            outputStream2 = printStream;
            charset = Charsets.UTF_8;
            writer2 = new OutputStreamWriter(outputStream2, charset);
        }
        this(cliBaseOptions, cliTestOptions2, writer, writer2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        EvaluatorBuilder builder = this.evaluatorBuilder();
        try {
            this.evalTest(builder);
        }
        finally {
            ModuleKeyFactories.closeQuietly((Iterable<ModuleKeyFactory>)builder.getModuleKeyFactories());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void evalTest(EvaluatorBuilder builder) {
        Collection collection;
        Object object;
        Object object2 = this.options.getNormalizedSourceModules();
        if (object2.isEmpty()) {
            boolean bl = false;
            Object object3 = this.getProject();
            if (object3 != null && (object3 = (object = ((Project)object3).getTests())) != null) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullExpressionValue(object3, "tests");
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Path path2 = (Path)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(it.toUri());
                }
                collection = (List)destination$iv$iv;
            } else {
                collection = null;
            }
        } else {
            collection = object2;
        }
        List list = (List)collection;
        if (list == null) {
            throw new CliException("Usage: pkl test [OPTIONS] <modules>...\n\nError: Missing argument \"<modules>\"", 0, 2, null);
        }
        List sources = list;
        Evaluator evaluator = builder.build();
        Intrinsics.checkNotNullExpressionValue(evaluator, "builder.build()");
        Evaluator evaluator2 = evaluator;
        object2 = evaluator2;
        Throwable throwable = null;
        try {
            Evaluator it = (Evaluator)object2;
            boolean bl = false;
            boolean failed = false;
            Set moduleNames = new LinkedHashSet();
            for (URI moduleUri : sources) {
                try {
                    TestResults results;
                    Intrinsics.checkNotNullExpressionValue(evaluator2.evaluateTest(ModuleSource.uri(moduleUri), this.testOptions.getOverwrite()), "evaluator.evaluateTest(u\u2026), testOptions.overwrite)");
                    if (!failed) {
                        failed = results.failed();
                    }
                    new SimpleReport().report(results, this.consoleWriter);
                    this.consoleWriter.flush();
                    Path junitDir = this.testOptions.getJunitDir();
                    if (junitDir == null) continue;
                    junitDir.toFile().mkdirs();
                    String moduleName = results.getModuleName() + ".xml";
                    if (moduleNames.contains(moduleName)) {
                        throw new RuntimeException(StringsKt.trimIndent("\n                  Cannot generate JUnit report for " + moduleUri + ".\n                  A report with the same name was already generated.\n                  \n                  To fix, provide a different name for this module by adding a module header.\n                "));
                    }
                    ((Collection)moduleNames).add(moduleName);
                    new JUnitReport().reportToPath(results, junitDir.resolve(moduleName));
                }
                catch (Exception ex) {
                    Appendable appendable = ((Appendable)this.errWriter).append("Error evaluating module " + moduleUri.getPath() + ":");
                    Intrinsics.checkNotNullExpressionValue(appendable, "append(value)");
                    Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append('\\n')");
                    String string = ex.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    this.errWriter.write(string);
                    if (!Intrinsics.areEqual(moduleUri, CollectionsKt.last(sources))) {
                        Intrinsics.checkNotNullExpressionValue(((Appendable)this.errWriter).append('\n'), "append('\\n')");
                    }
                    this.errWriter.flush();
                    failed = true;
                }
            }
            if (failed) {
                String string = ErrorMessages.create("testsFailed", new Object[0]);
                Intrinsics.checkNotNullExpressionValue(string, "create(\"testsFailed\")");
                throw new CliTestException(string);
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object2, throwable);
        }
    }

    @JvmOverloads
    public CliTestRunner(@NotNull CliBaseOptions options, @NotNull CliTestOptions testOptions, @NotNull Writer consoleWriter) {
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(testOptions, "testOptions");
        Intrinsics.checkNotNullParameter(consoleWriter, "consoleWriter");
        this(options, testOptions, consoleWriter, null, 8, null);
    }

    @JvmOverloads
    public CliTestRunner(@NotNull CliBaseOptions options, @NotNull CliTestOptions testOptions) {
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(testOptions, "testOptions");
        this(options, testOptions, null, null, 12, null);
    }
}

