/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pkl.cli.CliEvaluatorOptions;
import org.pkl.cli.repl.Repl;
import org.pkl.commons.cli.CliCommand;
import org.pkl.core.Logger;
import org.pkl.core.Loggers;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.project.Project;
import org.pkl.core.repl.ReplServer;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.resource.ResourceReaders;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/pkl/cli/CliRepl;", "Lorg/pkl/commons/cli/CliCommand;", "options", "Lorg/pkl/cli/CliEvaluatorOptions;", "(Lorg/pkl/cli/CliEvaluatorOptions;)V", "doRun", "", "pkl-cli"})
public final class CliRepl
extends CliCommand {
    @NotNull
    private final CliEvaluatorOptions options;

    public CliRepl(@NotNull CliEvaluatorOptions options) {
        Intrinsics.checkNotNullParameter(options, "options");
        super(options.getBase());
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        AutoCloseable autoCloseable = new ModulePathResolver((Iterable<Path>)this.getModulePath());
        Throwable throwable = null;
        try {
            ModulePathResolver modulePathResolver = (ModulePathResolver)autoCloseable;
            boolean bl = false;
            SecurityManager securityManager2 = SecurityManagers.standard(this.getAllowedModules(), this.getAllowedResources(), SecurityManagers.defaultTrustLevels, this.getRootDir());
            HttpClient httpClient2 = this.getHttpClient();
            Logger logger = Loggers.stdErr();
            Object[] objectArray = new ModuleKeyFactory[]{ModuleKeyFactories.standardLibrary, ModuleKeyFactories.modulePath(modulePathResolver)};
            Collection collection = CollectionsKt.listOf(objectArray);
            List<ModuleKeyFactory> list = ModuleKeyFactories.fromServiceProviders();
            Intrinsics.checkNotNullExpressionValue(list, "fromServiceProviders()");
            objectArray = new ModuleKeyFactory[]{ModuleKeyFactories.file, ModuleKeyFactories.http, ModuleKeyFactories.pkg, ModuleKeyFactories.projectpackage, ModuleKeyFactories.genericUrl};
            Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus(collection, (Iterable)list), (Iterable)CollectionsKt.listOf(objectArray));
            objectArray = new ResourceReader[]{ResourceReaders.environmentVariable(), ResourceReaders.externalProperty(), ResourceReaders.modulePath(modulePathResolver), ResourceReaders.file(), ResourceReaders.http(), ResourceReaders.https(), ResourceReaders.pkg(), ResourceReaders.projectpackage()};
            Project project2 = this.getProject();
            ReplServer server = new ReplServer(securityManager2, httpClient2, logger, collection2, (Collection<ResourceReader>)CollectionsKt.listOf(objectArray), this.getEnvironmentVariables(), this.getExternalProperties(), this.getModuleCacheDir(), project2 != null ? project2.getDependencies() : null, this.options.getOutputFormat(), this.options.getBase().getNormalizedWorkingDir(), this.getStackFrameTransformer());
            new Repl(this.options.getBase().getNormalizedWorkingDir(), server).run();
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }
}

