/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import org.organicdesign.fp.collections.AbstractUnmodIterable;
import org.organicdesign.fp.collections.UnmodListIterator;
import org.organicdesign.fp.collections.UnmodSortedCollection;
import org.organicdesign.fp.collections.UnmodSortedIterable;
import org.organicdesign.fp.collections.UnmodSortedIterator;
import org.organicdesign.fp.function.Fn2;

public interface UnmodList<E>
extends List<E>,
UnmodSortedCollection<E> {
    public static <T> void permutations(@NotNull List<T> items, @NotNull Fn2<? super T, ? super T, ?> f) {
        for (int i = 0; i < items.size(); ++i) {
            for (int j = i + 1; j < items.size(); ++j) {
                f.apply(items.get(i), items.get(j));
            }
        }
    }

    @Override
    @Deprecated
    default public boolean add(E e2) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public void add(int index, E element) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public void clear() {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public boolean contains(Object o) {
        for (Object item : this) {
            if (!Objects.equals(item, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean containsAll(@NotNull Collection<?> c) {
        return UnmodSortedCollection.super.containsAll(c);
    }

    @Override
    default public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Objects.equals(this.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    default public UnmodSortedIterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    default public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i > -1; --i) {
            if (!Objects.equals(this.get(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    default public UnmodListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    default public UnmodListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Expected an index between 0 and " + this.size() + " but found: " + index);
        }
        class Impl
        implements UnmodListIterator<E> {
            private final int sz;
            private int idx;

            private Impl(int index) {
                this.sz = UnmodList.this.size();
                this.idx = index;
            }

            @Override
            public boolean hasNext() {
                return this.idx < this.sz;
            }

            @Override
            public E next() {
                int i = this.idx;
                if (i >= this.sz) {
                    throw new NoSuchElementException();
                }
                this.idx = i + 1;
                return UnmodList.this.get(i);
            }

            @Override
            public boolean hasPrevious() {
                return this.idx > 0;
            }

            @Override
            public E previous() {
                int i = this.idx - 1;
                if (i < 0) {
                    throw new NoSuchElementException();
                }
                this.idx = i;
                return UnmodList.this.get(i);
            }

            @Override
            public int nextIndex() {
                return this.idx;
            }
        }
        return new Impl(index);
    }

    @Override
    @Deprecated
    default public E remove(int index) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public E set(int index, E element) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    @Override
    @NotNull
    default public UnmodList<E> subList(final int fromIndex, final int toIndex) {
        if (fromIndex == 0 && toIndex == this.size()) {
            return this;
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        final UnmodList parent = this;
        return new UnmodList<E>(){
            private final int size;
            {
                this.size = toIndex - fromIndex;
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public E get(int index) {
                return parent.get(index + fromIndex);
            }
        };
    }

    @Override
    default public Object @NotNull [] toArray() {
        return UnmodSortedCollection.super.toArray();
    }

    @Override
    default public <T> T @NotNull [] toArray(T @NotNull [] as) {
        return UnmodSortedCollection.super.toArray(as);
    }

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super E> filter2) {
        throw new UnsupportedOperationException("Modification attempted");
    }

    public static abstract class AbstractUnmodList<E>
    extends AbstractUnmodIterable<E>
    implements UnmodList<E> {
        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof List)) {
                return false;
            }
            List that = (List)other;
            return this.size() == that.size() && UnmodSortedIterable.equal(this, UnmodSortedIterable.castFromList(that));
        }

        @Override
        public int hashCode() {
            int ret = 1;
            for (Object item : this) {
                ret *= 31;
                if (item == null) continue;
                ret += item.hashCode();
            }
            return ret;
        }
    }
}

