/*
 * Decompiled with CFR 0.152.
 */
package org.organicdesign.fp.collections;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.organicdesign.fp.collections.BaseList;
import org.organicdesign.fp.collections.Cowry;
import org.organicdesign.fp.collections.ImList;
import org.organicdesign.fp.collections.MutList;
import org.organicdesign.fp.collections.UnmodIterable;
import org.organicdesign.fp.collections.UnmodSortedIterable;
import org.organicdesign.fp.collections.UnmodSortedIterator;
import org.organicdesign.fp.function.Fn0;
import org.organicdesign.fp.indent.IndentUtils;
import org.organicdesign.fp.indent.Indented;
import org.organicdesign.fp.oneOf.Option;
import org.organicdesign.fp.tuple.Tuple2;
import org.organicdesign.fp.tuple.Tuple4;

public abstract class RrbTree<E>
implements BaseList<E>,
Indented {
    private static final int NODE_LENGTH_POW_2 = 5;
    static final int STRICT_NODE_LENGTH = 32;
    private static final int HALF_STRICT_NODE_LENGTH = 16;
    private static final int MIN_NODE_LENGTH = 22;
    private static final int MAX_NODE_LENGTH = 44;
    @NotNull
    private static final Leaf EMPTY_LEAF = new Leaf<Object>(Cowry.EMPTY_ARRAY);

    @NotNull
    public static <T> ImRrbt<T> empty() {
        return ImRrbt.EMPTY_IM_RRBT;
    }

    @NotNull
    public static <T> MutRrbt<T> emptyMutable() {
        return RrbTree.empty().mutable();
    }

    @Override
    @NotNull
    public abstract RrbTree<E> append(E var1);

    @Override
    @NotNull
    public abstract RrbTree<E> appendSome(@NotNull @NotNull Fn0<? extends @NotNull Option<E>> var1);

    abstract void debugValidate();

    @Override
    public abstract E get(int var1);

    @NotNull
    public abstract RrbTree<E> insert(int var1, E var2);

    @Override
    @NotNull
    public abstract UnmodSortedIterator<E> iterator();

    @NotNull
    public RrbTree<E> join(@NotNull RrbTree<E> that) {
        int i;
        if (that.size() <= 44) {
            return (RrbTree)this.concat(that);
        }
        if (this.size() <= 44) {
            for (int i2 = 0; i2 < this.size(); ++i2) {
                that = that.insert(i2, this.get(i2));
            }
            return that;
        }
        Node<E> leftRoot = this.pushFocus();
        Node<E> rightRoot = that.pushFocus();
        boolean leftIntoRight = leftRoot.height() < rightRoot.height();
        Node<E> taller = leftIntoRight ? rightRoot : leftRoot;
        Node<E> shorter = leftIntoRight ? leftRoot : rightRoot;
        Node<Object> n = taller;
        int descentDepth = taller.height() - shorter.height();
        Node<T>[] ancestors2 = RrbTree.genericNodeArray(descentDepth);
        for (i = 0; i < ancestors2.length; ++i) {
            ancestors2[i] = n;
            n = n.endChild(leftIntoRight);
        }
        --i;
        if (n.thisNodeHasRelaxedCapacity(shorter.numChildren())) {
            Node<T>[] kids = ((Relaxed)shorter).nodes;
            n = n.addEndChildren(leftIntoRight, kids);
        }
        if (i >= 0) {
            n = ancestors2[i];
            --i;
        }
        while (!n.thisNodeHasRelaxedCapacity(1) && i >= 0) {
            n = ancestors2[i];
            --i;
            shorter = RrbTree.addAncestor(shorter);
            if (leftIntoRight) {
                leftRoot = shorter;
                continue;
            }
            rightRoot = shorter;
        }
        if (shorter.height() == n.height() - 1) {
            n = n.addEndChild(leftIntoRight, shorter);
        } else {
            if (i < 0) {
                Node[] newRootArray = new Node[]{leftRoot, rightRoot};
                int leftSize = leftRoot.size();
                Relaxed newRoot = new Relaxed(new int[]{leftSize, leftSize + rightRoot.size()}, newRootArray);
                return this.makeNew(Cowry.emptyArray(), 0, 0, newRoot, newRoot.size());
            }
            throw new IllegalStateException("How did we get here?");
        }
        while (i >= 0) {
            Node anc = ancestors2[i];
            Relaxed rel = (Relaxed)anc;
            int repIdx = leftIntoRight ? 0 : rel.numChildren() - 1;
            n = Relaxed.replaceInRelaxedAt(rel.cumulativeSizes, rel.nodes, n, repIdx, n.size() - rel.nodes[repIdx].size());
            --i;
        }
        return this.makeNew(Cowry.emptyArray(), 0, 0, n, n.size());
    }

    @NotNull
    protected abstract RrbTree<E> makeNew(E @NotNull [] var1, int var2, int var3, @NotNull Node<E> var4, int var5);

    @NotNull
    protected abstract RrbTree<E> mt();

    @Override
    @NotNull
    public abstract RrbTree<E> precat(@Nullable Iterable<? extends E> var1);

    @NotNull
    abstract Node<E> pushFocus();

    @Override
    @NotNull
    public abstract RrbTree<E> replace(int var1, E var2);

    @Override
    public abstract int size();

    @NotNull
    public Tuple2<? extends RrbTree<E>, ? extends RrbTree<E>> split(int splitIndex) {
        if (splitIndex < 1) {
            if (splitIndex == 0) {
                return Tuple2.of(this.mt(), this);
            }
            throw new IndexOutOfBoundsException("Constraint violation failed: 1 <= splitIndex <= size");
        }
        if (splitIndex >= this.size()) {
            if (splitIndex == this.size()) {
                return Tuple2.of(this, this.mt());
            }
            throw new IndexOutOfBoundsException("Constraint violation failed: 1 <= splitIndex <= size");
        }
        Node<E> newRoot = this.pushFocus();
        SplitNode<E> split2 = newRoot.splitAt(splitIndex);
        E[] lFocus = split2.leftFocus();
        Node<E> left = RrbTree.eliminateUnnecessaryAncestors(split2.left());
        E[] rFocus = split2.rightFocus();
        Node<E> right = RrbTree.eliminateUnnecessaryAncestors(split2.right());
        return Tuple2.of(this.makeNew(lFocus, left.size(), lFocus.length, left, left.size() + lFocus.length), this.makeNew(rFocus, 0, rFocus.length, right, right.size() + rFocus.length));
    }

    @NotNull
    public RrbTree<E> without(int index) {
        if (index > 0 && index < this.size() - 1) {
            Tuple2<RrbTree<E>, RrbTree<E>> s1 = this.split(index);
            Tuple2<RrbTree<E>, RrbTree<E>> s2 = s1._2().split(1);
            return s1._1().join(s2._2());
        }
        if (index == 0) {
            return this.split(1)._2();
        }
        if (index == this.size() - 1) {
            return this.split(this.size() - 1)._1();
        }
        throw new IndexOutOfBoundsException("Failed test: 0 <= index < size");
    }

    @NotNull
    private static <E> Node<E> eliminateUnnecessaryAncestors(Node<E> n) {
        while (!(n instanceof Leaf) && n.numChildren() == 1) {
            n = n.child(0);
        }
        return n;
    }

    @NotNull
    private static <E> Node<E> addAncestor(@NotNull Node<E> n) {
        return new Relaxed(new int[]{n.size()}, new Node[]{n});
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof List)) {
            return false;
        }
        List that = (List)other;
        return this.size() == that.size() && UnmodSortedIterable.equal(this, UnmodSortedIterable.castFromList(that));
    }

    @Override
    public int hashCode() {
        int ret = 1;
        for (Object item : this) {
            ret *= 31;
            if (item == null) continue;
            ret += item.hashCode();
        }
        return ret;
    }

    @Override
    @NotNull
    public abstract String indentedStr(int var1);

    @NotNull
    private static <T> Leaf<T> emptyLeaf() {
        return EMPTY_LEAF;
    }

    private static <T> Node<T> @NotNull [] genericNodeArray(int size) {
        return new Node[size];
    }

    @NotNull
    private static StringBuilder showSubNodes(@NotNull StringBuilder sB, Object @NotNull [] items, int nextIndent) {
        boolean isFirst = true;
        for (Object n : items) {
            if (isFirst) {
                isFirst = false;
            } else if (items[0] instanceof Leaf) {
                sB.append(" ");
            } else {
                sB.append("\n").append((CharSequence)IndentUtils.indentSpace(nextIndent));
            }
            sB.append(((Node)n).indentedStr(nextIndent));
        }
        return sB;
    }

    final class Iter
    implements UnmodSortedIterator<E> {
        private final IdxNode<E> @NotNull [] stack;
        private int stackMaxIdx = -1;
        private E @NotNull [] leafArray;
        private int leafArrayIdx;

        private Iter(Node<E> root) {
            this.stack = new IdxNode[root.height()];
            this.leafArray = this.findLeaf(root);
        }

        private E @NotNull [] findLeaf(@NotNull Node<E> node) {
            while (!(node instanceof Leaf)) {
                IdxNode in = new IdxNode(node);
                this.stack[++this.stackMaxIdx] = in;
                node = in.next();
            }
            return ((Leaf)node).items;
        }

        private E @NotNull [] nextLeafArray() {
            while (this.stackMaxIdx > -1 && !this.stack[this.stackMaxIdx].hasNext()) {
                --this.stackMaxIdx;
            }
            if (this.stackMaxIdx < 0) {
                return Cowry.emptyArray();
            }
            return this.findLeaf(this.stack[this.stackMaxIdx].next());
        }

        @Override
        public boolean hasNext() {
            if (this.leafArrayIdx < this.leafArray.length) {
                return true;
            }
            this.leafArray = this.nextLeafArray();
            this.leafArrayIdx = 0;
            return this.leafArray.length > 0;
        }

        @Override
        public E next() {
            if (this.leafArrayIdx >= this.leafArray.length) {
                this.leafArray = this.nextLeafArray();
                this.leafArrayIdx = 0;
            }
            return this.leafArray[this.leafArrayIdx++];
        }
    }

    private static final class IdxNode<E> {
        int idx = 0;
        @NotNull
        final Node<E> node;

        IdxNode(@NotNull Node<E> n) {
            this.node = n;
        }

        public boolean hasNext() {
            return this.idx < this.node.numChildren();
        }

        @NotNull
        public Node<E> next() {
            return this.node.child(this.idx++);
        }
    }

    private static class Relaxed<T>
    implements Node<T> {
        final int[] cumulativeSizes;
        final Node<T>[] nodes;

        Relaxed(int[] szs, Node<T>[] ns2) {
            this.cumulativeSizes = szs;
            this.nodes = ns2;
        }

        @Override
        @NotNull
        public Node<T> child(int childIdx) {
            return this.nodes[childIdx];
        }

        @Override
        public int debugValidate() {
            int sz = 0;
            int height = this.height() - 1;
            if (this.nodes.length != this.cumulativeSizes.length) {
                throw new IllegalStateException("Unequal size of nodes and sizes!\n" + this.indentedStr(0));
            }
            for (int i = 0; i < this.nodes.length; ++i) {
                Node<T> n = this.nodes[i];
                if (n.height() != height) {
                    throw new IllegalStateException("Unequal height!\n" + this.indentedStr(0));
                }
                if ((sz += n.size()) == this.cumulativeSizes[i]) continue;
                throw new IllegalStateException("Cumulative Sizes are wrong!\n" + this.indentedStr(0));
            }
            return sz;
        }

        @Override
        @NotNull
        public Node<T> endChild(boolean leftMost) {
            return this.nodes[leftMost ? 0 : this.nodes.length - 1];
        }

        @Override
        @NotNull
        public Node<T> addEndChild(boolean leftMost, @NotNull Node<T> shorter) {
            return Relaxed.insertInRelaxedAt(this.cumulativeSizes, this.nodes, shorter, leftMost ? 0 : this.nodes.length);
        }

        @Override
        @NotNull
        public Node<T> addEndChildren(boolean leftMost, Node<T> @NotNull [] newKids) {
            Node[] res = Cowry.spliceIntoArrayAt(newKids, this.nodes, leftMost ? 0 : this.nodes.length, Node.class);
            return new Relaxed<T>(Relaxed.makeSizeArray(res), res);
        }

        @Override
        public int height() {
            return this.nodes[0].height() + 1;
        }

        @Override
        public int size() {
            return this.cumulativeSizes[this.cumulativeSizes.length - 1];
        }

        private int subNodeIndex(int treeIndex) {
            int guess = this.cumulativeSizes.length * treeIndex / this.size();
            if (guess >= this.cumulativeSizes.length) {
                return this.cumulativeSizes.length - 1;
            }
            int guessedCumSize = this.cumulativeSizes[guess];
            if (guessedCumSize < treeIndex) {
                while (guess < this.cumulativeSizes.length - 1) {
                    if ((guessedCumSize = this.cumulativeSizes[++guess]) < treeIndex) continue;
                    return guessedCumSize == treeIndex ? guess + 1 : guess;
                }
                throw new IllegalStateException("Can we get here?  If so, how?");
            }
            if (guessedCumSize > treeIndex + 22) {
                while (guess > 0) {
                    int nextGuess = guess - 1;
                    guessedCumSize = this.cumulativeSizes[nextGuess];
                    if (guessedCumSize <= treeIndex) {
                        return guess;
                    }
                    guess = nextGuess;
                }
                return guess;
            }
            if (guessedCumSize == treeIndex) {
                return treeIndex == this.size() ? guess : guess + 1;
            }
            return guess;
        }

        private int subNodeAdjustedIndex(int index, int subNodeIndex) {
            return subNodeIndex == 0 ? index : index - this.cumulativeSizes[subNodeIndex - 1];
        }

        @Override
        public T get(int index) {
            int subNodeIndex = this.subNodeIndex(index);
            return this.nodes[subNodeIndex].get(this.subNodeAdjustedIndex(index, subNodeIndex));
        }

        @Override
        public boolean thisNodeHasRelaxedCapacity(int numNodes) {
            return this.nodes.length + numNodes < 44;
        }

        @Override
        public boolean hasRelaxedCapacity(int index, int size) {
            if (this.thisNodeHasRelaxedCapacity(1)) {
                return true;
            }
            int subNodeIndex = this.subNodeIndex(index);
            return this.nodes[subNodeIndex].hasRelaxedCapacity(this.subNodeAdjustedIndex(index, subNodeIndex), size);
        }

        @NotNull
        @NotNull Relaxed<T> @NotNull [] split() {
            int midpoint = this.nodes.length >> 1;
            Relaxed<T> left = new Relaxed<T>(Arrays.copyOf(this.cumulativeSizes, midpoint), Arrays.copyOf(this.nodes, midpoint));
            int[] rightCumSizes = new int[this.nodes.length - midpoint];
            int leftCumSizes = this.cumulativeSizes[midpoint - 1];
            for (int j = 0; j < rightCumSizes.length; ++j) {
                rightCumSizes[j] = this.cumulativeSizes[midpoint + j] - leftCumSizes;
            }
            Relaxed<T> right = new Relaxed<T>(rightCumSizes, Arrays.copyOfRange(this.nodes, midpoint, this.nodes.length));
            return new Relaxed[]{left, right};
        }

        @Override
        @NotNull
        public SplitNode<T> splitAt(int splitIndex) {
            Node<T> left;
            int size = this.size();
            if (splitIndex == 0) {
                return new SplitNode(RrbTree.emptyLeaf(), Cowry.emptyArray(), RrbTree.emptyLeaf(), Cowry.emptyArray());
            }
            if (splitIndex == size) {
                return new SplitNode(this, Cowry.emptyArray(), RrbTree.emptyLeaf(), Cowry.emptyArray());
            }
            int subNodeIndex = this.subNodeIndex(splitIndex);
            Node<T> subNode = this.nodes[subNodeIndex];
            if (subNodeIndex > 0 && splitIndex == this.cumulativeSizes[subNodeIndex - 1]) {
                Tuple2<Node<T>[], Node<T>[]> splitNodes = Cowry.splitArray(this.nodes, subNodeIndex);
                int[][] splitCumSizes = Cowry.splitArray(this.cumulativeSizes, subNodeIndex);
                int[] leftCumSizes = splitCumSizes[0];
                int[] rightCumSizes = splitCumSizes[1];
                int bias = leftCumSizes[leftCumSizes.length - 1];
                for (int i = 0; i < rightCumSizes.length; ++i) {
                    rightCumSizes[i] = rightCumSizes[i] - bias;
                }
                Relaxed<T> left2 = new Relaxed<T>(leftCumSizes, splitNodes._1());
                Relaxed<T> right = new Relaxed<T>(rightCumSizes, splitNodes._2());
                return new SplitNode<T>(left2, Cowry.emptyArray(), right, Cowry.emptyArray());
            }
            int subNodeAdjustedIndex = this.subNodeAdjustedIndex(splitIndex, subNodeIndex);
            SplitNode<T> split2 = subNode.splitAt(subNodeAdjustedIndex);
            Node<T> splitLeft = split2.left();
            if (subNodeIndex == 0) {
                left = splitLeft;
            } else {
                boolean haveLeft = splitLeft.size() > 0;
                int numLeftItems = subNodeIndex + (haveLeft ? 1 : 0);
                int[] leftCumSizes = new int[numLeftItems];
                Node<T>[] leftNodes = RrbTree.genericNodeArray(numLeftItems);
                System.arraycopy(this.cumulativeSizes, 0, leftCumSizes, 0, numLeftItems);
                if (haveLeft) {
                    int cumulativeSize = numLeftItems > 1 ? leftCumSizes[numLeftItems - 2] : 0;
                    leftCumSizes[numLeftItems - 1] = cumulativeSize + splitLeft.size();
                }
                System.arraycopy(this.nodes, 0, leftNodes, 0, subNodeIndex);
                if (haveLeft) {
                    while (splitLeft.height() < this.height() - 1) {
                        splitLeft = RrbTree.addAncestor(splitLeft);
                    }
                    leftNodes[numLeftItems - 1] = splitLeft;
                }
                left = new Relaxed(leftCumSizes, leftNodes);
            }
            Node<T> right = Relaxed.fixRight(this.nodes, split2.right(), subNodeIndex);
            return new SplitNode<T>(left, split2.leftFocus(), right, split2.rightFocus());
        }

        @Override
        public int numChildren() {
            return this.nodes.length;
        }

        @Override
        @NotNull
        public Node<T> pushFocus(int index, T @NotNull [] oldFocus) {
            int subNodeAdjustedIndex;
            int subNodeIndex = this.subNodeIndex(index);
            Node<T> subNode = this.nodes[subNodeIndex];
            if (subNode.hasRelaxedCapacity(subNodeAdjustedIndex = this.subNodeAdjustedIndex(index, subNodeIndex), oldFocus.length)) {
                Node<T> newNode = subNode.pushFocus(subNodeAdjustedIndex, oldFocus);
                return Relaxed.replaceInRelaxedAt(this.cumulativeSizes, this.nodes, newNode, subNodeIndex, oldFocus.length);
            }
            if (!this.thisNodeHasRelaxedCapacity(1)) {
                Relaxed<T>[] split2 = this.split();
                int max1 = split2[0].size();
                Relaxed<T> newRelaxed = new Relaxed<T>(new int[]{max1, max1 + split2[1].size()}, split2);
                return newRelaxed.pushFocus(index, oldFocus);
            }
            if (subNode instanceof Leaf) {
                int numToSkip;
                int[] newCumSizes;
                Node[] newNodes;
                if (oldFocus.length >= 22 && (subNodeAdjustedIndex == 0 || subNodeAdjustedIndex == subNode.size())) {
                    Leaf<T> newNode = new Leaf<T>(oldFocus);
                    if (subNodeAdjustedIndex != 0) {
                        ++subNodeIndex;
                    }
                    newNodes = Cowry.insertIntoArrayAt(newNode, this.nodes, subNodeIndex, Node.class);
                    newCumSizes = new int[this.cumulativeSizes.length + 1];
                    int cumulativeSize = 0;
                    if (subNodeIndex > 0) {
                        System.arraycopy(this.cumulativeSizes, 0, newCumSizes, 0, subNodeIndex);
                        cumulativeSize = newCumSizes[subNodeIndex - 1];
                    }
                    newCumSizes[subNodeIndex] = cumulativeSize + oldFocus.length;
                    numToSkip = 1;
                } else {
                    Leaf<T>[] res = ((Leaf)subNode).spliceAndSplit(oldFocus, subNodeAdjustedIndex);
                    Leaf<T> leftLeaf = res[0];
                    Leaf<T> rightLeaf = res[1];
                    newNodes = new Node[this.nodes.length + 1];
                    newCumSizes = new int[this.cumulativeSizes.length + 1];
                    int leftSize = 0;
                    if (subNodeIndex > 0) {
                        System.arraycopy(this.nodes, 0, newNodes, 0, subNodeIndex);
                        System.arraycopy(this.cumulativeSizes, 0, newCumSizes, 0, subNodeIndex);
                        leftSize = this.cumulativeSizes[subNodeIndex - 1];
                    }
                    newNodes[subNodeIndex] = leftLeaf;
                    newNodes[subNodeIndex + 1] = rightLeaf;
                    newCumSizes[subNodeIndex] = leftSize += leftLeaf.size();
                    newCumSizes[subNodeIndex + 1] = leftSize + rightLeaf.size();
                    if (subNodeIndex < this.nodes.length - 1) {
                        System.arraycopy(this.nodes, subNodeIndex + 1, newNodes, subNodeIndex + 2, this.nodes.length - subNodeIndex - 1);
                    }
                    numToSkip = 2;
                }
                for (int i = subNodeIndex + numToSkip; i < newCumSizes.length; ++i) {
                    newCumSizes[i] = this.cumulativeSizes[i - 1] + oldFocus.length;
                }
                return new Relaxed<T>(newCumSizes, newNodes);
            }
            Relaxed<T>[] newSubNode = ((Relaxed)subNode).split();
            Relaxed<T> node1 = newSubNode[0];
            Relaxed<T> node2 = newSubNode[1];
            Node<T>[] newNodes = RrbTree.genericNodeArray(this.nodes.length + 1);
            if (subNodeIndex > 0) {
                System.arraycopy(this.nodes, 0, newNodes, 0, subNodeIndex);
            }
            newNodes[subNodeIndex] = node1;
            newNodes[subNodeIndex + 1] = node2;
            if (subNodeIndex < this.nodes.length) {
                System.arraycopy(this.nodes, subNodeIndex + 1, newNodes, subNodeIndex + 2, this.nodes.length - subNodeIndex - 1);
            }
            int[] newCumSizes = new int[this.cumulativeSizes.length + 1];
            int cumulativeSize = 0;
            if (subNodeIndex > 0) {
                System.arraycopy(this.cumulativeSizes, 0, newCumSizes, 0, subNodeIndex);
                cumulativeSize = this.cumulativeSizes[subNodeIndex - 1];
            }
            for (int i = subNodeIndex; i < newCumSizes.length; ++i) {
                newCumSizes[i] = cumulativeSize += newNodes[i].size();
            }
            Relaxed<T> newRelaxed = new Relaxed<T>(newCumSizes, newNodes);
            return newRelaxed.pushFocus(index, oldFocus);
        }

        @Override
        @NotNull
        public Node<T> replace(int index, T t) {
            int subNodeIndex = this.subNodeIndex(index);
            Node<T> alteredNode = this.nodes[subNodeIndex].replace(this.subNodeAdjustedIndex(index, subNodeIndex), t);
            Node[] newNodes = Cowry.replaceInArrayAt(alteredNode, this.nodes, subNodeIndex, Node.class);
            return new Relaxed<T>(this.cumulativeSizes, newNodes);
        }

        @Override
        @NotNull
        public String indentedStr(int indent) {
            StringBuilder sB = new StringBuilder().append("Relaxed(");
            int nextIndent = indent + sB.length();
            sB.append("cumulativeSizes=").append(IndentUtils.arrayString(this.cumulativeSizes)).append("\n").append((CharSequence)IndentUtils.indentSpace(nextIndent)).append("nodes=[");
            return RrbTree.showSubNodes(sB, this.nodes, nextIndent + 7).append("])").toString();
        }

        @NotNull
        public String toString() {
            return this.indentedStr(0);
        }

        private static int @NotNull [] makeSizeArray(@NotNull @NotNull Node @NotNull [] newNodes) {
            int[] newCumSizes = new int[newNodes.length];
            int cumulativeSize = 0;
            for (int i = 0; i < newCumSizes.length; ++i) {
                newCumSizes[i] = cumulativeSize += newNodes[i].size();
            }
            return newCumSizes;
        }

        @NotNull
        static <T> Relaxed<T> replaceInRelaxedAt(int @NotNull [] is, @NotNull @NotNull Node<T> @NotNull [] ns2, @NotNull Node<T> newNode, int subNodeIndex, int insertSize) {
            Node[] newNodes = Cowry.replaceInArrayAt(newNode, ns2, subNodeIndex, Node.class);
            int[] newCumSizes = new int[is.length];
            if (subNodeIndex > 0) {
                System.arraycopy(is, 0, newCumSizes, 0, subNodeIndex);
            }
            for (int i = subNodeIndex; i < is.length; ++i) {
                newCumSizes[i] = is[i] + insertSize;
            }
            return new Relaxed<T>(newCumSizes, newNodes);
        }

        @NotNull
        static <T> Relaxed<T> insertInRelaxedAt(int @NotNull [] oldCumSizes, @NotNull @NotNull Node<T> @NotNull [] ns2, @NotNull Node<T> newNode, int subNodeIndex) {
            Node[] newNodes = Cowry.insertIntoArrayAt(newNode, ns2, subNodeIndex, Node.class);
            int oldLen = oldCumSizes.length;
            int[] newCumSizes = new int[oldLen + 1];
            if (subNodeIndex > 0) {
                System.arraycopy(oldCumSizes, 0, newCumSizes, 0, subNodeIndex);
            }
            int newNodeSize = newNode.size();
            int prevNodeTotal = subNodeIndex == 0 ? 0 : oldCumSizes[subNodeIndex - 1];
            newCumSizes[subNodeIndex] = newNodeSize + prevNodeTotal;
            for (int i = subNodeIndex; i < oldCumSizes.length; ++i) {
                newCumSizes[i + 1] = oldCumSizes[i] + newNodeSize;
            }
            return new Relaxed<T>(newCumSizes, newNodes);
        }

        @NotNull
        public static <T> Node<T> fixRight(@NotNull @NotNull Node<T> @NotNull [] origNodes, @NotNull Node<T> splitRight, int subNodeIndex) {
            Relaxed<T> right;
            if (subNodeIndex == origNodes.length - 1) {
                right = new Relaxed<T>(new int[]{splitRight.size()}, new Node[]{splitRight});
            } else {
                boolean haveRightSubNode = splitRight.size() > 0;
                int numRightNodes = origNodes.length - subNodeIndex - (haveRightSubNode ? 0 : 1);
                int[] rightCumSizes = new int[numRightNodes];
                Node<T>[] rightNodes = RrbTree.genericNodeArray(numRightNodes);
                int cumulativeSize = 0;
                int destCopyStartIdx = 0;
                if (haveRightSubNode) {
                    System.arraycopy(origNodes, subNodeIndex + 1, rightNodes, 1, numRightNodes - 1);
                    rightNodes[0] = splitRight;
                    rightCumSizes[0] = cumulativeSize = splitRight.size();
                    destCopyStartIdx = 1;
                } else {
                    System.arraycopy(origNodes, subNodeIndex + 1, rightNodes, 0, numRightNodes);
                }
                for (int i = destCopyStartIdx; i < numRightNodes; ++i) {
                    rightCumSizes[i] = cumulativeSize += rightNodes[i].size();
                }
                right = new Relaxed(rightCumSizes, rightNodes);
            }
            return right;
        }
    }

    private static class Leaf<T>
    implements Node<T> {
        final T[] items;

        Leaf(T[] ts) {
            this.items = ts;
        }

        @Override
        @NotNull
        public Node<T> child(int childIdx) {
            throw new UnsupportedOperationException("Don't call this on a leaf");
        }

        @Override
        public int debugValidate() {
            if (this.items.length == 0) {
                return 0;
            }
            if (this.items.length < 22) {
                throw new IllegalStateException("Leaf too short!\n" + this.indentedStr(0));
            }
            if (this.items.length >= 44) {
                throw new IllegalStateException("Leaf too long!\n" + this.indentedStr(0));
            }
            return this.items.length;
        }

        @Override
        @NotNull
        public Node<T> endChild(boolean leftMost) {
            throw new UnsupportedOperationException("Don't call this on a leaf");
        }

        @Override
        @NotNull
        public Node<T> addEndChild(boolean leftMost, @NotNull Node<T> shorter) {
            throw new UnsupportedOperationException("Don't call this on a leaf");
        }

        @Override
        @NotNull
        public Node<T> addEndChildren(boolean leftMost, Node<T> @NotNull [] newKids) {
            throw new UnsupportedOperationException("Don't call this on a leaf");
        }

        @Override
        public T get(int i) {
            return this.items[i];
        }

        @Override
        public int height() {
            return 1;
        }

        @Override
        public int size() {
            return this.items.length;
        }

        @Override
        public boolean hasRelaxedCapacity(int index, int size) {
            return this.items.length + size < 44;
        }

        @Override
        @NotNull
        public SplitNode<T> splitAt(int splitIndex) {
            if (splitIndex == 0) {
                return new SplitNode(RrbTree.emptyLeaf(), Cowry.emptyArray(), RrbTree.emptyLeaf(), this.items);
            }
            if (splitIndex == this.items.length) {
                return new SplitNode(RrbTree.emptyLeaf(), this.items, RrbTree.emptyLeaf(), Cowry.emptyArray());
            }
            Tuple2<T[], T[]> split2 = Cowry.splitArray(this.items, splitIndex);
            T[] splitL = split2._1();
            T[] splitR = split2._2();
            Leaf leafL = RrbTree.emptyLeaf();
            Leaf leafR = RrbTree.emptyLeaf();
            if (splitL.length > 32) {
                leafL = new Leaf(splitL);
                splitL = Cowry.emptyArray();
            }
            if (splitR.length > 32) {
                leafR = new Leaf(splitR);
                splitR = Cowry.emptyArray();
            }
            return new SplitNode(leafL, splitL, leafR, splitR);
        }

        @NotNull
        private @NotNull Leaf<T> @NotNull [] spliceAndSplit(T @NotNull [] oldFocus, int splitIndex) {
            T[] newItems = Cowry.spliceIntoArrayAt(oldFocus, this.items, splitIndex, null);
            Tuple2<T[], T[]> split2 = Cowry.splitArray(newItems, newItems.length >> 1);
            return new Leaf[]{new Leaf(split2._1()), new Leaf(split2._2())};
        }

        @Override
        public int numChildren() {
            return this.size();
        }

        @Override
        @NotNull
        public Node<T> pushFocus(int index, T @NotNull [] oldFocus) {
            if (this.items.length == 0) {
                return new Leaf<T>(oldFocus);
            }
            if (this.items.length + oldFocus.length < 44) {
                return new Leaf<T>(Cowry.spliceIntoArrayAt(oldFocus, this.items, index, null));
            }
            Leaf<T>[] res = this.spliceAndSplit(oldFocus, index);
            Leaf<T> leftLeaf = res[0];
            Leaf<T> rightLeaf = res[1];
            int leftSize = leftLeaf.size();
            return new Relaxed<T>(new int[]{leftSize, leftSize + rightLeaf.size()}, res);
        }

        @Override
        @NotNull
        public Node<T> replace(int idx, T t) {
            return new Leaf<T>(Cowry.replaceInArrayAt(t, this.items, idx, null));
        }

        @Override
        public boolean thisNodeHasRelaxedCapacity(int numItems) {
            return this.items.length + numItems < 44;
        }

        @NotNull
        public String toString() {
            return IndentUtils.arrayString(this.items);
        }

        @Override
        @NotNull
        public String indentedStr(int indent) {
            return IndentUtils.arrayString(this.items);
        }
    }

    private static class SplitNode<T>
    extends Tuple4<Node<T>, T[], Node<T>, T[]>
    implements Indented {
        SplitNode(@NotNull Node<T> ln, T @NotNull [] lf, @NotNull Node<T> rn, T @NotNull [] rf) {
            super(ln, lf, rn, rf);
        }

        @NotNull
        public Node<T> left() {
            return (Node)this._1;
        }

        public T @NotNull [] leftFocus() {
            return (Object[])this._2;
        }

        @NotNull
        public Node<T> right() {
            return (Node)this._3;
        }

        public T @NotNull [] rightFocus() {
            return (Object[])this._4;
        }

        public int size() {
            return ((Node)this._1).size() + ((Object[])this._2).length + ((Node)this._3).size() + ((Object[])this._4).length;
        }

        @Override
        @NotNull
        public String indentedStr(int indent) {
            StringBuilder sB = new StringBuilder().append("SplitNode(");
            int nextIndent = indent + sB.length();
            String nextIndentStr = IndentUtils.indentSpace(nextIndent).toString();
            return sB.append("left=").append(this.left().indentedStr(nextIndent + 5)).append(",\n").append(nextIndentStr).append("leftFocus=").append(IndentUtils.arrayString(this.leftFocus())).append(",\n").append(nextIndentStr).append("right=").append(this.right().indentedStr(nextIndent + 6)).append(",\n").append(nextIndentStr).append("rightFocus=").append(IndentUtils.arrayString(this.rightFocus())).append(")").toString();
        }

        @Override
        @NotNull
        public String toString() {
            return this.indentedStr(0);
        }
    }

    private static interface Node<T>
    extends Indented {
        @NotNull
        public Node<T> child(int var1);

        public int debugValidate();

        @NotNull
        public Node<T> endChild(boolean var1);

        @NotNull
        public Node<T> addEndChild(boolean var1, @NotNull Node<T> var2);

        @NotNull
        public Node<T> addEndChildren(boolean var1, Node<T> @NotNull [] var2);

        public T get(int var1);

        public int height();

        public int size();

        public boolean thisNodeHasRelaxedCapacity(int var1);

        public boolean hasRelaxedCapacity(int var1, int var2);

        public int numChildren();

        @NotNull
        public Node<T> pushFocus(int var1, T @NotNull [] var2);

        @NotNull
        public Node<T> replace(int var1, T var2);

        @NotNull
        public SplitNode<T> splitAt(int var1);
    }

    public static class ImRrbt<E>
    extends RrbTree<E>
    implements ImList<E>,
    Serializable {
        private final E @NotNull [] focus;
        private final int focusStartIndex;
        @NotNull
        private final transient Node<E> root;
        private final int size;
        private static final long serialVersionUID = 20170625165600L;
        private static final ImRrbt EMPTY_IM_RRBT = new ImRrbt(Cowry.emptyArray(), 0, RrbTree.emptyLeaf(), 0);

        ImRrbt(E @NotNull [] f, int fi, @NotNull Node<E> r, int s2) {
            this.focus = f;
            this.focusStartIndex = fi;
            this.root = r;
            this.size = s2;
        }

        @Override
        @NotNull
        protected ImRrbt<E> makeNew(E @NotNull [] f, int fi, int fl, @NotNull Node<E> r, int s2) {
            return new ImRrbt<E>(f, fi, r, s2);
        }

        @NotNull
        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            throw new InvalidObjectException("Proxy required");
        }

        @Override
        @NotNull
        public ImRrbt<E> append(E val) {
            if (this.focus.length >= 32 || this.focus.length > 0 && this.focusStartIndex < this.size - this.focus.length) {
                Node<E> newRoot = this.root.pushFocus(this.focusStartIndex, this.focus);
                return new ImRrbt<E>(Cowry.singleElementArray(val), this.size, newRoot, this.size + 1);
            }
            return new ImRrbt<E>(Cowry.insertIntoArrayAt(val, this.focus, this.focus.length, null), this.focusStartIndex, this.root, this.size + 1);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public ImRrbt<E> appendSome(@NotNull @NotNull Fn0<? extends @NotNull Option<E>> supplier) {
            return supplier.apply().match(it -> this.append(it), () -> this);
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public ImRrbt<E> concat(@Nullable Iterable<? extends E> es) {
            return ((MutRrbt)((MutRrbt)this.mutable()).concat((Iterable)es)).immutable();
        }

        @Override
        @Contract(pure=true)
        @NotNull
        public ImRrbt<E> precat(@Nullable Iterable<? extends E> es) {
            return ((MutRrbt)((MutRrbt)this.mutable()).precat((Iterable)es)).immutable();
        }

        @Override
        void debugValidate() {
            if (this.focus.length > 32) {
                throw new IllegalStateException("focus len:" + this.focus.length + " gt STRICT_NODE_LENGTH:32\n" + this.indentedStr(0));
            }
            int sz = this.root.debugValidate();
            if (sz != this.size - this.focus.length) {
                throw new IllegalStateException("Size incorrect.  Root size: " + this.root.size() + " RrbSize: " + this.size + " focusLen: " + this.focus.length + "\n" + this.indentedStr(0));
            }
            if (this.focusStartIndex < 0 || this.focusStartIndex > this.size) {
                throw new IllegalStateException("focusStartIndex out of bounds!\n" + this.indentedStr(0));
            }
            if (!this.root.equals(RrbTree.eliminateUnnecessaryAncestors(this.root))) {
                throw new IllegalStateException("Unnecessary ancestors!\n" + this.indentedStr(0));
            }
        }

        @Override
        public E get(int i) {
            if (i < 0 || i > this.size) {
                throw new IndexOutOfBoundsException("Index: " + i + " size: " + this.size);
            }
            if (i >= this.focusStartIndex) {
                int focusOffset = i - this.focusStartIndex;
                if (focusOffset < this.focus.length) {
                    return this.focus[focusOffset];
                }
                i -= this.focus.length;
            }
            return this.root.get(i);
        }

        @Override
        @NotNull
        public ImRrbt<E> insert(int idx, E element) {
            if (this.focus.length >= 32) {
                Node<E> newRoot = this.root.pushFocus(this.focusStartIndex, this.focus);
                E[] newFocus = Cowry.singleElementArray(element);
                return new ImRrbt<E>(newFocus, idx, newRoot, this.size + 1);
            }
            int diff = idx - this.focusStartIndex;
            if (diff >= 0 && diff <= this.focus.length) {
                E[] newFocus = Cowry.insertIntoArrayAt(element, this.focus, diff, null);
                return new ImRrbt<E>(newFocus, this.focusStartIndex, this.root, this.size + 1);
            }
            Node<E> newRoot = this.focus.length > 0 ? this.root.pushFocus(this.focusStartIndex, this.focus) : this.root;
            E[] newFocus = Cowry.singleElementArray(element);
            return new ImRrbt<E>(newFocus, idx, newRoot, this.size + 1);
        }

        @Override
        @NotNull
        public MutRrbt<E> mutable() {
            return new MutRrbt<E>(Cowry.arrayCopy(this.focus, this.focus.length, null), this.focusStartIndex, this.focus.length, this.root, this.size);
        }

        @Override
        @NotNull
        public UnmodSortedIterator<E> iterator() {
            return new Iter(this.pushFocus());
        }

        @Override
        @NotNull
        Node<E> pushFocus() {
            return this.focus.length == 0 ? this.root : this.root.pushFocus(this.focusStartIndex, this.focus);
        }

        @Override
        @NotNull
        public ImRrbt<E> join(@NotNull RrbTree<E> that) {
            return (ImRrbt)super.join(that);
        }

        @Override
        @NotNull
        public ImRrbt<E> replace(int index, E item) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + " size: " + this.size);
            }
            if (index >= this.focusStartIndex) {
                int focusOffset = index - this.focusStartIndex;
                if (focusOffset < this.focus.length) {
                    return new ImRrbt<E>(Cowry.replaceInArrayAt(item, this.focus, focusOffset, null), this.focusStartIndex, this.root, this.size);
                }
                index -= this.focus.length;
            }
            return new ImRrbt<E>(this.focus, this.focusStartIndex, this.root.replace(index, item), this.size);
        }

        @Override
        @NotNull
        public ImRrbt<E> without(int index) {
            return (ImRrbt)super.without(index);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        @NotNull
        protected ImRrbt<E> mt() {
            return ImRrbt.empty();
        }

        @Override
        @NotNull
        public Tuple2<ImRrbt<E>, ImRrbt<E>> split(int splitIndex) {
            return super.split(splitIndex);
        }

        @Override
        @NotNull
        public String indentedStr(int indent) {
            return "RrbTree(size=" + this.size + " fsi=" + this.focusStartIndex + " focus=" + IndentUtils.arrayString(this.focus) + "\n" + IndentUtils.indentSpace(indent + 8) + "root=" + this.root.indentedStr(indent + 13) + ")";
        }

        @NotNull
        public String toString() {
            return UnmodIterable.toString("ImRrbt", this);
        }

        private static class SerializationProxy<E>
        implements Serializable {
            private static final long serialVersionUID = 20160904155600L;
            private final int size;
            private transient RrbTree<E> rrbTree;

            SerializationProxy(@NotNull RrbTree<E> v) {
                this.size = v.size();
                this.rrbTree = v;
            }

            private void writeObject(@NotNull ObjectOutputStream s2) throws IOException {
                s2.defaultWriteObject();
                for (Object entry : this.rrbTree) {
                    s2.writeObject(entry);
                }
            }

            private void readObject(@NotNull ObjectInputStream s2) throws IOException, ClassNotFoundException {
                s2.defaultReadObject();
                MutRrbt temp = RrbTree.emptyMutable();
                for (int i = 0; i < this.size; ++i) {
                    temp.append(s2.readObject());
                }
                this.rrbTree = temp.immutable();
            }

            private Object readResolve() {
                return this.rrbTree;
            }
        }
    }

    public static class MutRrbt<E>
    extends RrbTree<E>
    implements MutList<E> {
        private E @NotNull [] focus;
        private int focusStartIndex;
        private int focusLength;
        @NotNull
        private Node<E> root;
        private int size;

        MutRrbt(E @NotNull [] f, int fi, int fl, @NotNull Node<E> r, int s2) {
            this.focus = f;
            this.focusStartIndex = fi;
            this.focusLength = fl;
            this.root = r;
            this.size = s2;
        }

        @Override
        @NotNull
        protected MutRrbt<E> makeNew(E @NotNull [] f, int fi, int fl, @NotNull Node<E> r, int s2) {
            return new MutRrbt<E>(f, fi, fl, r, s2);
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutRrbt<E> append(E val) {
            if (this.focusLength >= 32 || this.focusLength > 0 && this.focusStartIndex < this.size - this.focusLength) {
                this.root = this.root.pushFocus(this.focusStartIndex, Cowry.arrayCopy(this.focus, this.focusLength, null));
                this.focus = new Object[32];
                this.focus[0] = val;
                this.focusStartIndex = this.size++;
                this.focusLength = 1;
                return this;
            }
            if (this.focus.length <= this.focusLength) {
                this.focus = Cowry.arrayCopy(this.focus, 32, null);
            }
            this.focus[this.focusLength] = val;
            ++this.focusLength;
            ++this.size;
            return this;
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutRrbt<E> appendSome(@NotNull @NotNull Fn0<? extends @NotNull Option<E>> supplier) {
            return supplier.apply().match(it -> this.append(it), () -> this);
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutRrbt<E> concat(@Nullable Iterable<? extends E> es) {
            return (MutRrbt)MutList.super.concat((Iterable)es);
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutRrbt<E> precat(@Nullable Iterable<? extends E> es) {
            int idx = 0;
            if (es != null) {
                for (E e2 : es) {
                    this.insert(idx, (Object)e2);
                    ++idx;
                }
            }
            return this;
        }

        @Override
        void debugValidate() {
            if (this.focusLength > 32) {
                throw new IllegalStateException("focus len:" + this.focusLength + " gt STRICT_NODE_LENGTH:32\n" + this.indentedStr(0));
            }
            int sz = this.root.debugValidate();
            if (sz != this.size - this.focusLength) {
                throw new IllegalStateException("Size incorrect.  Root size: " + this.root.size() + " RrbSize: " + this.size + " focusLen: " + this.focusLength + "\n" + this.indentedStr(0));
            }
            if (this.focusStartIndex < 0 || this.focusStartIndex > this.size) {
                throw new IllegalStateException("focusStartIndex out of bounds!\n" + this.indentedStr(0));
            }
            if (!this.root.equals(RrbTree.eliminateUnnecessaryAncestors(this.root))) {
                throw new IllegalStateException("Unnecessary ancestors!\n" + this.indentedStr(0));
            }
        }

        @Override
        public E get(int i) {
            if (i < 0 || i > this.size) {
                throw new IndexOutOfBoundsException("Index: " + i + " size: " + this.size);
            }
            if (i >= this.focusStartIndex) {
                int focusOffset = i - this.focusStartIndex;
                if (focusOffset < this.focusLength) {
                    return this.focus[focusOffset];
                }
                i -= this.focusLength;
            }
            return this.root.get(i);
        }

        @Override
        @NotNull
        public ImRrbt<E> immutable() {
            return new ImRrbt<E>(Cowry.arrayCopy(this.focus, this.focusLength, null), this.focusStartIndex, this.root, this.size);
        }

        @Override
        @NotNull
        public String indentedStr(int indent) {
            return "RrbTree(size=" + this.size + " fsi=" + this.focusStartIndex + " focus=" + IndentUtils.arrayString(this.focus) + "\n" + IndentUtils.indentSpace(indent + 8) + "root=" + this.root.indentedStr(indent + 13) + ")";
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutRrbt<E> insert(int idx, E element) {
            if (this.focusLength >= 32) {
                this.root = this.root.pushFocus(this.focusStartIndex, Cowry.arrayCopy(this.focus, this.focusLength, null));
                this.focus = Cowry.singleElementArray(element);
                this.focusStartIndex = idx;
                this.focusLength = 1;
                ++this.size;
                return this;
            }
            if (this.focusLength == 0) {
                this.focus = Cowry.singleElementArray(element);
                this.focusStartIndex = idx;
                this.focusLength = 1;
                ++this.size;
                return this;
            }
            int diff = idx - this.focusStartIndex;
            if (diff >= 0 && diff <= this.focusLength) {
                int numItemsToShift;
                if (this.focus.length <= this.focusLength) {
                    int newLen = this.focusLength >= 16 ? 32 : this.focusLength << 1;
                    this.focus = Cowry.arrayCopy(this.focus, newLen, null);
                }
                if ((numItemsToShift = this.focusLength - diff) > 0) {
                    System.arraycopy(this.focus, diff, this.focus, diff + 1, numItemsToShift);
                }
                this.focus[diff] = element;
                ++this.focusLength;
                ++this.size;
                return this;
            }
            if (this.focusLength > 0) {
                this.root = this.root.pushFocus(this.focusStartIndex, Cowry.arrayCopy(this.focus, this.focusLength, null));
            }
            this.focus = Cowry.singleElementArray(element);
            this.focusStartIndex = idx;
            this.focusLength = 1;
            ++this.size;
            return this;
        }

        @Override
        @NotNull
        public UnmodSortedIterator<E> iterator() {
            return new Iter(this.pushFocus());
        }

        @Override
        @NotNull
        Node<E> pushFocus() {
            return this.focusLength == 0 ? this.root : this.root.pushFocus(this.focusStartIndex, Cowry.arrayCopy(this.focus, this.focusLength, null));
        }

        @NotNull
        public String toString() {
            return UnmodIterable.toString("MutRrbt", this);
        }

        @Override
        @NotNull
        public MutRrbt<E> join(@NotNull RrbTree<E> that) {
            return (MutRrbt)super.join(that);
        }

        @Override
        @Contract(mutates="this")
        @NotNull
        public MutRrbt<E> replace(int index, E item) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + " size: " + this.size);
            }
            if (index >= this.focusStartIndex) {
                int focusOffset = index - this.focusStartIndex;
                if (focusOffset < this.focusLength) {
                    this.focus[focusOffset] = item;
                    return this;
                }
                index -= this.focusLength;
            }
            this.root = this.root.replace(index, item);
            return this;
        }

        @Override
        @NotNull
        public MutRrbt<E> without(int index) {
            return (MutRrbt)super.without(index);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        @NotNull
        protected MutRrbt<E> mt() {
            return MutRrbt.emptyMutable();
        }

        @Override
        @NotNull
        public Tuple2<MutRrbt<E>, MutRrbt<E>> split(int splitIndex) {
            return super.split(splitIndex);
        }
    }
}

