/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.misc.AbstractEqualityComparator;
import org.antlr.v4.runtime.misc.MurmurHash;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.misc.Nullable;
import org.antlr.v4.runtime.misc.ObjectEqualityComparator;

public class FlexibleHashMap<K, V>
implements Map<K, V> {
    public static final int INITAL_CAPACITY = 16;
    public static final int INITAL_BUCKET_CAPACITY = 8;
    public static final double LOAD_FACTOR = 0.75;
    @NotNull
    protected final AbstractEqualityComparator<? super K> comparator;
    protected LinkedList<Entry<K, V>>[] buckets;
    protected int n = 0;
    protected int threshold = 12;
    protected int currentPrime = 1;
    protected int initialBucketCapacity = 8;

    public FlexibleHashMap() {
        this(null, 16, 8);
    }

    public FlexibleHashMap(@Nullable AbstractEqualityComparator<? super K> comparator) {
        this(comparator, 16, 8);
    }

    public FlexibleHashMap(@Nullable AbstractEqualityComparator<? super K> comparator, int initialCapacity, int initialBucketCapacity) {
        if (comparator == null) {
            comparator = ObjectEqualityComparator.INSTANCE;
        }
        this.comparator = comparator;
        this.buckets = FlexibleHashMap.createEntryListArray(initialBucketCapacity);
        this.initialBucketCapacity = initialBucketCapacity;
    }

    private static <K, V> LinkedList<Entry<K, V>>[] createEntryListArray(int length2) {
        LinkedList[] result = new LinkedList[length2];
        return result;
    }

    protected int getBucket(K key2) {
        int hash = this.comparator.hashCode(key2);
        int b2 = hash & this.buckets.length - 1;
        return b2;
    }

    @Override
    public V get(Object key2) {
        Object typedKey = key2;
        if (key2 == null) {
            return null;
        }
        int b2 = this.getBucket(typedKey);
        LinkedList<Entry<K, V>> bucket = this.buckets[b2];
        if (bucket == null) {
            return null;
        }
        for (Entry entry : bucket) {
            if (!this.comparator.equals(entry.key, typedKey)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public V put(K key2, V value2) {
        int b2;
        LinkedList<Entry<K, V>> bucket;
        if (key2 == null) {
            return null;
        }
        if (this.n > this.threshold) {
            this.expand();
        }
        if ((bucket = this.buckets[b2 = this.getBucket(key2)]) == null) {
            this.buckets[b2] = new LinkedList();
            bucket = this.buckets[b2];
        }
        for (Entry entry : bucket) {
            if (!this.comparator.equals(entry.key, key2)) continue;
            Object prev = entry.value;
            entry.value = value2;
            ++this.n;
            return prev;
        }
        bucket.add(new Entry<K, V>(key2, value2));
        ++this.n;
        return null;
    }

    @Override
    public V remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        ArrayList a = new ArrayList(this.size());
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) continue;
            for (Entry entry : bucket) {
                a.add(entry.value);
            }
        }
        return a;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.get(key2) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        int hash = MurmurHash.initialize();
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            Entry e2;
            if (bucket == null) continue;
            Iterator i$ = bucket.iterator();
            while (i$.hasNext() && (e2 = (Entry)i$.next()) != null) {
                hash = MurmurHash.update(hash, this.comparator.hashCode(e2.key));
            }
        }
        hash = MurmurHash.finish(hash, this.size());
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    protected void expand() {
        LinkedList<Entry<K, V>>[] old = this.buckets;
        this.currentPrime += 4;
        int newCapacity = this.buckets.length * 2;
        LinkedList<Entry<K, V>>[] newTable = FlexibleHashMap.createEntryListArray(newCapacity);
        this.buckets = newTable;
        this.threshold = (int)((double)newCapacity * 0.75);
        int oldSize = this.size();
        for (LinkedList<Entry<K, V>> bucket : old) {
            Entry e2;
            if (bucket == null) continue;
            Iterator i$ = bucket.iterator();
            while (i$.hasNext() && (e2 = (Entry)i$.next()) != null) {
                this.put(e2.key, e2.value);
            }
        }
        this.n = oldSize;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public boolean isEmpty() {
        return this.n == 0;
    }

    @Override
    public void clear() {
        this.buckets = FlexibleHashMap.createEntryListArray(16);
        this.n = 0;
    }

    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean first2 = true;
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            Entry e2;
            if (bucket == null) continue;
            Iterator i$ = bucket.iterator();
            while (i$.hasNext() && (e2 = (Entry)i$.next()) != null) {
                if (first2) {
                    first2 = false;
                } else {
                    buf.append(", ");
                }
                buf.append(e2.toString());
            }
        }
        buf.append('}');
        return buf.toString();
    }

    public String toTableString() {
        StringBuilder buf = new StringBuilder();
        for (LinkedList<Entry<K, V>> bucket : this.buckets) {
            if (bucket == null) {
                buf.append("null\n");
                continue;
            }
            buf.append('[');
            boolean first2 = true;
            for (Entry entry : bucket) {
                if (first2) {
                    first2 = false;
                } else {
                    buf.append(" ");
                }
                if (entry == null) {
                    buf.append("_");
                    continue;
                }
                buf.append(entry.toString());
            }
            buf.append("]\n");
        }
        return buf.toString();
    }

    public static void main(String[] args2) {
        FlexibleHashMap<String, Integer> map2 = new FlexibleHashMap<String, Integer>();
        map2.put("hi", 1);
        map2.put("mom", 2);
        map2.put("foo", 3);
        map2.put("ach", 4);
        map2.put("cbba", 5);
        map2.put("d", 6);
        map2.put("edf", 7);
        map2.put("mom", 8);
        map2.put("hi", 9);
        System.out.println(map2);
        System.out.println(map2.toTableString());
    }

    public static class Entry<K, V> {
        public final K key;
        public V value;

        public Entry(K key2, V value2) {
            this.key = key2;
            this.value = value2;
        }

        public String toString() {
            return this.key.toString() + ":" + this.value.toString();
        }
    }
}

