/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotExceptionFrame
extends AbstractPolyglotImpl.AbstractStackFrameImpl {
    private final PolyglotLanguage language;
    private final SourceSection sourceLocation;
    private final String rootName;
    private final boolean host;
    private StackTraceElement stackTrace;
    private final String formattedSource;

    private PolyglotExceptionFrame(PolyglotExceptionImpl source, PolyglotLanguage language, SourceSection sourceLocation, String rootName, boolean isHost, StackTraceElement stackTrace) {
        super(source.polyglot);
        this.language = language;
        this.sourceLocation = sourceLocation;
        this.rootName = rootName;
        this.host = isHost;
        this.stackTrace = stackTrace;
        this.formattedSource = !isHost ? PolyglotExceptionFrame.formatSource(sourceLocation, language != null ? source.getFileSystemContext(language) : null) : null;
    }

    @Override
    public SourceSection getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public Language getLanguage() {
        return this.language.api;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public boolean isHostFrame() {
        return this.host;
    }

    @Override
    public StackTraceElement toHostFrame() {
        if (this.stackTrace == null) {
            Object declaringClass = this.language != null ? "<" + this.language.getId() + ">" : "";
            String methodName = this.rootName == null ? "" : this.rootName;
            String fileName = this.sourceLocation != null ? this.sourceLocation.getSource().getName() : "Unknown";
            int startLine = this.sourceLocation != null ? this.sourceLocation.getStartLine() : -1;
            this.stackTrace = new StackTraceElement((String)declaringClass, methodName, fileName, startLine);
        }
        return this.stackTrace;
    }

    @Override
    public String toStringImpl(int langColumn) {
        StringBuilder b2 = new StringBuilder();
        if (this.isHostFrame()) {
            String languageId = "";
        } else {
            String languageId = this.language.getId();
            b2.append(PolyglotExceptionFrame.spaces(Math.max(langColumn, languageId.length()) - languageId.length())).append("<").append(languageId).append("> ");
        }
        if (this.isHostFrame()) {
            b2.append(this.stackTrace.toString());
        } else {
            b2.append(this.rootName);
            b2.append("(");
            assert (this.formattedSource != null);
            b2.append(this.formattedSource);
            b2.append(")");
        }
        return b2.toString();
    }

    static PolyglotExceptionFrame createGuest(PolyglotExceptionImpl exception, TruffleStackTraceElement frame, boolean first2) {
        if (frame == null) {
            return null;
        }
        RootNode targetRoot = frame.getTarget().getRootNode();
        if (targetRoot.isInternal() && !exception.showInternalStackFrames) {
            return null;
        }
        LanguageInfo info = targetRoot.getLanguageInfo();
        if (info == null) {
            return null;
        }
        PolyglotEngineImpl engine = exception.engine;
        PolyglotLanguage language = null;
        SourceSection location = null;
        String rootName = targetRoot.getName();
        if (engine != null) {
            language = engine.idToLanguage.get(info.getId());
            Node callNode = frame.getLocation();
            if (callNode != null) {
                com.oracle.truffle.api.source.SourceSection section = callNode.getEncapsulatingSourceSection();
                if (section != null) {
                    Source source = engine.getAPIAccess().newSource(exception.polyglot.getSourceDispatch(), section.getSource());
                    location = engine.getAPIAccess().newSourceSection(source, exception.polyglot.getSourceSectionDispatch(), section);
                } else {
                    location = null;
                }
            } else {
                location = first2 ? exception.getSourceLocation() : null;
            }
        }
        return new PolyglotExceptionFrame(exception, language, location, rootName, false, null);
    }

    static PolyglotExceptionFrame createHost(PolyglotExceptionImpl exception, StackTraceElement hostStack) {
        PolyglotLanguage language = exception.engine != null ? exception.engine.hostLanguage : null;
        SourceSection location = null;
        String rootname = hostStack.getClassName() + "." + hostStack.getMethodName();
        return new PolyglotExceptionFrame(exception, language, location, rootname, true, hostStack);
    }

    private static String spaces(int length2) {
        StringBuilder b2 = new StringBuilder();
        for (int i = 0; i < length2; ++i) {
            b2.append(' ');
        }
        return b2.toString();
    }

    private static String formatSource(SourceSection sourceSection, Object fileSystemContext) {
        if (sourceSection == null) {
            return "Unknown";
        }
        Source source = sourceSection.getSource();
        if (source == null) {
            return "Unknown";
        }
        StringBuilder b2 = new StringBuilder();
        String path2 = source.getPath();
        if (path2 == null) {
            b2.append(source.getName());
        } else if (fileSystemContext != null) {
            try {
                TruffleFile pathAbsolute = EngineAccessor.LANGUAGE.getTruffleFile(path2, fileSystemContext);
                TruffleFile pathBase = EngineAccessor.LANGUAGE.getTruffleFile("", fileSystemContext).getAbsoluteFile();
                TruffleFile pathRelative = pathBase.relativize(pathAbsolute);
                b2.append(pathRelative.getPath());
            }
            catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e2) {
                b2.append(path2);
            }
        } else {
            b2.append(path2);
        }
        b2.append(":").append(PolyglotExceptionFrame.formatIndices(sourceSection, true));
        return b2.toString();
    }

    private static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b2 = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b2.append(sourceSection.getStartLine());
        } else {
            b2.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b2.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b2.append(sourceSection.getCharIndex());
            } else {
                b2.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b2.toString();
    }
}

