/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.host.GuestToHostCodeCache;
import com.oracle.truffle.host.HostClassCache;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostInteropErrors;
import com.oracle.truffle.host.HostMethodDesc;
import com.oracle.truffle.host.HostMethodScope;
import com.oracle.truffle.host.HostObject;
import com.oracle.truffle.host.HostTargetMapping;
import com.oracle.truffle.host.HostTargetMappingNode;
import com.oracle.truffle.host.HostTargetMappingNodeGen;
import com.oracle.truffle.host.HostToTypeNode;
import com.oracle.truffle.host.HostToTypeNodeGen;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

@ReportPolymorphism
@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
abstract class HostExecuteNode
extends Node {
    static final int LIMIT = 3;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    HostExecuteNode() {
    }

    public abstract Object execute(Node var1, HostMethodDesc var2, Object var3, Object[] var4, HostContext var5) throws UnsupportedTypeException, ArityException;

    static HostToTypeNode[] createToHost(int argsLength) {
        HostToTypeNode[] toJava = new HostToTypeNode[argsLength];
        for (int i = 0; i < argsLength; ++i) {
            toJava[i] = HostToTypeNodeGen.create();
        }
        return toJava;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExplodeLoop
    @Specialization(guards={"!method.isVarArgs()", "method == cachedMethod"}, limit="LIMIT")
    static Object doFixed(Node node, HostMethodDesc.SingleMethod method, Object obj, Object[] args2, HostContext hostContext, @Cached(value="method") HostMethodDesc.SingleMethod cachedMethod, @Cached(value="createToHost(method.getParameterCount())") HostToTypeNode[] toJavaNodes, @Cached.Exclusive @Cached HostContext.ToGuestValueNode toGuest, @Cached.Exclusive @Cached InlinedExactClassProfile receiverProfile, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="seenScope") @Cached InlinedBranchProfile seenDynamicScope, @Cached(value="hostContext.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws ArityException, UnsupportedTypeException {
        int arity = cachedMethod.getParameterCount();
        if (args2.length != arity) {
            errorBranch.enter(node);
            throw ArityException.create(arity, arity, args2.length);
        }
        Class<?>[] types = cachedMethod.getParameterTypes();
        Type[] genericTypes = cachedMethod.getGenericParameterTypes();
        Object[] convertedArguments = new Object[args2.length];
        HostMethodScope scope = HostMethodScope.openStatic(cachedMethod);
        try {
            try {
                for (int i = 0; i < toJavaNodes.length; ++i) {
                    Object operand = HostMethodScope.addToScopeStatic(scope, cachedMethod, i, args2[i]);
                    convertedArguments[i] = toJavaNodes[i].execute(toJavaNodes[i], hostContext, operand, types[i], genericTypes[i], true);
                }
            }
            catch (RuntimeException e2) {
                errorBranch.enter(node);
                if (cache.language.access.isEngineException(e2)) {
                    throw HostInteropErrors.unsupportedTypeException(args2, (Throwable)cache.language.access.unboxEngineException(e2));
                }
                throw e2;
            }
            Object object = HostExecuteNode.doInvoke(node, cachedMethod, receiverProfile.profile(node, obj), convertedArguments, cache, hostContext, toGuest);
            return object;
        }
        finally {
            HostMethodScope.closeStatic(node, scope, cachedMethod, seenDynamicScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"method.isVarArgs()", "method == cachedMethod"}, limit="LIMIT")
    static Object doVarArgs(Node node, HostMethodDesc.SingleMethod method, Object obj, Object[] args2, HostContext hostContext, @Cached(value="method") HostMethodDesc.SingleMethod cachedMethod, @Cached.Exclusive @Cached HostToTypeNode toJavaNode, @Cached.Exclusive @Cached HostContext.ToGuestValueNode toGuest, @Cached.Exclusive @Cached InlinedExactClassProfile receiverProfile, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="seenScope") @Cached InlinedBranchProfile seenDynamicScope, @Cached(value="asVarArgs(args, cachedMethod, hostContext)") boolean asVarArgs, @Cached(value="hostContext.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws ArityException, UnsupportedTypeException {
        int parameterCount = cachedMethod.getParameterCount();
        int minArity = parameterCount - 1;
        if (args2.length < minArity) {
            errorBranch.enter(node);
            throw ArityException.create(minArity, -1, args2.length);
        }
        Class<?>[] types = cachedMethod.getParameterTypes();
        Type[] genericTypes = cachedMethod.getGenericParameterTypes();
        Object[] convertedArguments = new Object[args2.length];
        HostMethodScope scope = HostMethodScope.openStatic(cachedMethod);
        try {
            try {
                int i;
                for (i = 0; i < minArity; ++i) {
                    Object operand = HostMethodScope.addToScopeStatic(scope, cachedMethod, i, args2[i]);
                    convertedArguments[i] = toJavaNode.execute(node, hostContext, operand, types[i], genericTypes[i], true);
                }
                if (asVarArgs) {
                    for (i = minArity; i < args2.length; ++i) {
                        Class<?> expectedType = types[minArity].getComponentType();
                        Type expectedGenericType = HostExecuteNode.getGenericComponentType(genericTypes[minArity]);
                        Object operand = HostMethodScope.addToScopeStatic(scope, cachedMethod, i, args2[i]);
                        convertedArguments[i] = toJavaNode.execute(node, hostContext, operand, expectedType, expectedGenericType, true);
                    }
                    convertedArguments = HostExecuteNode.createVarArgsArray(cachedMethod, convertedArguments, parameterCount);
                } else {
                    Object operand = HostMethodScope.addToScopeStatic(scope, cachedMethod, minArity, args2[minArity]);
                    convertedArguments[minArity] = toJavaNode.execute(node, hostContext, operand, types[minArity], genericTypes[minArity], true);
                }
            }
            catch (RuntimeException e2) {
                errorBranch.enter(node);
                if (cache.language.access.isEngineException(e2)) {
                    throw HostInteropErrors.unsupportedTypeException(args2, (Throwable)cache.language.access.unboxEngineException(e2));
                }
                throw e2;
            }
            Object object = HostExecuteNode.doInvoke(node, cachedMethod, receiverProfile.profile(node, obj), convertedArguments, cache, hostContext, toGuest);
            return object;
        }
        finally {
            HostMethodScope.closeStatic(node, scope, cachedMethod, seenDynamicScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(replaces={"doFixed", "doVarArgs"})
    static Object doSingleUncached(Node node, HostMethodDesc.SingleMethod method, Object obj, Object[] args2, HostContext hostContext, @Cached.Shared(value="toHost") @Cached HostToTypeNode toJavaNode, @Cached.Shared(value="toGuest") @Cached HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="varArgsProfile") @Cached InlinedConditionProfile isVarArgsProfile, @Cached.Shared(value="hostMethodProfile") @Cached HostMethodProfileNode methodProfile, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="seenScope") @Cached InlinedBranchProfile seenScope, @Cached.Shared(value="cache") @Cached(value="hostContext.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws ArityException, UnsupportedTypeException {
        boolean arityError;
        int maxArity;
        int minArity;
        int parameterCount = method.getParameterCount();
        if (isVarArgsProfile.profile(node, method.isVarArgs())) {
            minArity = parameterCount - 1;
            maxArity = -1;
            arityError = args2.length < minArity;
        } else {
            minArity = parameterCount;
            maxArity = method.getParameterCount();
            boolean bl = arityError = args2.length != minArity;
        }
        if (arityError) {
            errorBranch.enter(node);
            throw ArityException.create(minArity, maxArity, args2.length);
        }
        HostMethodScope scope = HostMethodScope.openDynamic(node, method, args2.length, seenScope);
        try {
            Object[] convertedArguments;
            try {
                convertedArguments = HostExecuteNode.prepareArgumentsUncached(node, method, args2, hostContext, toJavaNode, scope, isVarArgsProfile);
            }
            catch (RuntimeException e2) {
                errorBranch.enter(node);
                if (cache.language.access.isEngineException(e2)) {
                    throw HostInteropErrors.unsupportedTypeException(args2, (Throwable)cache.language.access.unboxEngineException(e2));
                }
                throw e2;
            }
            Object object = HostExecuteNode.doInvoke(node, methodProfile.execute(node, method), obj, convertedArguments, cache, hostContext, toGuest);
            return object;
        }
        finally {
            HostMethodScope.closeDynamic(scope, method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExplodeLoop
    @Specialization(guards={"method == cachedMethod", "checkArgTypes(args, cachedArgTypes, interop, hostContext, asVarArgs)"}, limit="LIMIT")
    static final Object doOverloadedCached(Node node, HostMethodDesc.OverloadedMethod method, Object obj, Object[] args2, HostContext hostContext, @Cached(value="method") HostMethodDesc.OverloadedMethod cachedMethod, @Cached.Exclusive @Cached HostToTypeNode toJavaNode, @Cached.Exclusive @Cached HostContext.ToGuestValueNode toGuest, @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached(value="createArgTypesArray(args)") TypeCheckNode[] cachedArgTypes, @Cached(value="selectOverload(node, method, args, hostContext, cachedArgTypes)") HostMethodDesc.SingleMethod overload, @Cached(value="asVarArgs(args, overload, hostContext)") boolean asVarArgs, @Cached.Exclusive @Cached InlinedExactClassProfile receiverProfile, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="seenScope") @Cached InlinedBranchProfile seenVariableScope, @Cached(value="hostContext.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws ArityException, UnsupportedTypeException {
        assert (overload == HostExecuteNode.selectOverload(node, method, args2, hostContext));
        Class<?>[] types = overload.getParameterTypes();
        Type[] genericTypes = overload.getGenericParameterTypes();
        Object[] convertedArguments = new Object[cachedArgTypes.length];
        HostMethodScope scope = HostMethodScope.openStatic(overload);
        try {
            try {
                if (asVarArgs) {
                    assert (overload.isVarArgs());
                    int parameterCount = overload.getParameterCount();
                    for (int i = 0; i < cachedArgTypes.length; ++i) {
                        Class<?> expectedType = i < parameterCount - 1 ? types[i] : types[parameterCount - 1].getComponentType();
                        Type expectedGenericType = i < parameterCount - 1 ? genericTypes[i] : HostExecuteNode.getGenericComponentType(genericTypes[parameterCount - 1]);
                        Object operand = HostMethodScope.addToScopeStatic(scope, overload, i, args2[i]);
                        convertedArguments[i] = toJavaNode.execute(node, hostContext, operand, expectedType, expectedGenericType, true);
                    }
                    convertedArguments = HostExecuteNode.createVarArgsArray(overload, convertedArguments, parameterCount);
                } else {
                    for (int i = 0; i < cachedArgTypes.length; ++i) {
                        Object operand = HostMethodScope.addToScopeStatic(scope, overload, i, args2[i]);
                        convertedArguments[i] = toJavaNode.execute(node, hostContext, operand, types[i], genericTypes[i], true);
                    }
                }
            }
            catch (RuntimeException e2) {
                errorBranch.enter(node);
                if (cache.language.access.isEngineException(e2)) {
                    throw HostInteropErrors.unsupportedTypeException(args2, (Throwable)cache.language.access.unboxEngineException(e2));
                }
                throw e2;
            }
            Object object = HostExecuteNode.doInvoke(node, overload, receiverProfile.profile(node, obj), convertedArguments, cache, hostContext, toGuest);
            return object;
        }
        finally {
            HostMethodScope.closeStatic(node, scope, overload, seenVariableScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(replaces={"doOverloadedCached"})
    static final Object doOverloadedUncached(Node node, HostMethodDesc.OverloadedMethod method, Object obj, Object[] args2, HostContext hostContext, @Cached.Shared(value="toHost") @Cached HostToTypeNode toJavaNode, @Cached.Shared(value="toGuest") @Cached HostContext.ToGuestValueNode toGuest, @Cached.Shared(value="varArgsProfile") @Cached InlinedConditionProfile isVarArgsProfile, @Cached.Shared(value="hostMethodProfile") @Cached HostMethodProfileNode methodProfile, @Cached.Shared(value="errorBranch") @Cached InlinedBranchProfile errorBranch, @Cached.Shared(value="seenScope") @Cached InlinedBranchProfile seenScope, @Cached.Shared(value="cache") @Cached(value="hostContext.getGuestToHostCache()", allowUncached=true) GuestToHostCodeCache cache) throws ArityException, UnsupportedTypeException {
        HostMethodDesc.SingleMethod overload = HostExecuteNode.selectOverload(node, method, args2, hostContext);
        HostMethodScope scope = HostMethodScope.openDynamic(node, overload, args2.length, seenScope);
        try {
            Object[] convertedArguments;
            try {
                convertedArguments = HostExecuteNode.prepareArgumentsUncached(node, overload, args2, hostContext, toJavaNode, scope, isVarArgsProfile);
            }
            catch (RuntimeException e2) {
                errorBranch.enter(node);
                if (cache.language.access.isEngineException(e2)) {
                    throw HostInteropErrors.unsupportedTypeException(args2, (Throwable)cache.language.access.unboxEngineException(e2));
                }
                throw e2;
            }
            Object object = HostExecuteNode.doInvoke(node, methodProfile.execute(node, overload), obj, convertedArguments, cache, hostContext, toGuest);
            return object;
        }
        finally {
            HostMethodScope.closeDynamic(scope, overload);
        }
    }

    private static Object[] prepareArgumentsUncached(Node node, HostMethodDesc.SingleMethod method, Object[] args2, HostContext context2, HostToTypeNode toJavaNode, HostMethodScope scope, InlinedConditionProfile isVarArgsProfile) {
        Class<?>[] types = method.getParameterTypes();
        Type[] genericTypes = method.getGenericParameterTypes();
        Object[] convertedArguments = new Object[args2.length];
        if (isVarArgsProfile.profile(node, method.isVarArgs()) && HostExecuteNode.asVarArgs(args2, method, context2)) {
            int parameterCount = method.getParameterCount();
            for (int i = 0; i < args2.length; ++i) {
                Class<?> expectedType = i < parameterCount - 1 ? types[i] : types[parameterCount - 1].getComponentType();
                Type expectedGenericType = i < parameterCount - 1 ? genericTypes[i] : HostExecuteNode.getGenericComponentType(genericTypes[parameterCount - 1]);
                Object operand = HostMethodScope.addToScopeDynamic(scope, args2[i]);
                convertedArguments[i] = toJavaNode.execute(node, context2, operand, expectedType, expectedGenericType, true);
            }
            convertedArguments = HostExecuteNode.createVarArgsArray(method, convertedArguments, parameterCount);
        } else {
            for (int i = 0; i < args2.length; ++i) {
                Object operand = HostMethodScope.addToScopeDynamic(scope, args2[i]);
                convertedArguments[i] = toJavaNode.execute(node, context2, operand, types[i], genericTypes[i], true);
            }
        }
        return convertedArguments;
    }

    static TypeCheckNode[] createArgTypesArray(Object[] args2) {
        Object[] nodes = new TypeCheckNode[args2.length];
        Arrays.fill(nodes, NullCheckNode.INSTANCE);
        return nodes;
    }

    private static void fillArgTypesArray(Node node, Object[] args2, TypeCheckNode[] cachedArgTypes, HostMethodDesc.SingleMethod selected, boolean varArgs, List<HostMethodDesc.SingleMethod> applicable, int priority, HostContext context2) {
        if (cachedArgTypes == null) {
            return;
        }
        HostClassCache cache = context2.getHostClassCache();
        boolean multiple2 = applicable.size() > 1;
        for (int i = 0; i < args2.length; ++i) {
            Object arg = args2[i];
            Class<?> targetType = HostExecuteNode.getParameterType(selected.getParameterTypes(), i, varArgs);
            LinkedHashSet<HostTargetMapping> otherPossibleMappings = null;
            if (multiple2) {
                for (HostMethodDesc.SingleMethod other : applicable) {
                    Class<?> paramType;
                    if (other == selected || other.isVarArgs() != varArgs || (paramType = HostExecuteNode.getParameterType(other.getParameterTypes(), i, varArgs)) == targetType || HostToTypeNode.canConvert(null, arg, paramType, paramType, null, context2, priority, InteropLibrary.getFactory().getUncached(), HostTargetMappingNode.getUncached())) continue;
                    HostTargetMapping[] otherMappings = cache.getMappings(paramType);
                    if (otherPossibleMappings == null) {
                        otherPossibleMappings = new LinkedHashSet<HostTargetMapping>();
                    }
                    for (HostTargetMapping mapping : otherMappings) {
                        otherPossibleMappings.add(mapping);
                    }
                }
            }
            TypeCheckNode argType = arg == null ? NullCheckNode.INSTANCE : (multiple2 && HostToTypeNode.isPrimitiveOrBigIntegerTarget(context2, targetType) ? HostExecuteNode.createPrimitiveTargetCheck(applicable, selected, arg, targetType, i, priority, varArgs, context2) : (arg instanceof HostObject ? new JavaObjectType(((HostObject)arg).getObjectClass()) : new DirectTypeCheck(arg.getClass())));
            HostTargetMapping[] mappings = cache.getMappings(targetType);
            if (mappings.length > 0 || otherPossibleMappings != null) {
                HostTargetMapping[] otherMappings = otherPossibleMappings != null ? otherPossibleMappings.toArray(HostClassCache.EMPTY_MAPPINGS) : HostClassCache.EMPTY_MAPPINGS;
                argType = new TargetMappingType(argType, mappings, otherMappings, priority);
            }
            cachedArgTypes[i] = node.insert(argType);
        }
        assert (HostExecuteNode.checkArgTypes(args2, cachedArgTypes, InteropLibrary.getFactory().getUncached(), context2, false)) : Arrays.toString(cachedArgTypes);
    }

    private static TypeCheckNode createPrimitiveTargetCheck(List<HostMethodDesc.SingleMethod> applicable, HostMethodDesc.SingleMethod selected, Object arg, Class<?> targetType, int parameterIndex, int priority, boolean varArgs, HostContext context2) {
        Class<?> currentTargetType = targetType;
        ArrayList otherPossibleTypes = new ArrayList();
        for (HostMethodDesc.SingleMethod other : applicable) {
            Class<?> paramType;
            if (other == selected || other.isVarArgs() != varArgs || (paramType = HostExecuteNode.getParameterType(other.getParameterTypes(), parameterIndex, varArgs)) == targetType || otherPossibleTypes.contains(paramType) || !HostToTypeNode.isPrimitiveOrBigIntegerTarget(context2, paramType) && !HostToTypeNode.isPrimitiveOrBigIntegerTarget(context2, targetType) || !HostExecuteNode.isAssignableFrom(targetType, paramType) || HostExecuteNode.isSubtypeOf(arg, paramType)) continue;
            otherPossibleTypes.add(paramType);
        }
        return new PrimitiveType(currentTargetType, otherPossibleTypes.toArray(EMPTY_CLASS_ARRAY), priority);
    }

    @ExplodeLoop
    static boolean checkArgTypes(Object[] args2, TypeCheckNode[] argTypes, InteropLibrary interop, HostContext context2, boolean dummy) {
        if (args2.length != argTypes.length) {
            return false;
        }
        for (int i = 0; i < argTypes.length; ++i) {
            TypeCheckNode argType = argTypes[i];
            if (argType.execute(args2[i], interop, context2)) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean asVarArgs(Object[] args2, HostMethodDesc.SingleMethod overload, HostContext hostContext) {
        if (overload.isVarArgs()) {
            int parameterCount = overload.getParameterCount();
            if (args2.length == parameterCount) {
                Class<?> varArgParamType = overload.getParameterTypes()[parameterCount - 1];
                return !HostToTypeNode.canConvert(null, args2[parameterCount - 1], varArgParamType, overload.getGenericParameterTypes()[parameterCount - 1], null, hostContext, 3, InteropLibrary.getFactory().getUncached(), HostTargetMappingNode.getUncached());
            }
            assert (args2.length != parameterCount);
            return true;
        }
        return false;
    }

    static Class<?> primitiveTypeToBoxedType(Class<?> primitiveType) {
        assert (primitiveType.isPrimitive());
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException();
    }

    static Class<?> boxedTypeToPrimitiveType(Class<?> primitiveType) {
        if (primitiveType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (primitiveType == Byte.class) {
            return Byte.TYPE;
        }
        if (primitiveType == Short.class) {
            return Short.TYPE;
        }
        if (primitiveType == Character.class) {
            return Character.TYPE;
        }
        if (primitiveType == Integer.class) {
            return Integer.TYPE;
        }
        if (primitiveType == Long.class) {
            return Long.TYPE;
        }
        if (primitiveType == Float.class) {
            return Float.TYPE;
        }
        if (primitiveType == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    static HostMethodDesc.SingleMethod selectOverload(Node node, HostMethodDesc.OverloadedMethod method, Object[] args2, HostContext hostContext) throws ArityException, UnsupportedTypeException {
        return HostExecuteNode.selectOverload(node, method, args2, hostContext, null);
    }

    @CompilerDirectives.TruffleBoundary
    static HostMethodDesc.SingleMethod selectOverload(Node node, HostMethodDesc.OverloadedMethod method, Object[] args2, HostContext hostContext, TypeCheckNode[] cachedArgTypes) throws ArityException, UnsupportedTypeException {
        HostMethodDesc.SingleMethod[] overloads = method.getOverloads();
        ArrayList<HostMethodDesc.SingleMethod> applicableByArity = new ArrayList<HostMethodDesc.SingleMethod>();
        int minOverallArity = Integer.MAX_VALUE;
        int maxOverallArity = 0;
        boolean anyVarArgs = false;
        assert (overloads.length > 0);
        for (HostMethodDesc.SingleMethod overload : overloads) {
            int paramCount = overload.getParameterCount();
            if (overload.isVarArgs()) {
                anyVarArgs = true;
                int fixedParamCount = paramCount - 1;
                if (args2.length < fixedParamCount) {
                    minOverallArity = Math.min(minOverallArity, fixedParamCount);
                    maxOverallArity = Math.max(maxOverallArity, fixedParamCount);
                    continue;
                }
            } else if (args2.length != paramCount) {
                minOverallArity = Math.min(minOverallArity, paramCount);
                maxOverallArity = Math.max(maxOverallArity, paramCount);
                continue;
            }
            applicableByArity.add(overload);
        }
        if (applicableByArity.isEmpty()) {
            throw ArityException.create(minOverallArity, anyVarArgs ? -1 : maxOverallArity, args2.length);
        }
        for (int priority : HostToTypeNode.PRIORITIES) {
            HostMethodDesc.SingleMethod best = HostExecuteNode.findBestCandidate(node, applicableByArity, args2, hostContext, false, priority, cachedArgTypes);
            if (best != null) {
                return best;
            }
            if (!anyVarArgs || (best = HostExecuteNode.findBestCandidate(node, applicableByArity, args2, hostContext, true, priority, cachedArgTypes)) == null) continue;
            return best;
        }
        throw HostExecuteNode.noApplicableOverloadsException(overloads, args2);
    }

    private static HostMethodDesc.SingleMethod findBestCandidate(Node node, List<HostMethodDesc.SingleMethod> applicableByArity, Object[] args2, HostContext hostContext, boolean varArgs, int priority, TypeCheckNode[] cachedArgTypes) throws UnsupportedTypeException {
        ArrayList<HostMethodDesc.SingleMethod> candidates = new ArrayList<HostMethodDesc.SingleMethod>();
        if (!varArgs) {
            for (HostMethodDesc.SingleMethod candidate : applicableByArity) {
                int paramCount = candidate.getParameterCount();
                if (candidate.isOnlyVisibleFromJniName() || candidate.isVarArgs() && paramCount != args2.length) continue;
                assert (paramCount == args2.length);
                Class<?>[] parameterTypes = candidate.getParameterTypes();
                Type[] genericParameterTypes = candidate.getGenericParameterTypes();
                boolean applicable = true;
                for (int i = 0; i < paramCount; ++i) {
                    if (HostToTypeNode.canConvert(null, args2[i], parameterTypes[i], genericParameterTypes[i], null, hostContext, priority, InteropLibrary.getFactory().getUncached(args2[i]), HostTargetMappingNode.getUncached())) continue;
                    applicable = false;
                    break;
                }
                if (!applicable) continue;
                candidates.add(candidate);
            }
        } else {
            for (HostMethodDesc.SingleMethod candidate : applicableByArity) {
                if (!candidate.isVarArgs() || candidate.isOnlyVisibleFromJniName()) continue;
                int parameterCount = candidate.getParameterCount();
                Class<?>[] parameterTypes = candidate.getParameterTypes();
                Type[] genericParameterTypes = candidate.getGenericParameterTypes();
                boolean applicable = true;
                for (int i = 0; i < parameterCount - 1; ++i) {
                    if (HostToTypeNode.canConvert(null, args2[i], parameterTypes[i], genericParameterTypes[i], null, hostContext, priority, InteropLibrary.getFactory().getUncached(args2[i]), HostTargetMappingNode.getUncached())) continue;
                    applicable = false;
                    break;
                }
                if (!applicable) continue;
                Class<?> varArgsComponentType = parameterTypes[parameterCount - 1].getComponentType();
                Type varArgsGenericComponentType = genericParameterTypes[parameterCount - 1];
                if (varArgsGenericComponentType instanceof GenericArrayType) {
                    GenericArrayType arrayType = (GenericArrayType)varArgsGenericComponentType;
                    varArgsGenericComponentType = arrayType.getGenericComponentType();
                } else {
                    varArgsGenericComponentType = varArgsComponentType;
                }
                for (int i = parameterCount - 1; i < args2.length; ++i) {
                    if (HostToTypeNode.canConvert(null, args2[i], varArgsComponentType, varArgsGenericComponentType, null, hostContext, priority, InteropLibrary.getFactory().getUncached(args2[i]), HostTargetMappingNode.getUncached())) continue;
                    applicable = false;
                    break;
                }
                if (!applicable) continue;
                candidates.add(candidate);
            }
        }
        if (!candidates.isEmpty()) {
            HostMethodDesc.SingleMethod best;
            if (candidates.size() == 1) {
                best = (HostMethodDesc.SingleMethod)candidates.get(0);
                if (cachedArgTypes != null) {
                    HostExecuteNode.fillArgTypesArray(node, args2, cachedArgTypes, best, varArgs, applicableByArity, priority, hostContext);
                }
                return best;
            }
            best = HostExecuteNode.findMostSpecificOverload(hostContext, candidates, args2, varArgs, priority);
            if (best != null) {
                if (cachedArgTypes != null) {
                    HostExecuteNode.fillArgTypesArray(node, args2, cachedArgTypes, best, varArgs, applicableByArity, priority, hostContext);
                }
                return best;
            }
            throw HostExecuteNode.ambiguousOverloadsException(candidates, args2);
        }
        return null;
    }

    private static HostMethodDesc.SingleMethod findMostSpecificOverload(HostContext context2, List<HostMethodDesc.SingleMethod> candidates, Object[] args2, boolean varArgs, int priority) {
        assert (candidates.size() >= 2);
        if (candidates.size() == 2) {
            int res = HostExecuteNode.compareOverloads(context2, candidates.get(0), candidates.get(1), args2, varArgs, priority);
            return res == 0 ? null : (res < 0 ? candidates.get(0) : candidates.get(1));
        }
        Iterator<HostMethodDesc.SingleMethod> candIt = candidates.iterator();
        LinkedList<HostMethodDesc.SingleMethod> best = new LinkedList<HostMethodDesc.SingleMethod>();
        best.add(candIt.next());
        while (candIt.hasNext()) {
            HostMethodDesc.SingleMethod cand = candIt.next();
            boolean add2 = false;
            Iterator bestIt = best.iterator();
            while (bestIt.hasNext()) {
                int res = HostExecuteNode.compareOverloads(context2, cand, (HostMethodDesc.SingleMethod)bestIt.next(), args2, varArgs, priority);
                if (res == 0) {
                    add2 = true;
                    continue;
                }
                if (res < 0) {
                    bestIt.remove();
                    add2 = true;
                    continue;
                }
                assert (res > 0);
            }
            if (!add2) continue;
            best.add(cand);
        }
        assert (!best.isEmpty());
        if (best.size() == 1) {
            return (HostMethodDesc.SingleMethod)best.get(0);
        }
        return null;
    }

    private static int compareOverloads(HostContext context2, HostMethodDesc.SingleMethod m1, HostMethodDesc.SingleMethod m2, Object[] args2, boolean varArgs, int priority) {
        int res = 0;
        assert (!varArgs || m1.isVarArgs() && m2.isVarArgs());
        assert (varArgs || m1.getParameterCount() == m2.getParameterCount() && args2.length == m1.getParameterCount());
        for (int i = 0; i < args2.length; ++i) {
            int r;
            Class<?> t2;
            Class<?> t1 = HostExecuteNode.getParameterType(m1.getParameterTypes(), i, varArgs);
            if (t1 == (t2 = HostExecuteNode.getParameterType(m2.getParameterTypes(), i, varArgs)) || (r = HostExecuteNode.compareByPriority(context2, t1, t2, args2[i], priority)) == 0 && (r = HostExecuteNode.compareAssignable(t1, t2)) == 0) continue;
            if (res == 0) {
                res = r;
                continue;
            }
            if (res == r) continue;
            res = 0;
            break;
        }
        return res;
    }

    private static Class<?> getParameterType(Class<?>[] parameterTypes, int i, boolean varArgs) {
        return varArgs && i >= parameterTypes.length - 1 ? parameterTypes[parameterTypes.length - 1].getComponentType() : parameterTypes[i];
    }

    private static int compareByPriority(HostContext context2, Class<?> t1, Class<?> t2, Object arg, int priority) {
        if (priority <= 1) {
            return 0;
        }
        InteropLibrary argInterop = InteropLibrary.getFactory().getUncached(arg);
        HostTargetMappingNode mapping = HostTargetMappingNode.getUncached();
        for (int p : HostToTypeNode.PRIORITIES) {
            boolean p2;
            if (p > priority) break;
            boolean p1 = HostToTypeNode.canConvert(null, arg, t1, t1, null, context2, p, argInterop, mapping);
            if (p1 == (p2 = HostToTypeNode.canConvert(null, arg, t2, t2, null, context2, p, argInterop, mapping))) continue;
            return p1 ? -1 : 1;
        }
        return 0;
    }

    private static int compareAssignable(Class<?> t1, Class<?> t2) {
        if (HostExecuteNode.isAssignableFrom(t1, t2)) {
            return 1;
        }
        if (HostExecuteNode.isAssignableFrom(t2, t1)) {
            return -1;
        }
        return 0;
    }

    private static boolean isAssignableFrom(Class<?> toType, Class<?> fromType) {
        Class<?> toAsPrimitive;
        if (toType.isAssignableFrom(fromType)) {
            return true;
        }
        boolean fromIsPrimitive = fromType.isPrimitive();
        boolean toIsPrimitive = toType.isPrimitive();
        Class<?> fromAsPrimitive = fromIsPrimitive ? fromType : HostExecuteNode.boxedTypeToPrimitiveType(fromType);
        Class<?> clazz = toAsPrimitive = toIsPrimitive ? toType : HostExecuteNode.boxedTypeToPrimitiveType(toType);
        if (toAsPrimitive != null && fromAsPrimitive != null) {
            if (toAsPrimitive == fromAsPrimitive) {
                assert (fromIsPrimitive != toIsPrimitive);
                return fromIsPrimitive;
            }
            if (HostExecuteNode.isWideningPrimitiveConversion(toAsPrimitive, fromAsPrimitive)) {
                return true;
            }
        } else {
            if (fromAsPrimitive == Character.TYPE && (toType == String.class || toType == CharSequence.class)) {
                return true;
            }
            if (toAsPrimitive == null && fromAsPrimitive != null && toType.isAssignableFrom(HostExecuteNode.primitiveTypeToBoxedType(fromAsPrimitive))) {
                return true;
            }
            if (toAsPrimitive == null && fromAsPrimitive != null && toType == BigInteger.class && Number.class.isAssignableFrom(HostExecuteNode.primitiveTypeToBoxedType(fromAsPrimitive))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isSubtypeOf(Object argument2, Class<?> parameterType) {
        Class<?> boxedToPrimitive;
        Object value2 = argument2;
        if (argument2 instanceof HostObject) {
            value2 = ((HostObject)argument2).obj;
        }
        if (!parameterType.isPrimitive()) {
            return value2 == null || parameterType.isInstance(value2) && !(value2 instanceof TruffleObject);
        }
        if (value2 != null && (boxedToPrimitive = HostExecuteNode.boxedTypeToPrimitiveType(value2.getClass())) != null) {
            return boxedToPrimitive == parameterType || HostExecuteNode.isWideningPrimitiveConversion(parameterType, boxedToPrimitive);
        }
        return false;
    }

    private static boolean isWideningPrimitiveConversion(Class<?> toType, Class<?> fromType) {
        assert (toType.isPrimitive());
        if (fromType == Byte.TYPE) {
            return toType == Short.TYPE || toType == Integer.TYPE || toType == Long.TYPE || toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Short.TYPE) {
            return toType == Integer.TYPE || toType == Long.TYPE || toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Character.TYPE) {
            return toType == Integer.TYPE || toType == Long.TYPE || toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Integer.TYPE) {
            return toType == Long.TYPE || toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Long.TYPE) {
            return toType == Float.TYPE || toType == Double.TYPE;
        }
        if (fromType == Float.TYPE) {
            return toType == Double.TYPE;
        }
        return false;
    }

    private static RuntimeException ambiguousOverloadsException(List<HostMethodDesc.SingleMethod> candidates, Object[] args2) throws UnsupportedTypeException {
        String message = String.format("Multiple applicable overloads found for method name %s (candidates: %s, arguments: %s)", candidates.get(0).getName(), candidates, HostExecuteNode.arrayToStringWithTypes(args2));
        throw UnsupportedTypeException.create(args2, message);
    }

    private static RuntimeException noApplicableOverloadsException(HostMethodDesc.SingleMethod[] overloads, Object[] args2) throws UnsupportedTypeException {
        String message = String.format("no applicable overload found (overloads: %s, arguments: %s)", Arrays.toString(overloads), HostExecuteNode.arrayToStringWithTypes(args2));
        throw UnsupportedTypeException.create(args2, message);
    }

    private static Type getGenericComponentType(Type type) {
        return type instanceof GenericArrayType ? ((GenericArrayType)type).getGenericComponentType() : ((Class)type).getComponentType();
    }

    @CompilerDirectives.TruffleBoundary
    private static Object[] createVarArgsArray(HostMethodDesc.SingleMethod method, Object[] args2, int parameterCount) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] arguments = new Object[parameterCount];
        for (int i = 0; i < parameterCount - 1; ++i) {
            arguments[i] = args2[i];
        }
        Class<?> varArgsType = parameterTypes[parameterCount - 1].getComponentType();
        Object varArgs = Array.newInstance(varArgsType, args2.length - parameterCount + 1);
        int i = parameterCount - 1;
        int j = 0;
        while (i < args2.length) {
            Array.set(varArgs, j, args2[i]);
            ++i;
            ++j;
        }
        arguments[parameterCount - 1] = varArgs;
        return arguments;
    }

    private static Object doInvoke(Node node, HostMethodDesc.SingleMethod method, Object obj, Object[] arguments, GuestToHostCodeCache cache, HostContext hostContext, HostContext.ToGuestValueNode toGuest) {
        assert (cache == hostContext.getGuestToHostCache());
        assert (arguments.length == method.getParameterCount());
        Object ret = method.invokeGuestToHost(obj, arguments, cache, hostContext, node);
        return toGuest.execute(node, hostContext, ret);
    }

    private static String arrayToStringWithTypes(Object[] args2) {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (Object arg : args2) {
            sj.add(arg == null ? null : arg.toString() + " (" + arg.getClass().getSimpleName() + ")");
        }
        return sj.toString();
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    static abstract class HostMethodProfileNode
    extends Node {
        HostMethodProfileNode() {
        }

        public abstract HostMethodDesc.SingleMethod execute(Node var1, HostMethodDesc.SingleMethod var2);

        @Specialization
        static HostMethodDesc.SingleMethod mono(HostMethodDesc.SingleMethod.MHBase method) {
            return method;
        }

        @Specialization
        static HostMethodDesc.SingleMethod mono(HostMethodDesc.SingleMethod.ReflectBase method) {
            return method;
        }

        @Specialization(replaces={"mono"})
        static HostMethodDesc.SingleMethod poly(HostMethodDesc.SingleMethod method) {
            return method;
        }
    }

    static abstract class TypeCheckNode
    extends Node {
        TypeCheckNode() {
        }

        abstract boolean execute(Object var1, InteropLibrary var2, HostContext var3);
    }

    static final class NullCheckNode
    extends TypeCheckNode {
        static final NullCheckNode INSTANCE = new NullCheckNode();

        NullCheckNode() {
        }

        @Override
        boolean execute(Object test, InteropLibrary interop, HostContext context2) {
            return test == null;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

        @Override
        public String toString() {
            return "null";
        }
    }

    static final class JavaObjectType
    extends TypeCheckNode {
        final Class<?> clazz;

        JavaObjectType(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        boolean execute(Object arg, InteropLibrary interop, HostContext context2) {
            return arg instanceof HostObject && ((HostObject)arg).getObjectClass() == this.clazz;
        }

        public int hashCode() {
            return this.clazz == null ? 0 : this.clazz.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JavaObjectType)) {
                return false;
            }
            JavaObjectType other = (JavaObjectType)obj;
            return Objects.equals(this.clazz, other.clazz);
        }

        @Override
        public String toString() {
            return "JavaObject[" + this.clazz.getTypeName() + "]";
        }
    }

    static final class DirectTypeCheck
    extends TypeCheckNode {
        final Class<?> clazz;

        DirectTypeCheck(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        boolean execute(Object test, InteropLibrary interop, HostContext context2) {
            return test != null && test.getClass() == this.clazz;
        }

        @Override
        public String toString() {
            return this.clazz.toString();
        }
    }

    static final class TargetMappingType
    extends TypeCheckNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final HostTargetMapping[] mappings;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final HostTargetMapping[] otherMappings;
        @Node.Child
        TypeCheckNode fallback;
        @Node.Children
        final HostTargetMappingNode.SingleMappingNode[] mappingNodes;
        @Node.Children
        final HostTargetMappingNode.SingleMappingNode[] otherMappingNodes;
        final int priority;

        TargetMappingType(TypeCheckNode fallback, HostTargetMapping[] mappings, HostTargetMapping[] otherMappings, int priority) {
            int i;
            this.fallback = fallback;
            this.priority = priority;
            this.mappings = mappings;
            this.otherMappings = otherMappings;
            this.mappingNodes = new HostTargetMappingNode.SingleMappingNode[mappings.length];
            for (i = 0; i < mappings.length; ++i) {
                this.mappingNodes[i] = HostTargetMappingNodeGen.SingleMappingNodeGen.create();
            }
            this.otherMappingNodes = new HostTargetMappingNode.SingleMappingNode[otherMappings.length];
            for (i = 0; i < otherMappings.length; ++i) {
                this.otherMappingNodes[i] = HostTargetMappingNodeGen.SingleMappingNodeGen.create();
            }
        }

        @Override
        @ExplodeLoop
        boolean execute(Object test, InteropLibrary interop, HostContext context2) {
            Object result;
            HostTargetMapping mapping;
            int i;
            for (i = 0; i < this.otherMappingNodes.length; ++i) {
                mapping = this.otherMappings[i];
                if (mapping.hostPriority > this.priority) break;
                result = this.otherMappingNodes[i].execute(test, mapping, context2, interop, true);
                if (result != Boolean.TRUE) continue;
                return false;
            }
            for (i = 0; i < this.mappingNodes.length; ++i) {
                mapping = this.mappings[i];
                if (mapping.hostPriority > this.priority) break;
                result = this.mappingNodes[i].execute(test, mapping, context2, interop, true);
                if (result != Boolean.TRUE) continue;
                return true;
            }
            return this.fallback.execute(test, interop, context2);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TargetMappingType)) {
                return false;
            }
            TargetMappingType other = (TargetMappingType)obj;
            return Arrays.equals(this.mappings, other.mappings);
        }

        public int hashCode() {
            return Arrays.hashCode(this.mappings);
        }
    }

    static final class PrimitiveType
    extends TypeCheckNode {
        final Class<?> targetType;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final Class<?>[] otherTypes;
        final int priority;

        PrimitiveType(Class<?> targetType, Class<?>[] otherTypes, int priority) {
            this.targetType = targetType;
            this.otherTypes = otherTypes;
            this.priority = priority;
        }

        public int hashCode() {
            return this.targetType == null ? 0 : this.targetType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PrimitiveType)) {
                return false;
            }
            PrimitiveType other = (PrimitiveType)obj;
            return Objects.equals(this.targetType, other.targetType) && Arrays.equals(this.otherTypes, other.otherTypes);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Primitive[");
            sb.append(this.targetType.getTypeName());
            if (this.otherTypes.length > 0) {
                for (Class<?> otherType : this.otherTypes) {
                    sb.append(", !");
                    sb.append(otherType.getTypeName());
                }
            }
            sb.append(']');
            return sb.toString();
        }

        @Override
        @ExplodeLoop
        public boolean execute(Object value2, InteropLibrary interop, HostContext context2) {
            for (Class<?> otherType : this.otherTypes) {
                if (!HostToTypeNode.canConvert(null, value2, otherType, otherType, null, context2, this.priority, interop, null)) continue;
                return false;
            }
            return HostToTypeNode.canConvert(null, value2, this.targetType, this.targetType, null, context2, this.priority, interop, null);
        }
    }
}

