/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.parsers;

import com.github.ajalt.clikt.core.IncorrectOptionValueCount;
import com.github.ajalt.clikt.parameters.options.Option;
import com.github.ajalt.clikt.parsers.OptionParser;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0016J6\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/github/ajalt/clikt/parsers/OptionWithValuesParser;", "Lcom/github/ajalt/clikt/parsers/OptionParser;", "()V", "parseLongOpt", "Lcom/github/ajalt/clikt/parsers/OptionParser$ParseResult;", "option", "Lcom/github/ajalt/clikt/parameters/options/Option;", "name", "", "argv", "", "index", "", "explicitValue", "parseShortOpt", "optionIndex", "clikt"})
public final class OptionWithValuesParser
implements OptionParser {
    @NotNull
    public static final OptionWithValuesParser INSTANCE = new OptionWithValuesParser();

    private OptionWithValuesParser() {
    }

    @Override
    @NotNull
    public OptionParser.ParseResult parseLongOpt(@NotNull Option option2, @NotNull String name, @NotNull List<String> argv, int index, @Nullable String explicitValue) {
        OptionParser.Invocation invocation;
        Intrinsics.checkNotNullParameter(option2, "option");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(argv, "argv");
        if (!(option2.getNvalues() > 0)) {
            boolean $i$a$-require-OptionWithValuesParser$parseLongOpt$22 = false;
            String $i$a$-require-OptionWithValuesParser$parseLongOpt$22 = "This parser can only be used with a fixed number of arguments. Try the flag parser instead.";
            throw new IllegalArgumentException($i$a$-require-OptionWithValuesParser$parseLongOpt$22.toString());
        }
        boolean hasIncludedValue = explicitValue != null;
        int consumedCount = hasIncludedValue ? option2.getNvalues() : option2.getNvalues() + 1;
        int endIndex = index + consumedCount - 1;
        if (endIndex > CollectionsKt.getLastIndex(argv)) {
            throw new IncorrectOptionValueCount(option2, name, null, 4, null);
        }
        if (option2.getNvalues() > 1) {
            List<String> args2 = CollectionsKt.slice(argv, new IntRange(index + 1, endIndex));
            if (explicitValue != null) {
                args2 = CollectionsKt.plus((Collection)CollectionsKt.listOf(explicitValue), (Iterable)args2);
            }
            invocation = new OptionParser.Invocation(name, args2);
        } else {
            String string = explicitValue;
            if (string == null) {
                string = argv.get(index + 1);
            }
            invocation = new OptionParser.Invocation(name, CollectionsKt.listOf(string));
        }
        OptionParser.Invocation invocation2 = invocation;
        return new OptionParser.ParseResult(consumedCount, invocation2);
    }

    @Override
    @NotNull
    public OptionParser.ParseResult parseShortOpt(@NotNull Option option2, @NotNull String name, @NotNull List<String> argv, int index, int optionIndex) {
        String string;
        boolean hasIncludedValue;
        Intrinsics.checkNotNullParameter(option2, "option");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(argv, "argv");
        String opt = argv.get(index);
        boolean bl = hasIncludedValue = optionIndex != StringsKt.getLastIndex(opt);
        if (hasIncludedValue) {
            String string2 = opt.substring(optionIndex + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
        } else {
            string = null;
        }
        String explicitValue = string;
        return this.parseLongOpt(option2, name, argv, index, explicitValue);
    }
}

