/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.pkl.server.Message;
import org.pkl.server.MessageEncoder;
import org.pkl.server.MessageEncoders;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\f*\u00020\u0010H\u0000\u001a\u001b\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u0012*\b\u0012\u0004\u0012\u0002H\u00120\u0013\u00a2\u0006\u0002\u0010\u0014\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\" \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"threadLocalBufferPacker", "Ljava/lang/ThreadLocal;", "Lorg/msgpack/core/MessageBufferPacker;", "getThreadLocalBufferPacker", "()Ljava/lang/ThreadLocal;", "threadLocalEncoder", "Lkotlin/Function1;", "Lorg/pkl/server/Message;", "", "encode", "message", "log", "", "msg", "", "closeQuietly", "Ljava/lang/AutoCloseable;", "getUnderlying", "T", "Ljava/util/concurrent/Future;", "(Ljava/util/concurrent/Future;)Ljava/lang/Object;", "pkl-server"})
public final class UtilsKt {
    @NotNull
    private static final ThreadLocal<MessageBufferPacker> threadLocalBufferPacker;
    @NotNull
    private static final ThreadLocal<Function1<Message, byte[]>> threadLocalEncoder;

    public static final void log(@NotNull String msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (Intrinsics.areEqual(System.getenv("PKL_DEBUG"), "1")) {
            System.err.println("[pkl-server] " + msg);
        }
    }

    public static final void closeQuietly(@NotNull AutoCloseable $this$closeQuietly) {
        Intrinsics.checkNotNullParameter($this$closeQuietly, "<this>");
        try {
            $this$closeQuietly.close();
        }
        catch (Exception e2) {
            String string = e2.getMessage();
            if (string == null) {
                string = "";
            }
            UtilsKt.log(string);
        }
    }

    @NotNull
    public static final ThreadLocal<MessageBufferPacker> getThreadLocalBufferPacker() {
        return threadLocalBufferPacker;
    }

    @NotNull
    public static final byte[] encode(@NotNull Message message) {
        Intrinsics.checkNotNullParameter(message, "message");
        return threadLocalEncoder.get().invoke(message);
    }

    public static final <T> T getUnderlying(@NotNull Future<T> $this$getUnderlying) {
        T t;
        Intrinsics.checkNotNullParameter($this$getUnderlying, "<this>");
        try {
            t = $this$getUnderlying.get();
        }
        catch (ExecutionException e2) {
            Throwable throwable = e2.getCause();
            Intrinsics.checkNotNull(throwable);
            throw throwable;
        }
        return t;
    }

    private static final MessageBufferPacker threadLocalBufferPacker$lambda-0() {
        return MessagePack.newDefaultBufferPacker();
    }

    private static final Function1 threadLocalEncoder$lambda-1() {
        MessageBufferPacker packer = threadLocalBufferPacker.get();
        Intrinsics.checkNotNullExpressionValue(packer, "packer");
        MessageEncoder encoder = MessageEncoders.INSTANCE.into(packer);
        return new Function1<Message, byte[]>(packer, encoder){
            final /* synthetic */ MessageBufferPacker $packer;
            final /* synthetic */ MessageEncoder $encoder;
            {
                this.$packer = $packer;
                this.$encoder = $encoder;
                super(1);
            }

            public final byte[] invoke(@NotNull Message message) {
                Intrinsics.checkNotNullParameter(message, "message");
                this.$packer.clear();
                this.$encoder.encode(message);
                byte[] byArray = this.$packer.toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "packer.toByteArray()");
                return byArray;
            }
        };
    }

    static {
        ThreadLocal<MessageBufferPacker> threadLocal = ThreadLocal.withInitial(UtilsKt::threadLocalBufferPacker$lambda-0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, "withInitial { MessagePac\u2026ewDefaultBufferPacker() }");
        threadLocalBufferPacker = threadLocal;
        ThreadLocal<Function1> threadLocal2 = ThreadLocal.withInitial(UtilsKt::threadLocalEncoder$lambda-1);
        Intrinsics.checkNotNullExpressionValue(threadLocal2, "withInitial {\n    val pa\u2026r.toByteArray()\n    }\n  }");
        threadLocalEncoder = threadLocal2;
    }
}

