/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.pkl.core.Logger;
import org.pkl.core.ModuleSource;
import org.pkl.core.PklBugException;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.util.IoUtils;
import org.pkl.server.BinaryEvaluator;
import org.pkl.server.ClientLogger;
import org.pkl.server.ClientModuleKeyFactory;
import org.pkl.server.ClientResourceReader;
import org.pkl.server.CloseEvaluator;
import org.pkl.server.CreateEvaluatorRequest;
import org.pkl.server.CreateEvaluatorResponse;
import org.pkl.server.Dependency;
import org.pkl.server.EvaluateRequest;
import org.pkl.server.EvaluateResponse;
import org.pkl.server.Http;
import org.pkl.server.MessageTransport;
import org.pkl.server.ModuleReaderSpec;
import org.pkl.server.OneWayMessage;
import org.pkl.server.Project;
import org.pkl.server.ProtocolException;
import org.pkl.server.RemoteDependency;
import org.pkl.server.RequestMessage;
import org.pkl.server.ResourceReaderSpec;
import org.pkl.server.ServerException;
import org.pkl.server.UtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J&\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010'\u001a\u00020\u0015R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/pkl/server/Server;", "Ljava/lang/AutoCloseable;", "transport", "Lorg/pkl/server/MessageTransport;", "(Lorg/pkl/server/MessageTransport;)V", "evaluators", "", "", "Lorg/pkl/server/BinaryEvaluator;", "executor", "Ljava/util/concurrent/ExecutorService;", "buildDeclaredDependencies", "Lorg/pkl/core/project/DeclaredDependencies;", "projectFileUri", "Ljava/net/URI;", "dependencies", "", "", "Lorg/pkl/server/Dependency;", "myPackageUri", "close", "", "createEvaluator", "message", "Lorg/pkl/server/CreateEvaluatorRequest;", "evaluatorId", "createModuleKeyFactories", "", "Lorg/pkl/core/module/ModuleKeyFactory;", "modulePathResolver", "Lorg/pkl/core/module/ModulePathResolver;", "createResourceReaders", "Lorg/pkl/core/resource/ResourceReader;", "handleCloseEvaluator", "Lorg/pkl/server/CloseEvaluator;", "handleCreateEvaluator", "handleEvaluate", "msg", "Lorg/pkl/server/EvaluateRequest;", "start", "pkl-server"})
public final class Server
implements AutoCloseable {
    @NotNull
    private final MessageTransport transport;
    @NotNull
    private final Map<Long, BinaryEvaluator> evaluators;
    @NotNull
    private final ExecutorService executor;

    public Server(@NotNull MessageTransport transport) {
        Intrinsics.checkNotNullParameter(transport, "transport");
        this.transport = transport;
        this.evaluators = new ConcurrentHashMap();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue(executorService, "newSingleThreadExecutor()");
        this.executor = executorService;
    }

    public final void start() {
        this.transport.start((Function1<? super OneWayMessage, Unit>)new Function1<OneWayMessage, Unit>(this){
            final /* synthetic */ Server this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OneWayMessage message) {
                Intrinsics.checkNotNullParameter(message, "message");
                if (!(message instanceof CloseEvaluator)) {
                    throw new ProtocolException("Unexpected incoming one-way message: " + message, null, 2, null);
                }
                Server.access$handleCloseEvaluator(this.this$0, (CloseEvaluator)message);
            }
        }, (Function1<? super RequestMessage, Unit>)new Function1<RequestMessage, Unit>(this){
            final /* synthetic */ Server this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RequestMessage message) {
                Intrinsics.checkNotNullParameter(message, "message");
                RequestMessage requestMessage = message;
                if (requestMessage instanceof CreateEvaluatorRequest) {
                    Server.access$handleCreateEvaluator(this.this$0, (CreateEvaluatorRequest)message);
                } else if (requestMessage instanceof EvaluateRequest) {
                    Server.access$handleEvaluate(this.this$0, (EvaluateRequest)message);
                } else {
                    throw new ProtocolException("Unexpected incoming request message: " + message, null, 2, null);
                }
            }
        });
    }

    @Override
    public void close() {
        UtilsKt.closeQuietly(this.transport);
        Iterator<Map.Entry<Long, BinaryEvaluator>> iterator2 = this.evaluators.entrySet().iterator();
        while (iterator2.hasNext()) {
            BinaryEvaluator evaluator = iterator2.next().getValue();
            UtilsKt.closeQuietly(evaluator);
        }
        this.executor.shutdown();
    }

    private final void handleCreateEvaluator(CreateEvaluatorRequest message) {
        BinaryEvaluator binaryEvaluator;
        long evaluatorId = Random.Default.nextLong();
        CreateEvaluatorResponse baseResponse = new CreateEvaluatorResponse(message.getRequestId(), null, null);
        try {
            binaryEvaluator = this.createEvaluator(message, evaluatorId);
        }
        catch (ServerException e2) {
            this.transport.send(CreateEvaluatorResponse.copy$default(baseResponse, 0L, null, e2.getMessage(), 3, null));
            return;
        }
        BinaryEvaluator evaluator = binaryEvaluator;
        Long l = evaluatorId;
        this.evaluators.put(l, evaluator);
        this.transport.send(CreateEvaluatorResponse.copy$default(baseResponse, 0L, evaluatorId, null, 5, null));
    }

    private final void handleEvaluate(EvaluateRequest msg) {
        EvaluateResponse baseResponse = new EvaluateResponse(msg.getRequestId(), msg.getEvaluatorId(), null, null);
        BinaryEvaluator evaluator = this.evaluators.get(msg.getEvaluatorId());
        if (evaluator == null) {
            this.transport.send(EvaluateResponse.copy$default(baseResponse, 0L, 0L, null, "Evaluator with ID " + msg.getEvaluatorId() + " was not found.", 7, null));
            return;
        }
        this.executor.execute(() -> Server.handleEvaluate$lambda-0(evaluator, msg, this, baseResponse));
    }

    private final void handleCloseEvaluator(CloseEvaluator message) {
        BinaryEvaluator evaluator = this.evaluators.remove(message.getEvaluatorId());
        if (evaluator == null) {
            UtilsKt.log("Ignoring close request for unknown evaluator ID `" + message.getEvaluatorId() + "`.");
            return;
        }
        evaluator.close();
    }

    /*
     * WARNING - void declaration
     */
    private final DeclaredDependencies buildDeclaredDependencies(URI projectFileUri, Map<String, ? extends Dependency> dependencies, URI myPackageUri) {
        PackageUri packageUri;
        Map<String, Dependency.RemoteDependency> map2;
        Map<String, Dependency.RemoteDependency> $this$buildDeclaredDependencies_u24lambda_u2d1 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Map.Entry<String, ? extends Dependency> object : dependencies.entrySet()) {
            String string = object.getKey();
            Dependency dep = object.getValue();
            if (!(dep instanceof RemoteDependency)) continue;
            $this$buildDeclaredDependencies_u24lambda_u2d1.put(string, new Dependency.RemoteDependency(new PackageUri(((RemoteDependency)dep).getPackageUri()), ((RemoteDependency)dep).getChecksums()));
        }
        Map<String, Dependency.RemoteDependency> remoteDependencies = MapsKt.build(map2);
        Map map3 = MapsKt.createMapBuilder();
        Object $this$buildDeclaredDependencies_u24lambda_u2d2 = map3;
        boolean bl2 = false;
        for (Map.Entry<String, ? extends Dependency> entry : dependencies.entrySet()) {
            String key3 = entry.getKey();
            Dependency dep = entry.getValue();
            if (!(dep instanceof Project)) continue;
            DeclaredDependencies localDep = this.buildDeclaredDependencies(((Project)dep).getProjectFileUri(), ((Project)dep).getDependencies(), dep.getPackageUri());
            $this$buildDeclaredDependencies_u24lambda_u2d2.put(key3, localDep);
        }
        Map<String, DeclaredDependencies> localDependencies = MapsKt.build(map3);
        Map<String, Dependency.RemoteDependency> map4 = remoteDependencies;
        Map<String, DeclaredDependencies> map5 = localDependencies;
        URI uRI = projectFileUri;
        URI uRI2 = myPackageUri;
        if (uRI2 != null) {
            void p0;
            $this$buildDeclaredDependencies_u24lambda_u2d2 = uRI2;
            URI uRI3 = uRI;
            Map<String, DeclaredDependencies> map6 = map5;
            Map<String, Dependency.RemoteDependency> map7 = map4;
            boolean bl3 = false;
            PackageUri packageUri2 = new PackageUri((URI)p0);
            map4 = map7;
            map5 = map6;
            uRI = uRI3;
            packageUri = packageUri2;
        } else {
            packageUri = null;
        }
        PackageUri packageUri3 = packageUri;
        URI uRI4 = uRI;
        Map<String, DeclaredDependencies> map8 = map5;
        Map<String, Dependency.RemoteDependency> map9 = map4;
        return new DeclaredDependencies(map9, map8, uRI4, packageUri3);
    }

    private final BinaryEvaluator createEvaluator(CreateEvaluatorRequest message, long evaluatorId) {
        DeclaredDependencies declaredDependencies;
        Object object;
        Map<String, String> map2;
        Map<String, String> env;
        List<Pattern> list;
        List<Pattern> allowedModules2;
        List<Path> list2 = message.getModulePaths();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List<Path> modulePaths = list2;
        ModulePathResolver resolver = new ModulePathResolver((Iterable<Path>)modulePaths);
        List<Pattern> list3 = message.getAllowedModules();
        if (list3 == null) {
            list3 = allowedModules2 = CollectionsKt.emptyList();
        }
        if ((list = message.getAllowedResources()) == null) {
            list = CollectionsKt.emptyList();
        }
        List<Pattern> allowedResources2 = list;
        Path rootDir2 = message.getRootDir();
        Map<String, String> map3 = message.getEnv();
        if (map3 == null) {
            map3 = env = MapsKt.emptyMap();
        }
        if ((map2 = message.getProperties()) == null) {
            map2 = MapsKt.emptyMap();
        }
        Map<String, String> properties = map2;
        Duration timeout = message.getTimeout();
        Path cacheDir = message.getCacheDir();
        HttpClient.Builder $this$createEvaluator_u24lambda_u2d6 = HttpClient.builder();
        boolean bl = false;
        Object object2 = message.getHttp();
        if (object2 != null && (object2 = ((Http)object2).getProxy()) != null) {
            List<String> list4;
            Object proxy = object2;
            boolean bl2 = false;
            $this$createEvaluator_u24lambda_u2d6.setProxy(((PklEvaluatorSettings.Proxy)proxy).address(), (list4 = ((PklEvaluatorSettings.Proxy)proxy).noProxy()) == null ? CollectionsKt.emptyList() : list4);
            URI uRI = ((PklEvaluatorSettings.Proxy)proxy).address();
            if (uRI != null) {
                URI p0 = uRI;
                boolean bl3 = false;
                IoUtils.setSystemProxy(p0);
            }
        }
        if ((object = message.getHttp()) != null) {
            byte[] byArray = ((Http)object).getCaCertificates();
            object = byArray;
            if (byArray != null) {
                Object caCertificates = object;
                boolean bl4 = false;
                $this$createEvaluator_u24lambda_u2d6.addCertificates((byte[])caCertificates);
            }
        }
        HttpClient httpClient2 = $this$createEvaluator_u24lambda_u2d6.buildLazily();
        Intrinsics.checkNotNullExpressionValue(httpClient2, "with(HttpClient.builder(\u2026    buildLazily()\n      }");
        HttpClient httpClient3 = httpClient2;
        Project project2 = message.getProject();
        if (project2 != null) {
            Project proj = project2;
            boolean bl5 = false;
            declaredDependencies = this.buildDeclaredDependencies(proj.getProjectFileUri(), proj.getDependencies(), null);
        } else {
            declaredDependencies = null;
        }
        DeclaredDependencies dependencies = declaredDependencies;
        UtilsKt.log("Got dependencies: " + dependencies);
        StackFrameTransformer stackFrameTransformer2 = StackFrameTransformers.defaultTransformer;
        Intrinsics.checkNotNullExpressionValue(stackFrameTransformer2, "defaultTransformer");
        SecurityManager securityManager2 = SecurityManagers.standard(allowedModules2, allowedResources2, SecurityManagers.defaultTrustLevels, rootDir2);
        Intrinsics.checkNotNullExpressionValue(securityManager2, "standard(\n        allowe\u2026,\n        rootDir\n      )");
        return new BinaryEvaluator(stackFrameTransformer2, securityManager2, httpClient3, (Logger)new ClientLogger(evaluatorId, this.transport), (Collection<? extends ModuleKeyFactory>)this.createModuleKeyFactories(message, evaluatorId, resolver), (Collection<? extends ResourceReader>)this.createResourceReaders(message, evaluatorId, resolver), env, properties, timeout, cacheDir, dependencies, message.getOutputFormat());
    }

    private final List<ResourceReader> createResourceReaders(CreateEvaluatorRequest message, long evaluatorId, ModulePathResolver modulePathResolver) {
        List<ResourceReader> list;
        List<ResourceReader> $this$createResourceReaders_u24lambda_u2d8 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        ResourceReader resourceReader = ResourceReaders.environmentVariable();
        Intrinsics.checkNotNullExpressionValue(resourceReader, "environmentVariable()");
        $this$createResourceReaders_u24lambda_u2d8.add(resourceReader);
        ResourceReader resourceReader2 = ResourceReaders.externalProperty();
        Intrinsics.checkNotNullExpressionValue(resourceReader2, "externalProperty()");
        $this$createResourceReaders_u24lambda_u2d8.add(resourceReader2);
        ResourceReader resourceReader3 = ResourceReaders.file();
        Intrinsics.checkNotNullExpressionValue(resourceReader3, "file()");
        $this$createResourceReaders_u24lambda_u2d8.add(resourceReader3);
        ResourceReader resourceReader4 = ResourceReaders.http();
        Intrinsics.checkNotNullExpressionValue(resourceReader4, "http()");
        $this$createResourceReaders_u24lambda_u2d8.add(resourceReader4);
        ResourceReader resourceReader5 = ResourceReaders.https();
        Intrinsics.checkNotNullExpressionValue(resourceReader5, "https()");
        $this$createResourceReaders_u24lambda_u2d8.add(resourceReader5);
        ResourceReader resourceReader6 = ResourceReaders.pkg();
        Intrinsics.checkNotNullExpressionValue(resourceReader6, "pkg()");
        $this$createResourceReaders_u24lambda_u2d8.add(resourceReader6);
        ResourceReader resourceReader7 = ResourceReaders.projectpackage();
        Intrinsics.checkNotNullExpressionValue(resourceReader7, "projectpackage()");
        $this$createResourceReaders_u24lambda_u2d8.add(resourceReader7);
        ResourceReader resourceReader8 = ResourceReaders.modulePath(modulePathResolver);
        Intrinsics.checkNotNullExpressionValue(resourceReader8, "modulePath(modulePathResolver)");
        $this$createResourceReaders_u24lambda_u2d8.add(resourceReader8);
        List<ResourceReaderSpec> list2 = message.getClientResourceReaders();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        for (ResourceReaderSpec readerSpec : list2) {
            ClientResourceReader resourceReader9 = new ClientResourceReader(this.transport, evaluatorId, readerSpec);
            $this$createResourceReaders_u24lambda_u2d8.add(resourceReader9);
        }
        return CollectionsKt.build(list);
    }

    private final List<ModuleKeyFactory> createModuleKeyFactories(CreateEvaluatorRequest message, long evaluatorId, ModulePathResolver modulePathResolver) {
        List<ModuleKeyFactory> list;
        List<ModuleKeyFactory> $this$createModuleKeyFactories_u24lambda_u2d9 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<ModuleReaderSpec> list2 = message.getClientModuleReaders();
        boolean bl2 = list2 != null ? !((Collection)list2).isEmpty() : false;
        if (bl2) {
            $this$createModuleKeyFactories_u24lambda_u2d9.add(new ClientModuleKeyFactory((Collection<ModuleReaderSpec>)message.getClientModuleReaders(), this.transport, evaluatorId));
        }
        ModuleKeyFactory moduleKeyFactory = ModuleKeyFactories.standardLibrary;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory, "standardLibrary");
        $this$createModuleKeyFactories_u24lambda_u2d9.add(moduleKeyFactory);
        List<ModuleKeyFactory> list3 = ModuleKeyFactories.fromServiceProviders();
        Intrinsics.checkNotNullExpressionValue(list3, "fromServiceProviders()");
        $this$createModuleKeyFactories_u24lambda_u2d9.addAll((Collection)list3);
        ModuleKeyFactory moduleKeyFactory2 = ModuleKeyFactories.file;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory2, "file");
        $this$createModuleKeyFactories_u24lambda_u2d9.add(moduleKeyFactory2);
        ModuleKeyFactory moduleKeyFactory3 = ModuleKeyFactories.modulePath(modulePathResolver);
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory3, "modulePath(modulePathResolver)");
        $this$createModuleKeyFactories_u24lambda_u2d9.add(moduleKeyFactory3);
        ModuleKeyFactory moduleKeyFactory4 = ModuleKeyFactories.pkg;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory4, "pkg");
        $this$createModuleKeyFactories_u24lambda_u2d9.add(moduleKeyFactory4);
        ModuleKeyFactory moduleKeyFactory5 = ModuleKeyFactories.projectpackage;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory5, "projectpackage");
        $this$createModuleKeyFactories_u24lambda_u2d9.add(moduleKeyFactory5);
        ModuleKeyFactory moduleKeyFactory6 = ModuleKeyFactories.http;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory6, "http");
        $this$createModuleKeyFactories_u24lambda_u2d9.add(moduleKeyFactory6);
        ModuleKeyFactory moduleKeyFactory7 = ModuleKeyFactories.genericUrl;
        Intrinsics.checkNotNullExpressionValue(moduleKeyFactory7, "genericUrl");
        $this$createModuleKeyFactories_u24lambda_u2d9.add(moduleKeyFactory7);
        return CollectionsKt.build(list);
    }

    private static final void handleEvaluate$lambda-0(BinaryEvaluator $evaluator, EvaluateRequest $msg, Server this$0, EvaluateResponse $baseResponse) {
        Intrinsics.checkNotNullParameter($msg, "$msg");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($baseResponse, "$baseResponse");
        try {
            ModuleSource moduleSource = ModuleSource.create($msg.getModuleUri(), $msg.getModuleText());
            Intrinsics.checkNotNullExpressionValue(moduleSource, "create(msg.moduleUri, msg.moduleText)");
            byte[] resp = $evaluator.evaluate(moduleSource, $msg.getExpr());
            this$0.transport.send(EvaluateResponse.copy$default($baseResponse, 0L, 0L, resp, null, 11, null));
        }
        catch (PklBugException e2) {
            this$0.transport.send(EvaluateResponse.copy$default($baseResponse, 0L, 0L, null, e2.toString(), 7, null));
        }
        catch (PklException e3) {
            this$0.transport.send(EvaluateResponse.copy$default($baseResponse, 0L, 0L, null, e3.getMessage(), 7, null));
        }
    }

    public static final /* synthetic */ void access$handleCloseEvaluator(Server $this, CloseEvaluator message) {
        $this.handleCloseEvaluator(message);
    }

    public static final /* synthetic */ void access$handleCreateEvaluator(Server $this, CreateEvaluatorRequest message) {
        $this.handleCreateEvaluator(message);
    }

    public static final /* synthetic */ void access$handleEvaluate(Server $this, EvaluateRequest msg) {
        $this.handleEvaluate(msg);
    }
}

