/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.msgpack.core.MessageTypeException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ArrayValue;
import org.msgpack.value.Value;
import org.msgpack.value.impl.ImmutableStringValueImpl;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.module.PathElement;
import org.pkl.core.packages.Checksums;
import org.pkl.server.CloseEvaluator;
import org.pkl.server.CreateEvaluatorRequest;
import org.pkl.server.CreateEvaluatorResponse;
import org.pkl.server.DecodeException;
import org.pkl.server.Dependency;
import org.pkl.server.DependencyType;
import org.pkl.server.EvaluateRequest;
import org.pkl.server.EvaluateResponse;
import org.pkl.server.Http;
import org.pkl.server.ListModulesRequest;
import org.pkl.server.ListModulesResponse;
import org.pkl.server.ListResourcesRequest;
import org.pkl.server.ListResourcesResponse;
import org.pkl.server.LogMessage;
import org.pkl.server.Message;
import org.pkl.server.MessageDecoder;
import org.pkl.server.MessageType;
import org.pkl.server.ModuleReaderSpec;
import org.pkl.server.Project;
import org.pkl.server.ProtocolException;
import org.pkl.server.ReadModuleRequest;
import org.pkl.server.ReadModuleResponse;
import org.pkl.server.ReadResourceRequest;
import org.pkl.server.ReadResourceResponse;
import org.pkl.server.RemoteDependency;
import org.pkl.server.ResourceReaderSpec;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010\u0007\u001a\u00020\b*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\f\u001a\u0004\u0018\u00010\b*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u000e*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J'\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\t*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\tH\u0002J \u0010\u0018\u001a\u00020\u0019*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u001b*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J'\u0010\u001c\u001a\u0004\u0018\u00010\u001b*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\tH\u0002J(\u0010!\u001a\n\u0012\u0004\u0012\u00020\"\u0018\u00010\u001f*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010$*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\tH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\tH\u0002J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001f*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\tH\u0002J \u0010)\u001a\u00020\u000b*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010*\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u001f*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u0010+\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010,\u001a\u0004\u0018\u00010\u000b*\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001f\u0010-\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\b0.2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010/J!\u00100\u001a\u0004\u0018\u00010\b*\b\u0012\u0004\u0012\u00020\b0.2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010/R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/pkl/server/MessagePackDecoder;", "Lorg/pkl/server/MessageDecoder;", "unpacker", "Lorg/msgpack/core/MessageUnpacker;", "(Lorg/msgpack/core/MessageUnpacker;)V", "decode", "Lorg/pkl/server/Message;", "get", "Lorg/msgpack/value/Value;", "", "key", "", "getNullable", "unpackBoolean", "", "unpackBooleanOrNull", "(Ljava/util/Map;Ljava/lang/String;)Ljava/lang/Boolean;", "unpackByteArrayOrNull", "", "unpackDependencies", "Lorg/pkl/server/Dependency;", "name", "unpackHttp", "Lorg/pkl/server/Http;", "unpackIntValue", "", "unpackLong", "", "unpackLongOrNull", "(Ljava/util/Map;Ljava/lang/String;)Ljava/lang/Long;", "unpackModuleReaderSpec", "", "Lorg/pkl/server/ModuleReaderSpec;", "unpackPathElements", "Lorg/pkl/core/module/PathElement;", "unpackProject", "Lorg/pkl/server/Project;", "unpackProxy", "Lorg/pkl/core/evaluatorSettings/PklEvaluatorSettings$Proxy;", "unpackResourceReaderSpec", "Lorg/pkl/server/ResourceReaderSpec;", "unpackString", "unpackStringListOrNull", "unpackStringMapOrNull", "unpackStringOrNull", "unpackValue", "", "([Lorg/msgpack/value/Value;Ljava/lang/String;)Lorg/msgpack/value/Value;", "unpackValueOrNull", "pkl-server"})
public final class MessagePackDecoder
implements MessageDecoder {
    @NotNull
    private final MessageUnpacker unpacker;

    public MessagePackDecoder(@NotNull MessageUnpacker unpacker) {
        Intrinsics.checkNotNullParameter(unpacker, "unpacker");
        this.unpacker = unpacker;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Message decode() {
        Message message;
        int arraySize;
        if (!this.unpacker.hasNext()) {
            return null;
        }
        try {
            arraySize = this.unpacker.unpackArrayHeader();
            if (arraySize != 2) {
                throw new DecodeException("Malformed message header (expected size 2, but got " + arraySize + ").", null, 2, null);
            }
            arraySize = this.unpacker.unpackInt();
        }
        catch (MessageTypeException e2) {
            throw new DecodeException("Malformed message header.", e2);
        }
        int code = arraySize;
        try {
            Message message2;
            Map<Value, Value> map2 = this.unpacker.unpackValue().asMapValue().map();
            int e2 = code;
            if (e2 == MessageType.CREATE_EVALUATOR_REQUEST.getCode()) {
                Path path2;
                Path path3;
                Path path4;
                Duration duration;
                Duration duration2;
                Map<String, String> map3;
                Map<String, String> map4;
                Collection collection;
                Collection<Path> collection2;
                List<ResourceReaderSpec> list;
                Collection collection3;
                Collection<Pattern> collection4;
                Collection collection5;
                String p0;
                Collection<Pattern> collection6;
                Object item$iv$iv;
                Iterator iterator2;
                Object $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Collection destination$iv$iv;
                boolean $i$f$map;
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                long l = this.get(map2, "requestId").asIntegerValue().asLong();
                List<String> list2 = this.unpackStringListOrNull(map2, "allowedModules");
                if (list2 != null) {
                    Iterable iterable = list2;
                    var13_8 = l;
                    $i$f$map = false;
                    void var6_18 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        item$iv$iv = iterator2.next();
                        String string = (String)item$iv$iv;
                        collection6 = destination$iv$iv;
                        boolean bl = false;
                        collection6.add(Pattern.compile(p0));
                    }
                    collection6 = (List)destination$iv$iv;
                    l = var13_8;
                    collection5 = collection6;
                } else {
                    collection5 = null;
                }
                List<String> list3 = this.unpackStringListOrNull(map2, "allowedResources");
                if (list3 != null) {
                    $this$map$iv = list3;
                    collection6 = collection5;
                    var13_8 = l;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        item$iv$iv = iterator2.next();
                        p0 = (String)item$iv$iv;
                        collection4 = destination$iv$iv;
                        boolean bl = false;
                        collection4.add(Pattern.compile(p0));
                    }
                    collection4 = (List)destination$iv$iv;
                    l = var13_8;
                    collection5 = collection6;
                    collection3 = collection4;
                } else {
                    collection3 = null;
                }
                List<ModuleReaderSpec> list4 = this.unpackModuleReaderSpec(map2);
                List<ResourceReaderSpec> list5 = this.unpackResourceReaderSpec(map2);
                List<String> list6 = this.unpackStringListOrNull(map2, "modulePaths");
                if (list6 != null) {
                    $this$map$iv = list6;
                    list = list5;
                    var17_36 = list4;
                    collection4 = collection3;
                    collection6 = collection5;
                    var13_8 = l;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        item$iv$iv = iterator2.next();
                        p0 = (String)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl = false;
                        collection2.add(Path.of(p0, new String[0]));
                    }
                    collection2 = (List)destination$iv$iv;
                    l = var13_8;
                    collection5 = collection6;
                    collection3 = collection4;
                    list4 = var17_36;
                    list5 = list;
                    collection = collection2;
                } else {
                    collection = null;
                }
                Map<String, String> map5 = this.unpackStringMapOrNull(map2, "env");
                Map<String, String> map6 = this.unpackStringMapOrNull(map2, "properties");
                Long l2 = this.unpackLongOrNull(map2, "timeoutSeconds");
                if (l2 != null) {
                    void p02;
                    long $i$f$map2 = ((Number)l2).longValue();
                    map4 = map6;
                    map3 = map5;
                    collection2 = collection;
                    list = list5;
                    var17_36 = list4;
                    collection4 = collection3;
                    collection6 = collection5;
                    var13_8 = l;
                    boolean bl = false;
                    duration2 = Duration.ofSeconds((long)p02);
                    l = var13_8;
                    collection5 = collection6;
                    collection3 = collection4;
                    list4 = var17_36;
                    list5 = list;
                    collection = collection2;
                    map5 = map3;
                    map6 = map4;
                    duration = duration2;
                } else {
                    duration = null;
                }
                String string = this.unpackStringOrNull(map2, "rootDir");
                if (string != null) {
                    String p02 = string;
                    duration2 = duration;
                    map4 = map6;
                    map3 = map5;
                    collection2 = collection;
                    list = list5;
                    var17_36 = list4;
                    collection4 = collection3;
                    collection6 = collection5;
                    var13_8 = l;
                    boolean bl = false;
                    path4 = Path.of(p02, new String[0]);
                    l = var13_8;
                    collection5 = collection6;
                    collection3 = collection4;
                    list4 = var17_36;
                    list5 = list;
                    collection = collection2;
                    map5 = map3;
                    map6 = map4;
                    duration = duration2;
                    path3 = path4;
                } else {
                    path3 = null;
                }
                String string2 = this.unpackStringOrNull(map2, "cacheDir");
                if (string2 != null) {
                    String p03 = string2;
                    path4 = path3;
                    duration2 = duration;
                    map4 = map6;
                    map3 = map5;
                    collection2 = collection;
                    list = list5;
                    var17_36 = list4;
                    collection4 = collection3;
                    collection6 = collection5;
                    var13_8 = l;
                    boolean bl = false;
                    Path path5 = Path.of(p03, new String[0]);
                    l = var13_8;
                    collection5 = collection6;
                    collection3 = collection4;
                    list4 = var17_36;
                    list5 = list;
                    collection = collection2;
                    map5 = map3;
                    map6 = map4;
                    duration = duration2;
                    path3 = path4;
                    path2 = path5;
                } else {
                    path2 = null;
                }
                Http http = this.unpackHttp(map2);
                Project project2 = this.unpackProject(map2);
                String string3 = this.unpackStringOrNull(map2, "outputFormat");
                Path path6 = path2;
                Path path7 = path3;
                Duration duration3 = duration;
                Map<String, String> map7 = map6;
                Map<String, String> map8 = map5;
                Collection collection7 = collection;
                List<ResourceReaderSpec> list7 = list5;
                List<ModuleReaderSpec> list8 = list4;
                Collection collection8 = collection3;
                Collection collection9 = collection5;
                long l3 = l;
                message2 = new CreateEvaluatorRequest(l3, (List<Pattern>)collection9, (List<Pattern>)collection8, list8, list7, (List<? extends Path>)collection7, map8, map7, duration3, path7, path6, string3, project2, http);
            } else if (e2 == MessageType.CREATE_EVALUATOR_RESPONSE.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                message2 = new CreateEvaluatorResponse(this.unpackLong(map2, "requestId"), this.unpackLongOrNull(map2, "evaluatorId"), this.unpackStringOrNull(map2, "error"));
            } else if (e2 == MessageType.CLOSE_EVALUATOR.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                message2 = new CloseEvaluator(this.unpackLong(map2, "evaluatorId"));
            } else if (e2 == MessageType.EVALUATE_REQUEST.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                $this$map$iv = this.unpackString(map2, "moduleUri");
                long l = this.unpackLong(map2, "evaluatorId");
                var13_8 = this.unpackLong(map2, "requestId");
                boolean bl = false;
                var17_36 = new URI(p0);
                String string = this.unpackStringOrNull(map2, "expr");
                String string4 = this.unpackStringOrNull(map2, "moduleText");
                URI uRI = var17_36;
                long l4 = l;
                long l5 = var13_8;
                message2 = new EvaluateRequest(l5, l4, uRI, string4, string);
            } else if (e2 == MessageType.EVALUATE_RESPONSE.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                message2 = new EvaluateResponse(this.unpackLong(map2, "requestId"), this.unpackLong(map2, "evaluatorId"), this.unpackByteArrayOrNull(map2, "result"), this.unpackStringOrNull(map2, "error"));
            } else if (e2 == MessageType.LOG_MESSAGE.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                message2 = new LogMessage(this.unpackLong(map2, "evaluatorId"), this.unpackIntValue(map2, "level"), this.unpackString(map2, "message"), this.unpackString(map2, "frameUri"));
            } else if (e2 == MessageType.READ_RESOURCE_REQUEST.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                p0 = this.unpackString(map2, "uri");
                long l = this.unpackLong(map2, "evaluatorId");
                var13_8 = this.unpackLong(map2, "requestId");
                boolean bl = false;
                var17_36 = new URI(p0);
                List<ModuleReaderSpec> list = var17_36;
                long l6 = l;
                long l7 = var13_8;
                message2 = new ReadResourceRequest(l7, l6, (URI)((Object)list));
            } else if (e2 == MessageType.READ_RESOURCE_RESPONSE.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                message2 = new ReadResourceResponse(this.unpackLong(map2, "requestId"), this.unpackLong(map2, "evaluatorId"), this.unpackByteArrayOrNull(map2, "contents"), this.unpackStringOrNull(map2, "error"));
            } else if (e2 == MessageType.READ_MODULE_REQUEST.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                p0 = this.unpackString(map2, "uri");
                long l = this.unpackLong(map2, "evaluatorId");
                var13_8 = this.unpackLong(map2, "requestId");
                boolean bl = false;
                var17_36 = new URI(p0);
                List<ModuleReaderSpec> list = var17_36;
                long l8 = l;
                long l9 = var13_8;
                message2 = new ReadModuleRequest(l9, l8, (URI)((Object)list));
            } else if (e2 == MessageType.READ_MODULE_RESPONSE.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                message2 = new ReadModuleResponse(this.unpackLong(map2, "requestId"), this.unpackLong(map2, "evaluatorId"), this.unpackStringOrNull(map2, "contents"), this.unpackStringOrNull(map2, "error"));
            } else if (e2 == MessageType.LIST_MODULES_REQUEST.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                p0 = this.unpackString(map2, "uri");
                long l = this.unpackLong(map2, "evaluatorId");
                var13_8 = this.unpackLong(map2, "requestId");
                boolean bl = false;
                var17_36 = new URI(p0);
                List<ModuleReaderSpec> list = var17_36;
                long l10 = l;
                long l11 = var13_8;
                message2 = new ListModulesRequest(l11, l10, (URI)((Object)list));
            } else if (e2 == MessageType.LIST_MODULES_RESPONSE.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                message2 = new ListModulesResponse(this.unpackLong(map2, "requestId"), this.unpackLong(map2, "evaluatorId"), this.unpackPathElements(map2, "pathElements"), this.unpackStringOrNull(map2, "error"));
            } else if (e2 == MessageType.LIST_RESOURCES_REQUEST.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                p0 = this.unpackString(map2, "uri");
                long l = this.unpackLong(map2, "evaluatorId");
                var13_8 = this.unpackLong(map2, "requestId");
                boolean bl = false;
                var17_36 = new URI(p0);
                List<ModuleReaderSpec> list = var17_36;
                long l12 = l;
                long l13 = var13_8;
                message2 = new ListResourcesRequest(l13, l12, (URI)((Object)list));
            } else if (e2 == MessageType.LIST_RESOURCES_RESPONSE.getCode()) {
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                message2 = new ListResourcesResponse(this.unpackLong(map2, "requestId"), this.unpackLong(map2, "evaluatorId"), this.unpackPathElements(map2, "pathElements"), this.unpackStringOrNull(map2, "error"));
            } else {
                throw new ProtocolException("Invalid message code: " + code, null, 2, null);
            }
            message = message2;
        }
        catch (MessageTypeException e3) {
            throw new DecodeException("Malformed message body for message with code `" + code + "`.", e3);
        }
        return message;
    }

    private final Value unpackValueOrNull(Value[] $this$unpackValueOrNull, String key2) {
        int i = 0;
        int n = $this$unpackValueOrNull.length + -1;
        int n2 = ProgressionUtilKt.getProgressionLastElement(0, n, 2);
        if (i <= n2) {
            while (true) {
                String currKey;
                if (Intrinsics.areEqual(currKey = $this$unpackValueOrNull[i].asStringValue().asString(), key2)) {
                    return $this$unpackValueOrNull[i + 1];
                }
                if (i == n2) break;
                i += 2;
            }
        }
        return null;
    }

    private final Value getNullable(Map<Value, ? extends Value> $this$getNullable, String key2) {
        return $this$getNullable.get(new ImmutableStringValueImpl(key2));
    }

    private final Value get(Map<Value, ? extends Value> $this$get, String key2) {
        Value value2 = this.getNullable($this$get, key2);
        if (value2 == null) {
            throw new DecodeException("Missing message parameter `" + key2 + "`", null, 2, null);
        }
        return value2;
    }

    private final Value unpackValue(Value[] $this$unpackValue, String key2) {
        Value value2 = this.unpackValueOrNull($this$unpackValue, key2);
        if (value2 == null) {
            throw new DecodeException("Missing message parameter `" + key2 + "`.", null, 2, null);
        }
        return value2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> unpackStringListOrNull(Map<Value, ? extends Value> $this$unpackStringListOrNull, String key2) {
        void $this$mapTo$iv$iv;
        Value value2 = this.getNullable($this$unpackStringListOrNull, key2);
        if (value2 == null) {
            return null;
        }
        Value value3 = value2;
        ArrayValue arrayValue = value3.asArrayValue();
        Intrinsics.checkNotNullExpressionValue(arrayValue, "value.asArrayValue()");
        Iterable $this$map$iv = arrayValue;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Value value4 = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asStringValue().asString());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> unpackStringMapOrNull(Map<Value, ? extends Value> $this$unpackStringMapOrNull, String key2) {
        void $this$associateTo$iv$iv;
        Value value2 = this.getNullable($this$unpackStringMapOrNull, key2);
        if (value2 == null) {
            return null;
        }
        Value value3 = value2;
        Set<Map.Entry<Value, Value>> set = value3.asMapValue().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "value.asMapValue().entrySet()");
        Iterable $this$associate$iv = set;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Object object = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(object, "(k, v)");
            Value k = (Value)object.getKey();
            Value v = (Value)object.getValue();
            object = TuplesKt.to(k.asStringValue().asString(), v.asStringValue().asString());
            map2.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        return destination$iv$iv;
    }

    private final long unpackLong(Map<Value, ? extends Value> $this$unpackLong, String key2) {
        return this.get($this$unpackLong, key2).asIntegerValue().asLong();
    }

    private final boolean unpackBoolean(Map<Value, ? extends Value> $this$unpackBoolean, String key2) {
        return this.get($this$unpackBoolean, key2).asBooleanValue().getBoolean();
    }

    private final Boolean unpackBooleanOrNull(Map<Value, ? extends Value> $this$unpackBooleanOrNull, String key2) {
        Value value2 = this.getNullable($this$unpackBooleanOrNull, key2);
        return value2 != null && (value2 = value2.asBooleanValue()) != null ? Boolean.valueOf(value2.getBoolean()) : null;
    }

    private final Long unpackLongOrNull(Map<Value, ? extends Value> $this$unpackLongOrNull, String key2) {
        Value value2 = this.getNullable($this$unpackLongOrNull, key2);
        return value2 != null && (value2 = value2.asIntegerValue()) != null ? Long.valueOf(value2.asLong()) : null;
    }

    private final int unpackIntValue(Map<Value, ? extends Value> $this$unpackIntValue, String key2) {
        return this.get($this$unpackIntValue, key2).asIntegerValue().asInt();
    }

    private final String unpackString(Map<Value, ? extends Value> $this$unpackString, String key2) {
        String string = this.get($this$unpackString, key2).asStringValue().asString();
        Intrinsics.checkNotNullExpressionValue(string, "get(key).asStringValue().asString()");
        return string;
    }

    private final String unpackStringOrNull(Map<Value, ? extends Value> $this$unpackStringOrNull, String key2) {
        Value value2 = this.getNullable($this$unpackStringOrNull, key2);
        return value2 != null && (value2 = value2.asStringValue()) != null ? value2.asString() : null;
    }

    private final byte[] unpackByteArrayOrNull(Map<Value, ? extends Value> $this$unpackByteArrayOrNull, String key2) {
        Value value2 = this.getNullable($this$unpackByteArrayOrNull, key2);
        return value2 != null && (value2 = value2.asBinaryValue()) != null ? value2.asByteArray() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PathElement> unpackPathElements(Map<Value, ? extends Value> $this$unpackPathElements, String key2) {
        List list;
        Value value2 = this.getNullable($this$unpackPathElements, key2);
        if (value2 != null && (value2 = value2.asArrayValue()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)((Object)value2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pathElement;
                Value value3 = (Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Map<Value, Value> map2 = pathElement.asMapValue().map();
                Intrinsics.checkNotNullExpressionValue(map2, "map");
                collection.add(new PathElement(this.unpackString(map2, "name"), this.unpackBoolean(map2, "isDirectory")));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModuleReaderSpec> unpackModuleReaderSpec(Map<Value, ? extends Value> $this$unpackModuleReaderSpec) {
        void $this$mapTo$iv$iv;
        Value value2 = this.getNullable($this$unpackModuleReaderSpec, "clientModuleReaders");
        if (value2 == null) {
            return null;
        }
        Value keys2 = value2;
        ArrayValue arrayValue = keys2.asArrayValue();
        Intrinsics.checkNotNullExpressionValue(arrayValue, "keys.asArrayValue()");
        Iterable $this$map$iv = CollectionsKt.toList(arrayValue);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void value3;
            Value value4 = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<Value, Value> readerMap = value3.asMapValue().map();
            Intrinsics.checkNotNullExpressionValue(readerMap, "readerMap");
            collection.add(new ModuleReaderSpec(this.unpackString(readerMap, "scheme"), this.unpackBoolean(readerMap, "hasHierarchicalUris"), this.unpackBoolean(readerMap, "isLocal"), this.unpackBoolean(readerMap, "isGlobbable")));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResourceReaderSpec> unpackResourceReaderSpec(Map<Value, ? extends Value> $this$unpackResourceReaderSpec) {
        void $this$mapTo$iv$iv;
        Value value2 = this.getNullable($this$unpackResourceReaderSpec, "clientResourceReaders");
        if (value2 == null) {
            return CollectionsKt.emptyList();
        }
        Value keys2 = value2;
        ArrayValue arrayValue = keys2.asArrayValue();
        Intrinsics.checkNotNullExpressionValue(arrayValue, "keys.asArrayValue()");
        Iterable $this$map$iv = CollectionsKt.toList(arrayValue);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void value3;
            Value value4 = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<Value, Value> readerMap = value3.asMapValue().map();
            Intrinsics.checkNotNullExpressionValue(readerMap, "readerMap");
            collection.add(new ResourceReaderSpec(this.unpackString(readerMap, "scheme"), this.unpackBoolean(readerMap, "hasHierarchicalUris"), this.unpackBoolean(readerMap, "isGlobbable")));
        }
        return (List)destination$iv$iv;
    }

    private final Project unpackProject(Map<Value, ? extends Value> $this$unpackProject) {
        Value value2 = this.getNullable($this$unpackProject, "project");
        Map<Value, Value> map2 = value2 != null && (value2 = value2.asMapValue()) != null ? value2.map() : null;
        if (map2 == null) {
            return null;
        }
        Map<Value, Value> projMap = map2;
        URI projectFileUri = new URI(this.unpackString(projMap, "projectFileUri"));
        Map<String, Dependency> dependencies = this.unpackDependencies(projMap, "dependencies");
        return new Project(projectFileUri, null, dependencies);
    }

    private final Http unpackHttp(Map<Value, ? extends Value> $this$unpackHttp) {
        Value value2 = this.getNullable($this$unpackHttp, "http");
        Map<Value, Value> map2 = value2 != null && (value2 = value2.asMapValue()) != null ? value2.map() : null;
        if (map2 == null) {
            return null;
        }
        Map<Value, Value> httpMap = map2;
        PklEvaluatorSettings.Proxy proxy = this.unpackProxy(httpMap);
        Value value3 = this.getNullable(httpMap, "caCertificates");
        byte[] caCertificates = value3 != null && (value3 = value3.asBinaryValue()) != null ? value3.asByteArray() : null;
        return new Http(caCertificates, proxy);
    }

    private final PklEvaluatorSettings.Proxy unpackProxy(Map<Value, ? extends Value> $this$unpackProxy) {
        Value value2 = this.getNullable($this$unpackProxy, "proxy");
        Map<Value, Value> map2 = value2 != null && (value2 = value2.asMapValue()) != null ? value2.map() : null;
        if (map2 == null) {
            return null;
        }
        Map<Value, Value> proxyMap = map2;
        String address = this.unpackString(proxyMap, "address");
        List<String> noProxy2 = this.unpackStringListOrNull(proxyMap, "noProxy");
        return PklEvaluatorSettings.Proxy.create(address, noProxy2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Dependency> unpackDependencies(Map<Value, ? extends Value> $this$unpackDependencies, String name) {
        void $this$associateTo$iv$iv;
        Map<Value, Value> mapValue = this.get($this$unpackDependencies, name).asMapValue().map();
        Iterable $this$associate$iv = mapValue.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Pair<String, Dependency> pair2;
            Map map2 = destination$iv$iv;
            Object object = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Value key2 = (Value)object.getKey();
            Value value2 = (Value)object.getValue();
            String dependencyName = key2.asStringValue().asString();
            Map<Value, Value> dependencyObj = value2.asMapValue().map();
            Intrinsics.checkNotNullExpressionValue(dependencyObj, "dependencyObj");
            String type = this.unpackString(dependencyObj, "type");
            URI packageUri = new URI(this.unpackString(dependencyObj, "packageUri"));
            if (Intrinsics.areEqual(type, DependencyType.REMOTE.getValue())) {
                Checksums checksums;
                Map<Value, Value> map3;
                Object object2 = this.getNullable(dependencyObj, "checksums");
                if (object2 != null && (object2 = object2.asMapValue()) != null && (object2 = (map3 = object2.map())) != null) {
                    Intrinsics.checkNotNullExpressionValue(object2, "map()");
                    Map<Value, Value> obj = map3;
                    boolean bl2 = false;
                    String sha2562 = this.unpackString(obj, "sha256");
                    checksums = new Checksums(sha2562);
                } else {
                    checksums = null;
                }
                Checksums checksums2 = checksums;
                pair2 = TuplesKt.to(dependencyName, new RemoteDependency(packageUri, checksums2));
            } else {
                Map<String, Dependency> dependencies = this.unpackDependencies(dependencyObj, "dependencies");
                String projectFileUri = this.unpackString(dependencyObj, "projectFileUri");
                pair2 = TuplesKt.to(dependencyName, new Project(new URI(projectFileUri), packageUri, dependencies));
            }
            object = pair2;
            map2.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        return destination$iv$iv;
    }
}

