/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.pkl.core.SecurityManager;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.PathElement;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.module.ResolvedModuleKeys;
import org.pkl.server.ListModulesRequest;
import org.pkl.server.ListModulesResponse;
import org.pkl.server.MessageTransport;
import org.pkl.server.ModuleReaderSpec;
import org.pkl.server.ProtocolException;
import org.pkl.server.ReadModuleRequest;
import org.pkl.server.ReadModuleResponse;
import org.pkl.server.ResponseMessage;
import org.pkl.server.UtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/pkl/server/ClientModuleKeyFactory;", "Lorg/pkl/core/module/ModuleKeyFactory;", "readerSpecs", "", "Lorg/pkl/server/ModuleReaderSpec;", "transport", "Lorg/pkl/server/MessageTransport;", "evaluatorId", "", "(Ljava/util/Collection;Lorg/pkl/server/MessageTransport;J)V", "resolver", "Lorg/pkl/server/ClientModuleKeyFactory$Companion$ClientModuleKeyResolver;", "schemes", "", "", "create", "Ljava/util/Optional;", "Lorg/pkl/core/module/ModuleKey;", "uri", "Ljava/net/URI;", "Companion", "pkl-server"})
public final class ClientModuleKeyFactory
implements ModuleKeyFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<ModuleReaderSpec> readerSpecs;
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final Companion.ClientModuleKeyResolver resolver;

    /*
     * WARNING - void declaration
     */
    public ClientModuleKeyFactory(@NotNull Collection<ModuleReaderSpec> readerSpecs, @NotNull MessageTransport transport, long evaluatorId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(readerSpecs, "readerSpecs");
        Intrinsics.checkNotNullParameter(transport, "transport");
        this.readerSpecs = readerSpecs;
        Iterable iterable = this.readerSpecs;
        ClientModuleKeyFactory clientModuleKeyFactory = this;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModuleReaderSpec moduleReaderSpec = (ModuleReaderSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getScheme());
        }
        clientModuleKeyFactory.schemes = (List)destination$iv$iv;
        this.resolver = new Companion.ClientModuleKeyResolver(transport, evaluatorId);
    }

    @Override
    @NotNull
    public Optional<ModuleKey> create(@NotNull URI uri) {
        Optional<ModuleKey> optional2;
        Intrinsics.checkNotNullParameter(uri, "uri");
        String string = uri.getScheme();
        if (this.schemes.contains(string)) {
            Object v0;
            block3: {
                Iterable iterable = this.readerSpecs;
                for (Object t : iterable) {
                    ModuleReaderSpec it = (ModuleReaderSpec)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getScheme(), uri.getScheme())) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0);
            ModuleReaderSpec readerSpec = v0;
            Companion.ClientModuleKey moduleKey = new Companion.ClientModuleKey(uri, readerSpec, this.resolver);
            Optional<Companion.ClientModuleKey> optional3 = Optional.of(moduleKey);
            optional2 = optional3;
            Intrinsics.checkNotNullExpressionValue(optional3, "{\n        val readerSpec\u2026nal.of(moduleKey)\n      }");
        } else {
            Optional<ModuleKey> optional4 = Optional.empty();
            optional2 = optional4;
            Intrinsics.checkNotNullExpressionValue(optional4, "empty()");
        }
        return optional2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/pkl/server/ClientModuleKeyFactory$Companion;", "", "()V", "ClientModuleKey", "ClientModuleKeyResolver", "pkl-server"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\tJ\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\tJ\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/pkl/server/ClientModuleKeyFactory$Companion$ClientModuleKeyResolver;", "", "transport", "Lorg/pkl/server/MessageTransport;", "evaluatorId", "", "(Lorg/pkl/server/MessageTransport;J)V", "listResponses", "", "Ljava/net/URI;", "Ljava/util/concurrent/Future;", "", "Lorg/pkl/core/module/PathElement;", "readResponses", "", "doListElements", "uri", "doReadModule", "hasElement", "", "securityManager", "Lorg/pkl/core/SecurityManager;", "listElements", "resolveModule", "pkl-server"})
        private static final class ClientModuleKeyResolver {
            @NotNull
            private final MessageTransport transport;
            private final long evaluatorId;
            @NotNull
            private final Map<URI, Future<String>> readResponses;
            @NotNull
            private final Map<URI, Future<List<PathElement>>> listResponses;

            public ClientModuleKeyResolver(@NotNull MessageTransport transport, long evaluatorId) {
                Intrinsics.checkNotNullParameter(transport, "transport");
                this.transport = transport;
                this.evaluatorId = evaluatorId;
                this.readResponses = new ConcurrentHashMap();
                this.listResponses = new ConcurrentHashMap();
            }

            @NotNull
            public final List<PathElement> listElements(@NotNull SecurityManager securityManager2, @NotNull URI uri) {
                Intrinsics.checkNotNullParameter(securityManager2, "securityManager");
                Intrinsics.checkNotNullParameter(uri, "uri");
                securityManager2.checkResolveModule(uri);
                return this.doListElements(uri);
            }

            public final boolean hasElement(@NotNull SecurityManager securityManager2, @NotNull URI uri) {
                boolean bl;
                Intrinsics.checkNotNullParameter(securityManager2, "securityManager");
                Intrinsics.checkNotNullParameter(uri, "uri");
                securityManager2.checkResolveModule(uri);
                try {
                    this.doReadModule(uri);
                    bl = true;
                }
                catch (IOException e2) {
                    bl = false;
                }
                return bl;
            }

            @NotNull
            public final String resolveModule(@NotNull SecurityManager securityManager2, @NotNull URI uri) {
                Intrinsics.checkNotNullParameter(securityManager2, "securityManager");
                Intrinsics.checkNotNullParameter(uri, "uri");
                securityManager2.checkResolveModule(uri);
                return this.doReadModule(uri);
            }

            private final String doReadModule(URI uri) {
                Future future = this.readResponses.computeIfAbsent(uri, arg_0 -> ClientModuleKeyResolver.doReadModule$lambda-1(this, uri, arg_0));
                Intrinsics.checkNotNullExpressionValue(future, "readResponses\n          \u2026            }\n          }");
                return (String)UtilsKt.getUnderlying(future);
            }

            private final List<PathElement> doListElements(URI uri) {
                Future future = this.listResponses.computeIfAbsent(uri, arg_0 -> ClientModuleKeyResolver.doListElements$lambda-3(this, uri, arg_0));
                Intrinsics.checkNotNullExpressionValue(future, "listResponses\n          \u2026            }\n          }");
                return (List)UtilsKt.getUnderlying(future);
            }

            private static final Future doReadModule$lambda-1(ClientModuleKeyResolver this$0, URI $uri, URI it) {
                CompletableFuture<String> completableFuture;
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($uri, "$uri");
                Intrinsics.checkNotNullParameter(it, "it");
                CompletableFuture<String> $this$doReadModule_u24lambda_u2d1_u24lambda_u2d0 = completableFuture = new CompletableFuture<String>();
                boolean bl = false;
                ReadModuleRequest request = new ReadModuleRequest(Random.Default.nextLong(), this$0.evaluatorId, $uri);
                this$0.transport.send(request, (Function1<? super ResponseMessage, Unit>)new Function1<ResponseMessage, Unit>($this$doReadModule_u24lambda_u2d1_u24lambda_u2d0){
                    final /* synthetic */ CompletableFuture<String> $this_apply;
                    {
                        this.$this_apply = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ResponseMessage response) {
                        Intrinsics.checkNotNullParameter(response, "response");
                        if (response instanceof ReadModuleResponse) {
                            if (((ReadModuleResponse)response).getError() != null) {
                                this.$this_apply.completeExceptionally(new IOException(((ReadModuleResponse)response).getError()));
                            } else {
                                String string = ((ReadModuleResponse)response).getContents();
                                Intrinsics.checkNotNull(string);
                                this.$this_apply.complete(string);
                            }
                        } else {
                            this.$this_apply.completeExceptionally(new ProtocolException("unexpected response", null, 2, null));
                        }
                    }
                });
                return completableFuture;
            }

            private static final Future doListElements$lambda-3(ClientModuleKeyResolver this$0, URI $uri, URI it) {
                CompletableFuture<List<PathElement>> completableFuture;
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Intrinsics.checkNotNullParameter($uri, "$uri");
                Intrinsics.checkNotNullParameter(it, "it");
                CompletableFuture<List<PathElement>> $this$doListElements_u24lambda_u2d3_u24lambda_u2d2 = completableFuture = new CompletableFuture<List<PathElement>>();
                boolean bl = false;
                ListModulesRequest request = new ListModulesRequest(Random.Default.nextLong(), this$0.evaluatorId, $uri);
                this$0.transport.send(request, (Function1<? super ResponseMessage, Unit>)new Function1<ResponseMessage, Unit>($this$doListElements_u24lambda_u2d3_u24lambda_u2d2){
                    final /* synthetic */ CompletableFuture<List<PathElement>> $this_apply;
                    {
                        this.$this_apply = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ResponseMessage response) {
                        Intrinsics.checkNotNullParameter(response, "response");
                        if (response instanceof ListModulesResponse) {
                            if (((ListModulesResponse)response).getError() != null) {
                                this.$this_apply.completeExceptionally(new IOException(((ListModulesResponse)response).getError()));
                            } else {
                                List<PathElement> list = ((ListModulesResponse)response).getPathElements();
                                if (list == null) {
                                    list = CollectionsKt.emptyList();
                                }
                                this.$this_apply.complete(list);
                            }
                        } else {
                            this.$this_apply.completeExceptionally(new ProtocolException("unexpected response", null, 2, null));
                        }
                    }
                });
                return completableFuture;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/pkl/server/ClientModuleKeyFactory$Companion$ClientModuleKey;", "Lorg/pkl/core/module/ModuleKey;", "uri", "Ljava/net/URI;", "spec", "Lorg/pkl/server/ModuleReaderSpec;", "resolver", "Lorg/pkl/server/ClientModuleKeyFactory$Companion$ClientModuleKeyResolver;", "(Ljava/net/URI;Lorg/pkl/server/ModuleReaderSpec;Lorg/pkl/server/ClientModuleKeyFactory$Companion$ClientModuleKeyResolver;)V", "getUri", "hasElement", "", "securityManager", "Lorg/pkl/core/SecurityManager;", "hasHierarchicalUris", "isGlobbable", "isLocal", "listElements", "", "Lorg/pkl/core/module/PathElement;", "baseUri", "resolve", "Lorg/pkl/core/module/ResolvedModuleKey;", "pkl-server"})
        private static final class ClientModuleKey
        implements ModuleKey {
            @NotNull
            private final URI uri;
            @NotNull
            private final ModuleReaderSpec spec;
            @NotNull
            private final ClientModuleKeyResolver resolver;

            public ClientModuleKey(@NotNull URI uri, @NotNull ModuleReaderSpec spec, @NotNull ClientModuleKeyResolver resolver) {
                Intrinsics.checkNotNullParameter(uri, "uri");
                Intrinsics.checkNotNullParameter(spec, "spec");
                Intrinsics.checkNotNullParameter(resolver, "resolver");
                this.uri = uri;
                this.spec = spec;
                this.resolver = resolver;
            }

            @Override
            public boolean isLocal() {
                return this.spec.isLocal();
            }

            @Override
            public boolean hasHierarchicalUris() {
                return this.spec.getHasHierarchicalUris();
            }

            @Override
            public boolean isGlobbable() {
                return this.spec.isGlobbable();
            }

            @Override
            @NotNull
            public URI getUri() {
                return this.uri;
            }

            @Override
            @NotNull
            public List<PathElement> listElements(@NotNull SecurityManager securityManager2, @NotNull URI baseUri) {
                Intrinsics.checkNotNullParameter(securityManager2, "securityManager");
                Intrinsics.checkNotNullParameter(baseUri, "baseUri");
                return this.resolver.listElements(securityManager2, baseUri);
            }

            @Override
            @NotNull
            public ResolvedModuleKey resolve(@NotNull SecurityManager securityManager2) {
                Intrinsics.checkNotNullParameter(securityManager2, "securityManager");
                String contents = this.resolver.resolveModule(securityManager2, this.uri);
                ResolvedModuleKey resolvedModuleKey = ResolvedModuleKeys.virtual(this, this.uri, contents, true);
                Intrinsics.checkNotNullExpressionValue(resolvedModuleKey, "virtual(this, uri, contents, true)");
                return resolvedModuleKey;
            }

            @Override
            public boolean hasElement(@NotNull SecurityManager securityManager2, @NotNull URI uri) {
                Intrinsics.checkNotNullParameter(securityManager2, "securityManager");
                Intrinsics.checkNotNullParameter(uri, "uri");
                return this.resolver.hasElement(securityManager2, uri);
            }
        }
    }
}

