/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pkl.core.Logger;
import org.pkl.core.StackFrame;
import org.pkl.server.LogMessage;
import org.pkl.server.MessageTransport;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/pkl/server/ClientLogger;", "Lorg/pkl/core/Logger;", "evaluatorId", "", "transport", "Lorg/pkl/server/MessageTransport;", "(JLorg/pkl/server/MessageTransport;)V", "trace", "", "message", "", "frame", "Lorg/pkl/core/StackFrame;", "warn", "pkl-server"})
public final class ClientLogger
implements Logger {
    private final long evaluatorId;
    @NotNull
    private final MessageTransport transport;

    public ClientLogger(long evaluatorId, @NotNull MessageTransport transport) {
        Intrinsics.checkNotNullParameter(transport, "transport");
        this.evaluatorId = evaluatorId;
        this.transport = transport;
    }

    @Override
    public void trace(@NotNull String message, @NotNull StackFrame frame) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(frame, "frame");
        String string = frame.getModuleUri();
        Intrinsics.checkNotNullExpressionValue(string, "frame.moduleUri");
        this.transport.send(new LogMessage(this.evaluatorId, 0, message, string));
    }

    @Override
    public void warn(@NotNull String message, @NotNull StackFrame frame) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(frame, "frame");
        String string = frame.getModuleUri();
        Intrinsics.checkNotNullExpressionValue(string, "frame.moduleUri");
        this.transport.send(new LogMessage(this.evaluatorId, 1, message, string));
    }
}

