/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.settings;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;
import org.pkl.core.PClassInfo;
import org.pkl.core.PObject;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.Value;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.runtime.VmEvalException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public record PklSettings(Editor editor, @Nullable PklEvaluatorSettings.Http http) {
    private static final List<Pattern> ALLOWED_MODULES = List.of(Pattern.compile("pkl:"), Pattern.compile("file:"));
    private static final List<Pattern> ALLOWED_RESOURCES = List.of(Pattern.compile("env:"), Pattern.compile("file:"));

    public static PklSettings loadFromPklHomeDir() throws VmEvalException {
        return PklSettings.loadFromPklHomeDir(IoUtils.getPklHomeDir());
    }

    static PklSettings loadFromPklHomeDir(Path pklHomeDir) throws VmEvalException {
        Path path2 = pklHomeDir.resolve("settings.pkl");
        return Files.exists(path2, new LinkOption[0]) ? PklSettings.load(ModuleSource.path(path2)) : new PklSettings(Editor.SYSTEM, null);
    }

    public static PklSettings load(ModuleSource moduleSource) throws VmEvalException {
        try (Evaluator evaluator = EvaluatorBuilder.unconfigured().setSecurityManager(SecurityManagers.standard(ALLOWED_MODULES, ALLOWED_RESOURCES, SecurityManagers.defaultTrustLevels, null)).setStackFrameTransformer(StackFrameTransformers.defaultTransformer).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactory(ModuleKeyFactories.file).addResourceReader(ResourceReaders.environmentVariable()).addEnvironmentVariables(System.getenv()).build();){
            PObject module = evaluator.evaluateOutputValueAs(moduleSource, PClassInfo.Settings);
            PklSettings pklSettings = PklSettings.parseSettings(module, moduleSource);
            return pklSettings;
        }
    }

    private static PklSettings parseSettings(PObject module, ModuleSource location) throws VmEvalException {
        PObject pObject;
        Object object = module.getPropertyOrNull("editor");
        if (!(object instanceof PObject) || !((object = (pObject = (PObject)object).getPropertyOrNull("urlScheme")) instanceof String)) {
            throw new VmExceptionBuilder().evalError("invalidSettingsFile", location.getUri()).build();
        }
        String str = (String)object;
        Editor editor = new Editor(str);
        PklEvaluatorSettings.Http httpSettings = PklEvaluatorSettings.Http.parse((Value)module.getProperty("http"));
        return new PklSettings(editor, httpSettings);
    }

    @Deprecated(forRemoval=true)
    public Editor getEditor() {
        return this.editor;
    }

    public record Editor(String urlScheme) {
        public static final Editor SYSTEM = new Editor("%{url}, line %{line}");
        public static final Editor IDEA = new Editor("idea://open?file=%{path}&line=%{line}");
        public static final Editor TEXT_MATE = new Editor("txmt://open?url=%{url}&line=%{line}&column=%{column}");
        public static final Editor SUBLIME = new Editor("subl://open?url=%{url}&line=%{line}&column=%{column}");
        public static final Editor ATOM = new Editor("atom://open?url=%{url}&line=%{line}&column=%{column}");
        public static final Editor VS_CODE = new Editor("vscode://file/%{path}:%{line}:%{column}");

        @Deprecated(forRemoval=true)
        public String getUrlScheme() {
            return this.urlScheme;
        }
    }
}

