/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.pkl.core.Pair;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.Nullable;

@CompilerDirectives.ValueType
public final class VmPair
extends VmValue
implements Iterable<Object> {
    private final Object first;
    private final Object second;
    private boolean forced;

    public VmPair(Object first2, Object second2) {
        this.first = first2;
        this.second = second2;
    }

    public Object getFirst() {
        return this.first;
    }

    public Object getSecond() {
        return this.second;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < 2;
            }

            @Override
            public Object next() {
                return switch (this.pos++) {
                    case 0 -> VmPair.this.first;
                    case 1 -> VmPair.this.second;
                    default -> throw new NoSuchElementException("VmPair only has two elements.");
                };
            }
        };
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getPairClass();
    }

    @Override
    public void force(boolean allowUndefinedValues) {
        if (this.forced) {
            return;
        }
        this.forced = true;
        try {
            VmValue.force(this.first, allowUndefinedValues);
            VmValue.force(this.second, allowUndefinedValues);
        }
        catch (Throwable t) {
            this.forced = false;
            throw t;
        }
    }

    @Override
    public Object export() {
        return new Pair<Object, Object>(VmValue.export(this.first), VmValue.export(this.second));
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitPair(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertPair(this, path2);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmPair)) {
            return false;
        }
        VmPair other = (VmPair)obj;
        return this.first.equals(other.first) && this.second.equals(other.second);
    }

    public int hashCode() {
        return this.first.hashCode() * 31 + this.second.hashCode();
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        this.force(true);
        return VmValueRenderer.singleLine(Integer.MAX_VALUE).render(this);
    }
}

