/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.LateInit;

public final class VmMapping
extends VmObject {
    private int cachedEntryCount = -1;
    @LateInit
    @GuardedBy(value="this")
    private VmSet __allKeys;

    public static VmMapping empty() {
        return EmptyHolder.EMPTY;
    }

    public VmMapping(MaterializedFrame enclosingFrame, VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members) {
        super(enclosingFrame, Objects.requireNonNull(parent), members);
    }

    public static boolean isDefaultProperty(Object propertyKey) {
        return propertyKey == Identifier.DEFAULT;
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getMappingClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public VmSet getAllKeys() {
        VmMapping vmMapping = this;
        synchronized (vmMapping) {
            if (this.__allKeys == null) {
                VmSet vmSet;
                VmObject vmObject = this.parent;
                if (vmObject instanceof VmMapping) {
                    VmMapping mapping = (VmMapping)vmObject;
                    vmSet = mapping.getAllKeys();
                } else {
                    vmSet = VmSet.EMPTY;
                }
                VmSet parentKeys = vmSet;
                VmCollection.Builder<VmSet> builder = VmSet.builder(parentKeys);
                UnmodifiableMapCursor cursor = this.members.getEntries();
                while (cursor.advance()) {
                    ObjectMember member = (ObjectMember)cursor.getValue();
                    if (!member.isEntry()) continue;
                    builder.add(cursor.getKey());
                }
                this.__allKeys = builder.build();
            }
            return this.__allKeys;
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Map<Object, Object> export() {
        LinkedHashMap<Object, Object> properties = CollectionUtils.newLinkedHashMap(EconomicMaps.size(this.cachedValues));
        this.iterateMemberValues((key2, prop, value2) -> {
            if (VmMapping.isDefaultProperty(key2)) {
                return true;
            }
            properties.put(VmValue.export(key2), VmValue.exportNullable(value2));
            return true;
        });
        return properties;
    }

    @CompilerDirectives.TruffleBoundary
    public Map<Object, Object> toMap() {
        LinkedHashMap<Object, Object> properties = CollectionUtils.newLinkedHashMap(EconomicMaps.size(this.cachedValues));
        this.forceAndIterateMemberValues((key2, prop, value2) -> {
            if (VmMapping.isDefaultProperty(key2)) {
                return true;
            }
            properties.put(key2, value2);
            return true;
        });
        return properties;
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitMapping(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertMapping(this, path2);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmMapping)) {
            return false;
        }
        VmMapping other = (VmMapping)obj;
        this.force(false);
        other.force(false);
        if (this.getEntryCount() != other.getEntryCount()) {
            return false;
        }
        UnmodifiableMapCursor cursor = this.cachedValues.getEntries();
        while (cursor.advance()) {
            Object key2 = cursor.getKey();
            if (key2 instanceof Identifier) continue;
            Object value2 = cursor.getValue();
            assert (value2 != null);
            Object otherValue = other.getCachedValue(key2);
            if (value2.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        this.force(false);
        int result = 0;
        UnmodifiableMapCursor cursor = this.cachedValues.getEntries();
        while (cursor.advance()) {
            Object key2 = cursor.getKey();
            if (key2 instanceof Identifier) continue;
            Object value2 = cursor.getValue();
            assert (value2 != null);
            result += key2.hashCode() ^ value2.hashCode();
        }
        this.cachedHash = result;
        return result;
    }

    public int getEntryCount() {
        if (this.cachedEntryCount != -1) {
            return this.cachedEntryCount;
        }
        int result = 0;
        for (Object key2 : this.cachedValues.getKeys()) {
            if (key2 instanceof Identifier) continue;
            ++result;
        }
        this.cachedEntryCount = result;
        return result;
    }

    private static final class EmptyHolder {
        private static final VmMapping EMPTY = new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), EconomicMaps.create());

        private EmptyHolder() {
        }
    }
}

