/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.KeyLookupSuggestions;
import org.pkl.core.runtime.MemberLookupSuggestions;
import org.pkl.core.runtime.VmBugException;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmEvalException;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUndefinedValueException;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public final class VmExceptionBuilder {
    @Nullable
    private Object receiver;
    @Nullable
    private String message;
    @Nullable
    private Throwable cause;
    private VmException.Kind kind = VmException.Kind.EVAL_ERROR;
    private boolean isExternalMessage;
    private Object[] messageArguments = new Object[0];
    private final List<VmException.ProgramValue> programValues = new ArrayList<VmException.ProgramValue>();
    @Nullable
    private Node location;
    @Nullable
    private SourceSection sourceSection;
    @Nullable
    private String memberName;
    @Nullable
    private String hint;

    public VmExceptionBuilder typeMismatch(Object value2, VmClass expectedType) {
        if (value2 instanceof VmNull) {
            return this.evalError("typeMismatchValue", expectedType, "null");
        }
        return this.evalError("typeMismatch", expectedType, VmUtils.getClass(value2)).withProgramValue("Value", value2);
    }

    public VmExceptionBuilder typeMismatch(Object value2, VmClass expectedType1, VmClass expectedType2) {
        if (value2 instanceof VmNull) {
            return this.evalError("typeMismatchValue2", expectedType1, expectedType2, "null");
        }
        return this.evalError("typeMismatch2", expectedType1, expectedType2, VmUtils.getClass(value2)).withProgramValue("Value", value2);
    }

    public VmExceptionBuilder unreachableCode() {
        return this.bug("Unreachable code.", new Object[0]);
    }

    public VmExceptionBuilder undefinedValue() {
        this.kind = VmException.Kind.UNDEFINED_VALUE;
        return this.withExternalMessage("undefinedValue", new Object[0]);
    }

    public VmExceptionBuilder undefinedPropertyValue(Identifier propertyName, Object receiver) {
        this.kind = VmException.Kind.UNDEFINED_VALUE;
        this.receiver = receiver;
        return this.withExternalMessage("undefinedPropertyValue", propertyName);
    }

    public VmExceptionBuilder cannotFindMember(VmObjectLike receiver, Object memberKey) {
        String string;
        List<KeyLookupSuggestions.Candidate> candidates;
        if (memberKey instanceof Identifier) {
            Identifier identifier = (Identifier)memberKey;
            return this.cannotFindProperty(receiver, identifier, true, false);
        }
        if (memberKey instanceof String && !(candidates = KeyLookupSuggestions.forObject(receiver, string = (String)memberKey)).isEmpty()) {
            return this.evalError("cannotFindKeyListCandidates", new VmException.ProgramValue("", memberKey), new MultilineValue(candidates));
        }
        return this.evalError("cannotFindKey", new VmException.ProgramValue("", memberKey));
    }

    public VmExceptionBuilder cannotFindProperty(VmObjectLike receiver, Identifier propertyName, boolean isRead, boolean isImplicitReceiver) {
        EnumSet<MemberLookupSuggestions.Candidate.Kind> memberKinds = isRead ? EnumSet.allOf(MemberLookupSuggestions.Candidate.Kind.class) : EnumSet.of(MemberLookupSuggestions.Candidate.Kind.PROPERTY);
        List<MemberLookupSuggestions.Candidate> candidates = new MemberLookupSuggestions(receiver, propertyName, -1, memberKinds).find(isImplicitReceiver);
        if (candidates.isEmpty()) {
            if (isImplicitReceiver) {
                this.evalError("cannotFindPropertyInScope", propertyName);
            } else if (receiver.isModuleObject()) {
                this.evalError("cannotFindPropertyInModule", propertyName, VmUtils.getModuleInfo(receiver).getModuleName(), new MultilineValue(this.collectPropertyNames(receiver, isRead)));
            } else {
                List<Identifier> propertyNames = this.collectPropertyNames(receiver, isRead);
                this.evalError("cannotFindPropertyInObject", propertyName, receiver.getVmClass(), propertyNames.isEmpty() ? "(none)" : new MultilineValue(propertyNames));
            }
        } else if (isImplicitReceiver) {
            this.evalError("cannotFindPropertyInScopeListCandidates", propertyName, new MultilineValue(candidates));
        } else if (receiver.isModuleObject()) {
            this.evalError("cannotFindPropertyInModuleListCandidates", propertyName, VmUtils.getModuleInfo(receiver).getModuleName(), new MultilineValue(candidates));
        } else {
            this.evalError("cannotFindPropertyInObjectListCandidates", propertyName, receiver.getVmClass(), new MultilineValue(candidates));
        }
        return this;
    }

    public VmExceptionBuilder cannotFindMethod(VmObjectLike receiver, Identifier methodName, int arity, boolean isImplicitReceiver) {
        List<MemberLookupSuggestions.Candidate> candidates = new MemberLookupSuggestions(receiver, methodName, arity, EnumSet.allOf(MemberLookupSuggestions.Candidate.Kind.class)).find(isImplicitReceiver);
        if (candidates.isEmpty()) {
            if (isImplicitReceiver) {
                this.evalError("cannotFindMethodInScope", methodName);
            } else if (receiver.isModuleObject()) {
                this.evalError("cannotFindMethodInModule", methodName, VmUtils.getModuleInfo(receiver).getModuleName(), new MultilineValue(this.collectMethodNames(receiver.getVmClass())));
            } else {
                this.evalError("cannotFindMethodInClass", methodName, receiver.getVmClass(), new MultilineValue(this.collectMethodNames(receiver.getVmClass())));
            }
        } else if (isImplicitReceiver) {
            this.evalError("cannotFindMethodInScopeListCandidates", methodName, new MultilineValue(candidates));
        } else if (receiver.isModuleObject()) {
            this.evalError("cannotFindMethodInModuleListCandidates", methodName, VmUtils.getModuleInfo(receiver).getModuleName(), new MultilineValue(candidates));
        } else {
            this.evalError("cannotFindMethodInClassListCandidates", methodName, receiver.getVmClass(), new MultilineValue(candidates));
        }
        return this;
    }

    public VmExceptionBuilder cannotFindKey(VmMap map2, Object key2) {
        String string;
        List<KeyLookupSuggestions.Candidate> candidates;
        if (key2 instanceof String && !(candidates = KeyLookupSuggestions.forMap(map2, string = (String)key2)).isEmpty()) {
            return this.evalError("cannotFindKeyListCandidates", new VmException.ProgramValue("", key2), new MultilineValue(candidates));
        }
        return this.evalError("cannotFindKey", new VmException.ProgramValue("", key2));
    }

    public VmExceptionBuilder bug(String message, Object ... args2) {
        this.kind = VmException.Kind.BUG;
        return this.withMessage(message, args2);
    }

    private VmExceptionBuilder withMessage(String message, Object ... args2) {
        this.message = message;
        this.messageArguments = args2;
        this.isExternalMessage = false;
        return this;
    }

    private VmExceptionBuilder withExternalMessage(String message, Object ... args2) {
        this.message = message;
        this.messageArguments = args2;
        this.isExternalMessage = true;
        return this;
    }

    public VmExceptionBuilder evalError(String messageKey, Object ... args2) {
        return this.withExternalMessage(messageKey, args2);
    }

    public VmExceptionBuilder adhocEvalError(String message, Object ... args2) {
        return this.withMessage(message, args2);
    }

    public VmExceptionBuilder withProgramValue(String name, Object value2) {
        this.programValues.add(new VmException.ProgramValue(name, value2));
        return this;
    }

    public VmExceptionBuilder withLocation(Node location) {
        this.location = location;
        this.withSourceSection(location.getSourceSection());
        return this;
    }

    public VmExceptionBuilder withOptionalLocation(@Nullable Node location) {
        if (location != null) {
            this.withLocation(location);
        }
        return this;
    }

    public VmExceptionBuilder withSourceSection(@Nullable SourceSection sourceSection) {
        this.sourceSection = sourceSection;
        return this;
    }

    public VmExceptionBuilder withMemberName(String memberName) {
        this.memberName = memberName;
        return this;
    }

    public VmExceptionBuilder withCause(Throwable cause) {
        this.cause = cause;
        if (this.message == null) {
            String causeMessage = cause.getMessage();
            this.message = causeMessage == null ? "None (cause has no message)" : causeMessage;
        }
        return this;
    }

    public VmExceptionBuilder withHint(@Nullable String hint) {
        this.hint = hint;
        return this;
    }

    public VmException build() {
        if (this.message == null) {
            throw new IllegalStateException("No message set.");
        }
        return switch (this.kind) {
            default -> throw new IncompatibleClassChangeError();
            case VmException.Kind.EVAL_ERROR -> new VmEvalException(this.message, this.cause, this.isExternalMessage, this.messageArguments, this.programValues, this.location, this.sourceSection, this.memberName, this.hint);
            case VmException.Kind.UNDEFINED_VALUE -> new VmUndefinedValueException(this.message, this.cause, this.isExternalMessage, this.messageArguments, this.programValues, this.location, this.sourceSection, this.memberName, this.hint, this.receiver);
            case VmException.Kind.BUG -> new VmBugException(this.message, this.cause, this.isExternalMessage, this.messageArguments, this.programValues, this.location, this.sourceSection, this.memberName, this.hint);
        };
    }

    private List<Identifier> collectPropertyNames(VmObjectLike object, boolean isRead) {
        HashSet result = new HashSet();
        object.iterateMembers((key2, member) -> {
            if (member.isProp() && (isRead || !member.isExternal())) {
                result.add(member.getName());
            }
            return true;
        });
        return result.stream().sorted().collect(Collectors.toList());
    }

    private List<Identifier> collectMethodNames(VmClass clazz) {
        ArrayList<Identifier> result = new ArrayList<Identifier>();
        clazz.getMethods().forEach(method -> result.add(method.getName()));
        result.sort(Comparator.naturalOrder());
        return result;
    }

    public static class MultilineValue {
        private final Iterable<?> lines;

        private MultilineValue(Iterable<?> lines) {
            this.lines = lines;
        }

        public static Object of(Iterable<?> lines) {
            return new MultilineValue(lines);
        }

        public static Object of(Stream<?> lines) {
            return new MultilineValue(lines.collect(Collectors.toList()));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            boolean first2 = true;
            for (Object value2 : this.lines) {
                if (first2) {
                    first2 = false;
                } else {
                    builder.append("\n");
                }
                builder.append(value2);
            }
            return builder.toString();
        }
    }
}

