/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.pkl.core.BufferedLogger;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.TestModule;
import org.pkl.core.runtime.TestResults;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.stdlib.base.PcfRenderer;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.MutableBoolean;
import org.pkl.core.util.MutableReference;

public final class TestRunner {
    private static final PklConverter converter = new PklConverter(VmMapping.empty());
    private final boolean overwrite;
    private final StackFrameTransformer stackFrameTransformer;
    private final BufferedLogger logger;

    public TestRunner(BufferedLogger logger, StackFrameTransformer stackFrameTransformer2, boolean overwrite) {
        this.logger = logger;
        this.stackFrameTransformer = stackFrameTransformer2;
        this.overwrite = overwrite;
    }

    public TestResults run(VmTyped testModule) {
        ModuleInfo info = VmUtils.getModuleInfo(testModule);
        TestResults results = new TestResults(info.getModuleName(), TestRunner.getDisplayUri(info));
        try {
            this.checkAmendsPklTest(testModule);
            this.runFacts(testModule, results);
            this.runExamples(testModule, info, results);
        }
        catch (VmException v) {
            TestResults.TestResult meta = results.newResult(info.getModuleName());
            meta.addError(new TestResults.Error(v.getMessage(), v.toPklException(this.stackFrameTransformer)));
        }
        results.setErr(this.logger.getLogs());
        return results;
    }

    private void checkAmendsPklTest(VmTyped value2) {
        VmClass testModuleClass = TestModule.getModule().getVmClass();
        VmClass moduleClass = value2.getVmClass();
        while (moduleClass != testModuleClass) {
            if ((moduleClass = moduleClass.getSuperclass()) != null) continue;
            throw new VmExceptionBuilder().typeMismatch(value2, testModuleClass).build();
        }
    }

    private void runFacts(VmTyped testModule, TestResults results) {
        Object facts = VmUtils.readMember(testModule, Identifier.FACTS);
        if (facts instanceof VmNull) {
            return;
        }
        VmMapping factsMapping = (VmMapping)facts;
        factsMapping.forceAndIterateMemberValues((groupKey, groupMember, groupValue) -> {
            TestResults.TestResult result = results.newResult(String.valueOf(groupKey));
            VmListing groupListing = (VmListing)groupValue;
            groupListing.forceAndIterateMemberValues((factIndex, factMember, factValue) -> {
                assert (factValue instanceof Boolean);
                if (factValue == Boolean.FALSE) {
                    result.addFailure(TestResults.Failure.buildFactFailure(factMember.getSourceSection(), TestRunner.getDisplayUri(factMember)));
                }
                return true;
            });
            return true;
        });
    }

    private void runExamples(VmTyped testModule, ModuleInfo info, TestResults results) {
        Object examples = VmUtils.readMember(testModule, Identifier.EXAMPLES);
        if (examples instanceof VmNull) {
            return;
        }
        URI moduleUri = info.getModuleKey().getUri();
        if (!moduleUri.getScheme().equalsIgnoreCase("file")) {
            throw new VmExceptionBuilder().evalError("cannotEvaluateNonFileBasedTestModule", moduleUri).build();
        }
        VmMapping examplesMapping = (VmMapping)examples;
        Path moduleFile = Path.of(moduleUri);
        Path expectedOutputFile = moduleFile.resolveSibling(moduleFile.getFileName() + "-expected.pcf");
        Path actualOutputFile = moduleFile.resolveSibling(moduleFile.getFileName() + "-actual.pcf");
        try {
            Files.deleteIfExists(actualOutputFile);
        }
        catch (IOException e2) {
            throw new VmExceptionBuilder().evalError("ioErrorWritingTestOutputFile", actualOutputFile).withCause(e2).build();
        }
        try {
            if (this.overwrite) {
                Files.deleteIfExists(expectedOutputFile);
            }
        }
        catch (IOException e3) {
            throw new VmExceptionBuilder().evalError("ioErrorWritingTestOutputFile", expectedOutputFile).withCause(e3).build();
        }
        if (Files.exists(expectedOutputFile, new LinkOption[0])) {
            this.doRunAndValidateExamples(examplesMapping, expectedOutputFile, actualOutputFile, results);
        } else {
            this.doRunAndWriteExamples(examplesMapping, expectedOutputFile, results);
        }
    }

    private void doRunAndValidateExamples(VmMapping examples, Path expectedOutputFile, Path actualOutputFile, TestResults results) {
        VmDynamic expectedExampleOutputs = this.loadExampleOutputs(expectedOutputFile);
        MutableReference<Object> actualExampleOutputs = new MutableReference<Object>(null);
        MutableBoolean allGroupsSucceeded = new MutableBoolean(true);
        examples.forceAndIterateMemberValues((groupKey, groupMember, groupValue) -> {
            String testName = String.valueOf(groupKey);
            VmListing group = (VmListing)groupValue;
            VmDynamic expectedGroup = (VmDynamic)VmUtils.readMemberOrNull(expectedExampleOutputs, groupKey);
            if (expectedGroup == null) {
                results.newResult(testName, TestResults.Failure.buildExamplePropertyMismatchFailure(TestRunner.getDisplayUri(groupMember), String.valueOf(groupKey), true));
                return true;
            }
            if (group.getLength() != expectedGroup.getLength()) {
                results.newResult(testName, TestResults.Failure.buildExampleLengthMismatchFailure(TestRunner.getDisplayUri(groupMember), String.valueOf(groupKey), expectedGroup.getLength(), group.getLength()));
                return true;
            }
            MutableBoolean groupSucceeded = new MutableBoolean(true);
            group.forceAndIterateMemberValues((exampleIndex, exampleMember, exampleValue) -> {
                String expectedValuePcf;
                Object expectedValue = VmUtils.readMember(expectedGroup, exampleIndex);
                String exampleValuePcf = TestRunner.renderAsPcf(exampleValue);
                if (!exampleValuePcf.equals(expectedValuePcf = TestRunner.renderAsPcf(expectedValue))) {
                    ObjectMember actualMember;
                    if (actualExampleOutputs.isNull()) {
                        this.writeExampleOutputs(actualOutputFile, examples);
                        actualExampleOutputs.set(this.loadExampleOutputs(actualOutputFile));
                    }
                    groupSucceeded.set(false);
                    ObjectMember expectedMember = VmUtils.findMember(expectedGroup, exampleIndex);
                    assert (expectedMember != null);
                    VmObjectLike actualGroup = (VmObjectLike)VmUtils.readMemberOrNull((VmObjectLike)actualExampleOutputs.get(), groupKey);
                    ObjectMember objectMember = actualMember = actualGroup == null ? null : VmUtils.findMember(actualGroup, exampleIndex);
                    if (actualMember == null) {
                        throw new VmExceptionBuilder().evalError("invalidOutputFileStructure", actualOutputFile).build();
                    }
                    results.newResult(testName, TestResults.Failure.buildExampleFailure(TestRunner.getDisplayUri(exampleMember), TestRunner.getDisplayUri(expectedMember), expectedValuePcf, TestRunner.getDisplayUri(actualMember), exampleValuePcf));
                }
                return true;
            });
            if (groupSucceeded.get()) {
                results.newResult(testName);
            } else {
                allGroupsSucceeded.set(false);
            }
            return true;
        });
        expectedExampleOutputs.iterateMembers((groupKey, groupMember) -> {
            if (groupMember.isLocalOrExternalOrHidden()) {
                return true;
            }
            if (examples.getCachedValue(groupKey) == null) {
                allGroupsSucceeded.set(false);
                results.newResult(String.valueOf(groupKey), TestResults.Failure.buildExamplePropertyMismatchFailure(TestRunner.getDisplayUri(groupMember), String.valueOf(groupKey), false));
            }
            return true;
        });
        if (!allGroupsSucceeded.get() && actualExampleOutputs.isNull()) {
            this.writeExampleOutputs(actualOutputFile, examples);
        }
    }

    private void doRunAndWriteExamples(VmMapping examples, Path outputFile, TestResults results) {
        examples.forceAndIterateMemberValues((groupKey, groupMember, groupValue) -> {
            results.newResult(String.valueOf(groupKey)).setExampleWritten(true);
            return true;
        });
        this.writeExampleOutputs(outputFile, examples);
    }

    private void writeExampleOutputs(Path outputFile, VmMapping examples) {
        VmDynamic outputFileContent = new VmDynamic(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getDynamicClass().getPrototype(), EconomicMaps.of(Identifier.EXAMPLES, VmUtils.createSyntheticObjectProperty(Identifier.EXAMPLES, "examples", examples)), 0);
        StringBuilder builder = new StringBuilder();
        new PcfRenderer(builder, "  ", converter, false, true).renderDocument(outputFileContent);
        try {
            Files.writeString(outputFile, (CharSequence)builder, new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new VmExceptionBuilder().evalError("ioErrorWritingTestOutputFile", outputFile).withCause(e2).build();
        }
    }

    private VmDynamic loadExampleOutputs(Path outputFile) {
        String fileContent;
        try {
            fileContent = Files.readString(outputFile, StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            throw new VmExceptionBuilder().evalError("ioErrorReadingTestOutputFile", outputFile).withCause(e2).build();
        }
        VmTyped module = VmLanguage.get(null).loadModule(ModuleKeys.synthetic(outputFile.toUri(), fileContent));
        VmDynamic examples = (VmDynamic)VmUtils.readMemberOrNull(module, Identifier.EXAMPLES);
        if (examples == null) {
            throw new VmExceptionBuilder().evalError("invalidOutputFileStructure", outputFile).build();
        }
        return examples;
    }

    private static String renderAsPcf(Object pklValue) {
        StringBuilder builder = new StringBuilder();
        new PcfRenderer(builder, "  ", converter, false, false).renderValue(pklValue);
        if (pklValue instanceof VmObject) {
            builder.insert(0, "new ");
        }
        return builder.toString();
    }

    private static String getDisplayUri(ObjectMember member) {
        return VmUtils.getDisplayUri(member.getSourceSection(), VmContext.get(null).getFrameTransformer());
    }

    private static String getDisplayUri(ModuleInfo moduleInfo) {
        return VmUtils.getDisplayUri(moduleInfo.getModuleKey().getUri(), VmContext.get(null).getFrameTransformer());
    }
}

