/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.project;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pkl.core.Composite;
import org.pkl.core.Duration;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;
import org.pkl.core.PClassInfo;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.Value;
import org.pkl.core.Version;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.packages.PackageUtils;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.Package;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class Project {
    @Nullable
    private final Package pkg;
    private final DeclaredDependencies dependencies;
    private final PklEvaluatorSettings evaluatorSettings;
    private final URI projectFileUri;
    private final URI projectBaseUri;
    private final List<URI> tests;
    private final Map<String, Project> localProjectDependencies;

    public static Project loadFromPath(Path path2, SecurityManager securityManager2, @Nullable java.time.Duration timeout, StackFrameTransformer stackFrameTransformer2, Map<String, String> envVars) {
        try (Evaluator evaluator = EvaluatorBuilder.unconfigured().setSecurityManager(securityManager2).setStackFrameTransformer(stackFrameTransformer2).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactory(ModuleKeyFactories.file).addResourceReader(ResourceReaders.environmentVariable()).addResourceReader(ResourceReaders.file()).addEnvironmentVariables(envVars).setTimeout(timeout).build();){
            Project project2 = Project.load(evaluator, ModuleSource.path(path2));
            return project2;
        }
    }

    public static Project loadFromPath(Path path2, SecurityManager securityManager2, @Nullable java.time.Duration timeout) {
        return Project.loadFromPath(path2, securityManager2, timeout, StackFrameTransformers.defaultTransformer, System.getenv());
    }

    public static Project loadFromPath(Path path2) {
        return Project.loadFromPath(path2, SecurityManagers.defaultManager, null);
    }

    public static Project load(ModuleSource moduleSource) {
        try (Evaluator evaluator = EvaluatorBuilder.unconfigured().setSecurityManager(SecurityManagers.defaultManager).setStackFrameTransformer(StackFrameTransformers.defaultTransformer).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactory(ModuleKeyFactories.file).addModuleKeyFactory(ModuleKeyFactories.classPath(Project.class.getClassLoader())).addResourceReader(ResourceReaders.environmentVariable()).addResourceReader(ResourceReaders.file()).build();){
            Project project2 = Project.load(evaluator, moduleSource);
            return project2;
        }
    }

    public static Project load(Evaluator evaluator, ModuleSource moduleSource) {
        try {
            PObject output = evaluator.evaluateOutputValueAs(moduleSource, PClassInfo.Project);
            return Project.parseProject(output);
        }
        catch (URISyntaxException e2) {
            throw new PklException(e2.getMessage(), e2);
        }
    }

    private static DeclaredDependencies parseDependencies(PObject module, URI projectFileUri, @Nullable PackageUri packageUri) throws URISyntaxException {
        HashMap<String, Dependency.RemoteDependency> remoteDependencies = new HashMap<String, Dependency.RemoteDependency>();
        HashMap<String, DeclaredDependencies> localDependencies = new HashMap<String, DeclaredDependencies>();
        Map dependencies = (Map)module.getProperty("dependencies");
        for (Map.Entry entry : dependencies.entrySet()) {
            PObject value2 = (PObject)entry.getValue();
            if (value2.getClassInfo().equals(PClassInfo.Project)) {
                URI localProjectFileUri = URI.create((String)value2.getProperty("projectFileUri"));
                PackageUri localPkgUri = PackageUri.create((String)((PObject)value2.getProperty("package")).getProperty("uri"));
                localDependencies.put((String)entry.getKey(), Project.parseDependencies(value2, localProjectFileUri, localPkgUri));
                continue;
            }
            remoteDependencies.put((String)entry.getKey(), Project.parseRemoteDependency(value2));
        }
        return new DeclaredDependencies(remoteDependencies, localDependencies, projectFileUri, packageUri);
    }

    private static Dependency.RemoteDependency parseRemoteDependency(PObject object) throws URISyntaxException {
        PackageUri packageUri = new PackageUri((String)object.getProperty("uri"));
        PackageUtils.checkHasNoChecksumComponent(packageUri);
        Object objChecksum = object.getProperty("checksums");
        Checksums checksums = null;
        if (objChecksum instanceof PObject) {
            PObject pObject = (PObject)objChecksum;
            String sha2562 = (String)pObject.get("sha256");
            assert (sha2562 != null);
            checksums = new Checksums(sha2562);
        }
        return new Dependency.RemoteDependency(packageUri, checksums);
    }

    public static Project parseProject(PObject module) throws URISyntaxException {
        Object pkgObj = Project.getNullableProperty(module, "package");
        URI projectFileUri = URI.create((String)module.getProperty("projectFileUri"));
        DeclaredDependencies dependencies = Project.parseDependencies(module, projectFileUri, null);
        URI projectBaseUri = IoUtils.resolve(projectFileUri, ".");
        Package pkg = null;
        if (pkgObj != null) {
            pkg = Project.parsePackage((PObject)pkgObj);
        }
        PklEvaluatorSettings evaluatorSettings2 = Project.getProperty(module, "evaluatorSettings", settings2 -> PklEvaluatorSettings.parse((Value)settings2, (it, name) -> Project.resolveNullablePath(it, projectBaseUri, name)));
        List testPathStrs = (List)Project.getProperty(module, "tests");
        List<URI> tests = testPathStrs.stream().map(it -> projectBaseUri.resolve((String)it).normalize()).collect(Collectors.toList());
        Map<String, Project> localProjectDependencies = Project.parseLocalProjectDependencies(module);
        return new Project(pkg, dependencies, evaluatorSettings2, projectFileUri, projectBaseUri, tests, localProjectDependencies);
    }

    private static Map<String, Project> parseLocalProjectDependencies(PObject module) throws URISyntaxException {
        Map dependencies = (Map)module.getProperty("dependencies");
        HashMap<String, Project> result = new HashMap<String, Project>();
        for (Map.Entry entry : dependencies.entrySet()) {
            PObject value2 = (PObject)entry.getValue();
            if (!value2.getClassInfo().equals(PClassInfo.Project)) continue;
            result.put((String)entry.getKey(), Project.parseProject((PObject)entry.getValue()));
        }
        return result;
    }

    private static Object getProperty(PObject settings2, String propertyName) {
        return settings2.getProperty(propertyName);
    }

    private static <T> T getProperty(PObject settings2, String propertyName, Function<Object, T> f) {
        return Objects.requireNonNull(Project.getNullableProperty(settings2, propertyName, f));
    }

    @Nullable
    private static Object getNullableProperty(Composite object, String propertyName) {
        Object result = object.getPropertyOrNull(propertyName);
        if (result instanceof PNull || result == null) {
            return null;
        }
        return result;
    }

    @Nullable
    private static <T> T getNullableProperty(Composite object, String propertyName, Function<Object, T> f) {
        Object value2 = object.getPropertyOrNull(propertyName);
        if (value2 instanceof PNull || value2 == null) {
            return null;
        }
        return f.apply(value2);
    }

    @Nullable
    private static URI getNullableURI(Composite object, String propertyName) throws URISyntaxException {
        Object value2 = object.getPropertyOrNull(propertyName);
        if (value2 instanceof PNull || value2 == null) {
            return null;
        }
        return new URI((String)value2);
    }

    @Nullable
    private static Path resolveNullablePath(@Nullable String path2, URI projectBaseUri, String propertyName) {
        if (path2 == null) {
            return null;
        }
        try {
            return Path.of(projectBaseUri).resolve(path2).normalize();
        }
        catch (FileSystemNotFoundException e2) {
            throw new PackageLoadError("relativePathPropertyDefinedByProjectFromNonFileUri", projectBaseUri, propertyName);
        }
    }

    private static Package parsePackage(PObject pObj) throws URISyntaxException {
        String name = (String)pObj.getProperty("name");
        PackageUri uri = new PackageUri((String)pObj.getProperty("uri"));
        Version version = Version.parse((String)Project.getProperty(pObj, "version"));
        URI packageZipUrl = new URI((String)Project.getProperty(pObj, "packageZipUrl"));
        String description = (String)Project.getNullableProperty(pObj, "description");
        List authors = (List)Project.getProperty(pObj, "authors");
        URI website = Project.getNullableURI(pObj, "website");
        URI documentation = Project.getNullableURI(pObj, "documentation");
        URI sourceCode = Project.getNullableURI(pObj, "sourceCode");
        String sourceCodeUrlScheme = (String)Project.getNullableProperty(pObj, "sourceCodeUrlScheme");
        String license = (String)Project.getNullableProperty(pObj, "license");
        String licenseText = (String)Project.getNullableProperty(pObj, "licenseText");
        URI issueTracker = Project.getNullableURI(pObj, "issueTracker");
        List apiTestStrs = (List)Project.getProperty(pObj, "apiTests");
        List<Path> apiTests = apiTestStrs.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList());
        List exclude = (List)Project.getProperty(pObj, "exclude");
        return new Package(name, uri, version, packageZipUrl, description, authors, website, documentation, sourceCode, sourceCodeUrlScheme, license, licenseText, issueTracker, apiTests, exclude);
    }

    private Project(@Nullable Package pkg, DeclaredDependencies dependencies, PklEvaluatorSettings evaluatorSettings2, URI projectFileUri, URI projectBaseUri, List<URI> tests, Map<String, Project> localProjectDependencies) {
        this.pkg = pkg;
        this.dependencies = dependencies;
        this.evaluatorSettings = evaluatorSettings2;
        this.projectFileUri = projectFileUri;
        this.projectBaseUri = projectBaseUri;
        this.tests = tests;
        this.localProjectDependencies = localProjectDependencies;
    }

    @Nullable
    public Package getPackage() {
        return this.pkg;
    }

    @Deprecated(forRemoval=true)
    public EvaluatorSettings getSettings() {
        return new EvaluatorSettings(this.evaluatorSettings);
    }

    public PklEvaluatorSettings getEvaluatorSettings() {
        return this.evaluatorSettings;
    }

    public URI getProjectFileUri() {
        return this.projectFileUri;
    }

    public List<Path> getTests() {
        return this.tests.stream().map(it -> {
            try {
                return Path.of(it);
            }
            catch (FileSystemNotFoundException e2) {
                throw new PackageLoadError("invalidUsageOfProjectFromNonFileUri", new Object[0]);
            }
        }).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project2 = (Project)o;
        return Objects.equals(this.pkg, project2.pkg) && this.dependencies.equals(project2.dependencies) && this.evaluatorSettings.equals(project2.evaluatorSettings) && this.projectFileUri.equals(project2.projectFileUri) && this.tests.equals(project2.tests);
    }

    public int hashCode() {
        return Objects.hash(this.pkg, this.dependencies, this.evaluatorSettings, this.projectFileUri, this.tests);
    }

    public DeclaredDependencies getDependencies() {
        return this.dependencies;
    }

    public Map<String, Project> getLocalProjectDependencies() {
        return this.localProjectDependencies;
    }

    public URI getProjectBaseUri() {
        return this.projectBaseUri;
    }

    public Path getProjectDir() {
        assert (this.projectBaseUri.getScheme().equalsIgnoreCase("file"));
        return Path.of(this.projectBaseUri);
    }

    @Deprecated(forRemoval=true)
    public static class EvaluatorSettings {
        private final PklEvaluatorSettings delegate;

        public EvaluatorSettings(PklEvaluatorSettings delegate) {
            this.delegate = delegate;
        }

        public EvaluatorSettings(@Nullable Map<String, String> externalProperties2, @Nullable Map<String, String> env, @Nullable List<Pattern> allowedModules2, @Nullable List<Pattern> allowedResources2, @Nullable Boolean noCache, @Nullable Path moduleCacheDir2, @Nullable List<Path> modulePath2, @Nullable Duration timeout, @Nullable Path rootDir2) {
            this.delegate = new PklEvaluatorSettings(externalProperties2, env, allowedModules2, allowedResources2, noCache, moduleCacheDir2, modulePath2, timeout, rootDir2, null);
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Map<String, String> getExternalProperties() {
            return this.delegate.externalProperties();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Map<String, String> getEnv() {
            return this.delegate.env();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public List<Pattern> getAllowedModules() {
            return this.delegate.allowedModules();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public List<Pattern> getAllowedResources() {
            return this.delegate.allowedResources();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Boolean isNoCache() {
            return this.delegate.noCache();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public List<Path> getModulePath() {
            return this.delegate.modulePath();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Duration getTimeout() {
            return this.delegate.timeout();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Path getModuleCacheDir() {
            return this.delegate.moduleCacheDir();
        }

        @Deprecated(forRemoval=true)
        @Nullable
        public Path getRootDir() {
            return this.delegate.rootDir();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && Objects.equals(this.delegate, ((EvaluatorSettings)o).delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return "EvaluatorSettings{externalProperties=" + this.delegate.externalProperties() + ", env=" + this.delegate.env() + ", allowedModules=" + this.delegate.allowedModules() + ", allowedResources=" + this.delegate.allowedResources() + ", noCache=" + this.delegate.noCache() + ", moduleCacheDir=" + this.delegate.moduleCacheDir() + ", modulePath=" + this.delegate.modulePath() + ", timeout=" + this.delegate.timeout() + ", rootDir=" + this.delegate.rootDir() + "}";
        }
    }
}

