/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.lambda;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.lambda.ApplyVmFunction1NodeGen;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmFunction;

@NodeChildren(value={@NodeChild(value="functionNode"), @NodeChild(value="argumentNode")})
public abstract class ApplyVmFunction1Node
extends ExpressionNode {
    public abstract Object execute(VmFunction var1, Object var2);

    public static ApplyVmFunction1Node create() {
        return ApplyVmFunction1NodeGen.create(null, null);
    }

    public final boolean executeBoolean(VmFunction function, Object arg1) {
        Object result = this.execute(function, arg1);
        if (result instanceof Boolean) {
            Boolean b2 = (Boolean)result;
            return b2;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getBooleanClass()).build();
    }

    public final String executeString(VmFunction function, Object arg1) {
        Object result = this.execute(function, arg1);
        if (result instanceof String) {
            String string = (String)result;
            return string;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getStringClass()).build();
    }

    public final Long executeInt(VmFunction function, Object arg1) {
        Object result = this.execute(function, arg1);
        if (result instanceof Long) {
            Long l = (Long)result;
            return l;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getIntClass()).build();
    }

    public final VmCollection executeCollection(VmFunction function, Object arg1) {
        Object result = this.execute(function, arg1);
        if (result instanceof VmCollection) {
            VmCollection collection = (VmCollection)result;
            return collection;
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(result, BaseModule.getCollectionClass()).build();
    }

    @Specialization(guards={"function.getCallTarget() == cachedCallTarget"})
    protected Object evalDirect(VmFunction function, Object arg1, @Cached(value="function.getCallTarget()") RootCallTarget cachedCallTarget, @Cached(value="create(cachedCallTarget)") DirectCallNode callNode) {
        return callNode.call(function.getThisValue(), function, arg1);
    }

    @Specialization(replaces={"evalDirect"})
    protected Object eval(VmFunction function, Object arg1, @Cached(value="create()") IndirectCallNode callNode) {
        return callNode.call(function.getCallTarget(), function.getThisValue(), function, arg1);
    }
}

