/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;

public final class ReadLocalPropertyNode
extends ExpressionNode {
    private final ObjectMember property;
    private final int levelsUp;
    @Node.Child
    private DirectCallNode callNode;

    public ReadLocalPropertyNode(SourceSection sourceSection, ObjectMember property, int levelsUp) {
        super(sourceSection);
        CompilerAsserts.neverPartOfCompilation();
        this.property = property;
        this.levelsUp = levelsUp;
        assert (property.getNameOrNull() != null);
        assert (property.getConstantValue() == null) : "Use a ConstantNode instead.";
        this.callNode = DirectCallNode.create(property.getCallTarget());
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object receiver;
        VmObjectLike owner = VmUtils.getOwner(frame);
        if (this.levelsUp == 0) {
            receiver = VmUtils.getReceiver(frame);
        } else {
            for (int i = 1; i < this.levelsUp; ++i) {
                owner = owner.getEnclosingOwner();
                assert (owner != null);
            }
            receiver = owner.getEnclosingReceiver();
            owner = owner.getEnclosingOwner();
        }
        assert (receiver instanceof VmObjectLike) : "Assumption: This node isn't used in Truffle ASTs of `external` pkl.base classes whose values aren't VmObject's.";
        VmObjectLike objReceiver = (VmObjectLike)receiver;
        Object result = objReceiver.getCachedValue(this.property);
        if (result == null) {
            result = this.callNode.call(objReceiver, owner, this.property.getName());
            objReceiver.setCachedValue(this.property, result);
        }
        return result;
    }
}

