/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.AmendFunctionNode;
import org.pkl.core.ast.expression.literal.EntriesLiteralNodeGen;
import org.pkl.core.ast.expression.literal.SpecializedObjectLiteralNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;

@ImportStatic(value={BaseModule.class})
public abstract class EntriesLiteralNode
extends SpecializedObjectLiteralNode {
    @Node.Children
    private final ExpressionNode[] keyNodes;
    private final ObjectMember[] values;

    public EntriesLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes, UnmodifiableEconomicMap<Object, ObjectMember> members, ExpressionNode[] keyNodes, ObjectMember[] values2) {
        super(sourceSection, language, qualifiedScopeName, isCustomThisScope, parametersDescriptor, parameterTypes, members);
        this.keyNodes = keyNodes;
        this.values = values2;
        assert (keyNodes.length > 0);
        assert (keyNodes.length == values2.length);
    }

    @Override
    public EntriesLiteralNode copy(ExpressionNode newParentNode) {
        return EntriesLiteralNodeGen.create(this.sourceSection, this.language, this.qualifiedScopeName, this.isCustomThisScope, null, new UnresolvedTypeNode[0], this.members, this.keyNodes, this.values, newParentNode);
    }

    @Specialization(guards={"checkIsValidMappingAmendment()"})
    protected VmMapping evalMapping(VirtualFrame frame, VmMapping parent) {
        return new VmMapping(frame.materialize(), parent, this.createMapMembers(frame));
    }

    @Specialization
    protected VmDynamic evalDynamic(VirtualFrame frame, VmDynamic parent) {
        return new VmDynamic(frame.materialize(), (VmObject)parent, this.createMapMembers(frame), parent.getLength());
    }

    @Specialization(guards={"checkIsValidListingAmendment()"})
    protected VmListing evalListing(VirtualFrame frame, VmListing parent) {
        return new VmListing(frame.materialize(), (VmObject)parent, this.createListMembers(frame, parent.getLength()), parent.getLength() + this.keyNodes.length);
    }

    @Specialization
    protected Object evalNull(VirtualFrame frame, VmNull parent) {
        return this.executeWithParent(frame, parent.getDefaultValue());
    }

    @Specialization(guards={"checkIsValidFunctionAmendment(parent)"})
    protected VmFunction evalFunction(VirtualFrame frame, VmFunction parent, @Cached(value="createAmendFunctionNode(frame)", neverDefault=true) AmendFunctionNode amendFunctionNode) {
        return amendFunctionNode.execute(frame, parent);
    }

    @Specialization(guards={"parent == getMappingClass()", "checkIsValidMappingAmendment()"})
    protected VmMapping evalMappingClass(VirtualFrame frame, VmClass parent) {
        return new VmMapping(frame.materialize(), BaseModule.getMappingClass().getPrototype(), this.createMapMembers(frame));
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected VmDynamic evalDynamicClass(VirtualFrame frame, VmClass parent) {
        return new VmDynamic(frame.materialize(), (VmObject)BaseModule.getDynamicClass().getPrototype(), this.createMapMembers(frame), 0);
    }

    @Specialization(guards={"parent == getListingClass()", "checkIsValidListingAmendment()"})
    protected void evalListingClass(VmClass parent) {
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("cannotAddElementWithEntrySyntax", new Object[0]).withSourceSection(this.keyNodes[0].getSourceSection()).build();
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    protected void fallback(Object parent) {
        this.elementsEntriesFallback(parent, this.values[0], false);
    }

    @ExplodeLoop
    protected EconomicMap<Object, ObjectMember> createMapMembers(VirtualFrame frame) {
        EconomicMap<Object, ObjectMember> result = EconomicMaps.create(EconomicMaps.size(this.members) + this.keyNodes.length);
        EconomicMaps.putAll(result, this.members);
        for (int i = 0; i < this.keyNodes.length; ++i) {
            ObjectMember value2;
            Object key2 = this.keyNodes[i].executeGeneric(frame);
            ObjectMember previousValue = EconomicMaps.put(result, key2, value2 = this.values[i]);
            if (previousValue == null) continue;
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("duplicateDefinition", new VmException.ProgramValue("", key2)).withSourceSection(value2.getHeaderSection()).build();
        }
        return result;
    }

    protected UnmodifiableEconomicMap<Object, ObjectMember> createListMembers(VirtualFrame frame, int parentLength) {
        EconomicMap<Object, ObjectMember> result = EconomicMaps.create(EconomicMaps.size(this.members) + this.keyNodes.length);
        EconomicMaps.putAll(result, this.members);
        this.addListEntries(frame, parentLength, result, this.keyNodes, this.values);
        return result;
    }
}

