/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.literal.AmendFunctionNode;
import org.pkl.core.ast.expression.literal.ElementsLiteralNodeGen;
import org.pkl.core.ast.expression.literal.SpecializedObjectLiteralNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;

@ImportStatic(value={BaseModule.class})
public abstract class ElementsLiteralNode
extends SpecializedObjectLiteralNode {
    private final ObjectMember[] elements;

    public ElementsLiteralNode(SourceSection sourceSection, VmLanguage language, String qualifiedScopeName, boolean isCustomThisScope, @Nullable FrameDescriptor parametersDescriptor, UnresolvedTypeNode[] parameterTypes, UnmodifiableEconomicMap<Object, ObjectMember> properties, ObjectMember[] elements) {
        super(sourceSection, language, qualifiedScopeName, isCustomThisScope, parametersDescriptor, parameterTypes, properties);
        this.elements = elements;
        assert (elements.length > 0);
    }

    @Override
    protected ElementsLiteralNode copy(ExpressionNode newParentNode) {
        return ElementsLiteralNodeGen.create(this.sourceSection, this.language, this.qualifiedScopeName, this.isCustomThisScope, null, new UnresolvedTypeNode[0], this.members, this.elements, newParentNode);
    }

    @Specialization(guards={"parent.getLength() == parentLength"})
    protected VmDynamic evalDynamicCached(VirtualFrame frame, VmDynamic parent, @Cached(value="parent.getLength()") int parentLength, @Cached(value="createMembers(parentLength)") UnmodifiableEconomicMap<Object, ObjectMember> members) {
        return new VmDynamic(frame.materialize(), (VmObject)parent, members, parentLength + this.elements.length);
    }

    @Specialization
    protected VmDynamic evalDynamicUncached(VirtualFrame frame, VmDynamic parent) {
        return new VmDynamic(frame.materialize(), (VmObject)parent, this.createMembers(parent.getLength()), parent.getLength() + this.elements.length);
    }

    @Specialization
    protected Object evalNull(VirtualFrame frame, VmNull parent) {
        return this.executeWithParent(frame, parent.getDefaultValue());
    }

    @Specialization(guards={"checkIsValidFunctionAmendment(parent)"})
    protected VmFunction evalFunction(VirtualFrame frame, VmFunction parent, @Cached(value="createAmendFunctionNode(frame)", neverDefault=true) AmendFunctionNode amendFunctionNode) {
        return amendFunctionNode.execute(frame, parent);
    }

    @Specialization(guards={"parent == getListingClass()", "checkIsValidListingAmendment()", "checkMaxListingMemberIndex(0)"})
    protected VmListing evalListingClass(VirtualFrame frame, VmClass parent, @Cached(value="createMembers(0)", neverDefault=true) UnmodifiableEconomicMap<Object, ObjectMember> members) {
        return new VmListing(frame.materialize(), (VmObject)BaseModule.getListingClass().getPrototype(), members, this.elements.length);
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected VmDynamic evalDynamicClass(VirtualFrame frame, VmClass parent, @Cached(value="createMembers(0)", neverDefault=true) UnmodifiableEconomicMap<Object, ObjectMember> members) {
        return new VmDynamic(frame.materialize(), (VmObject)BaseModule.getDynamicClass().getPrototype(), members, this.elements.length);
    }

    @Specialization(guards={"checkIsValidListingAmendment()", "parent.getLength() == parentLength", "checkMaxListingMemberIndex(parentLength)"})
    protected VmListing evalListingCached(VirtualFrame frame, VmListing parent, @Cached(value="parent.getLength()") int parentLength, @Cached(value="createMembers(parentLength)") UnmodifiableEconomicMap<Object, ObjectMember> properties) {
        return new VmListing(frame.materialize(), (VmObject)parent, properties, parentLength + this.elements.length);
    }

    @Specialization(guards={"checkIsValidListingAmendment()"})
    protected VmListing evalListingUncached(VirtualFrame frame, VmListing parent) {
        this.checkMaxListingMemberIndex(parent.getLength());
        return new VmListing(frame.materialize(), (VmObject)parent, this.createMembers(parent.getLength()), parent.getLength() + this.elements.length);
    }

    @CompilerDirectives.TruffleBoundary
    @Fallback
    protected void fallback(Object parent) {
        this.elementsEntriesFallback(parent, this.elements[0], true);
    }

    protected UnmodifiableEconomicMap<Object, ObjectMember> createMembers(int parentLength) {
        EconomicMap<Object, ObjectMember> result = EconomicMaps.create(EconomicMaps.size(this.members) + this.elements.length);
        EconomicMaps.putAll(result, this.members);
        for (int i = 0; i < this.elements.length; ++i) {
            EconomicMaps.put(result, Long.valueOf(parentLength + i), this.elements[i]);
        }
        return result;
    }
}

