/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.builder.SymbolTable;
import org.pkl.core.ast.member.FunctionNode;
import org.pkl.core.ast.member.UnresolvedFunctionNode;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.LateInit;

public final class LetExprNode
extends ExpressionNode {
    @Node.Child
    private UnresolvedFunctionNode unresolvedFunctionNode;
    @Node.Child
    private ExpressionNode valueNode;
    private final boolean isCustomThisScope;
    @CompilerDirectives.CompilationFinal
    @LateInit
    private FunctionNode functionNode;
    @Node.Child
    @LateInit
    private DirectCallNode callNode;
    @CompilerDirectives.CompilationFinal
    private int customThisSlot = -1;

    public LetExprNode(SourceSection sourceSection, UnresolvedFunctionNode functionNode, ExpressionNode valueNode, boolean isCustomThisScope) {
        super(sourceSection);
        this.unresolvedFunctionNode = functionNode;
        this.valueNode = valueNode;
        this.isCustomThisScope = isCustomThisScope;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        if (this.functionNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.functionNode = this.unresolvedFunctionNode.execute(frame);
            this.callNode = this.insert(DirectCallNode.create(this.functionNode.getCallTarget()));
            if (this.isCustomThisScope) {
                this.customThisSlot = VmUtils.findAuxiliarySlot(frame, SymbolTable.CustomThisScope.FRAME_SLOT_ID);
            }
        }
        VmFunction function = new VmFunction(frame.materialize(), this.isCustomThisScope ? frame.getAuxiliarySlot(this.customThisSlot) : VmUtils.getReceiver(frame), 1, this.functionNode, null);
        Object value2 = this.valueNode.executeGeneric(frame);
        return this.callNode.call(function.getThisValue(), function, value2);
    }
}

