/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.TruffleStackTraceElement;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.polyglot.Context;
import org.pkl.core.BufferedLogger;
import org.pkl.core.Evaluator;
import org.pkl.core.FileOutput;
import org.pkl.core.FileOutputImpl;
import org.pkl.core.Logger;
import org.pkl.core.ModuleSchema;
import org.pkl.core.ModuleSource;
import org.pkl.core.PClassInfo;
import org.pkl.core.PModule;
import org.pkl.core.PklBugException;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.ast.ConstantValueNode;
import org.pkl.core.ast.internal.ToStringNode;
import org.pkl.core.ast.internal.ToStringNodeGen;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.ResourceManager;
import org.pkl.core.runtime.TestResults;
import org.pkl.core.runtime.TestRunner;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmStackOverflowException;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueRenderer;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;

public class EvaluatorImpl
implements Evaluator {
    protected final StackFrameTransformer frameTransformer;
    protected final ModuleResolver moduleResolver;
    protected final Context polyglotContext;
    @Nullable
    protected final Duration timeout;
    @Nullable
    protected final ScheduledExecutorService timeoutExecutor;
    protected final SecurityManager securityManager;
    protected final BufferedLogger logger;
    protected final PackageResolver packageResolver;
    private final VmValueRenderer vmValueRenderer = VmValueRenderer.singleLine(1000);

    public EvaluatorImpl(StackFrameTransformer transformer, SecurityManager manager, HttpClient httpClient2, Logger logger, Collection<ModuleKeyFactory> factories, Collection<ResourceReader> readers, Map<String, String> environmentVariables2, Map<String, String> externalProperties2, @Nullable Duration timeout, @Nullable Path moduleCacheDir2, @Nullable DeclaredDependencies projectDependencies, @Nullable String outputFormat) {
        this.securityManager = manager;
        this.frameTransformer = transformer;
        this.moduleResolver = new ModuleResolver(factories);
        this.logger = new BufferedLogger(logger);
        this.packageResolver = PackageResolver.getInstance(this.securityManager, httpClient2, moduleCacheDir2);
        this.polyglotContext = VmUtils.createContext(() -> {
            VmContext vmContext = VmContext.get(null);
            vmContext.initialize(new VmContext.Holder(transformer, manager, httpClient2, this.moduleResolver, new ResourceManager(manager, readers), this.logger, environmentVariables2, externalProperties2, moduleCacheDir2, outputFormat, this.packageResolver, projectDependencies == null ? null : new ProjectDependenciesManager(projectDependencies, this.moduleResolver, this.securityManager)));
        });
        this.timeout = timeout;
        this.timeoutExecutor = timeout == null ? null : Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread t = new Thread(runnable, "Pkl Timeout Scheduler");
            t.setDaemon(true);
            return t;
        });
    }

    @Override
    public PModule evaluate(ModuleSource moduleSource) {
        return this.doEvaluate(moduleSource, module -> {
            module.force(false);
            return (PModule)module.export();
        });
    }

    @Override
    public String evaluateOutputText(ModuleSource moduleSource) {
        return this.doEvaluate(moduleSource, module -> {
            VmTyped output = (VmTyped)VmUtils.readMember(module, Identifier.OUTPUT);
            return VmUtils.readTextProperty(output);
        });
    }

    @Override
    public Object evaluateOutputValue(ModuleSource moduleSource) {
        return this.doEvaluate(moduleSource, module -> {
            VmTyped output = (VmTyped)VmUtils.readMember(module, Identifier.OUTPUT);
            Object value2 = VmUtils.readMember(output, Identifier.VALUE);
            if (value2 instanceof VmValue) {
                VmValue vmValue = (VmValue)value2;
                vmValue.force(false);
                return vmValue.export();
            }
            return value2;
        });
    }

    @Override
    public Map<String, FileOutput> evaluateOutputFiles(ModuleSource moduleSource) {
        return this.doEvaluate(moduleSource, module -> {
            VmTyped output = (VmTyped)VmUtils.readMember(module, Identifier.OUTPUT);
            Object filesOrNull = VmUtils.readMember(output, Identifier.FILES);
            if (filesOrNull instanceof VmNull) {
                return Map.of();
            }
            VmMapping files = (VmMapping)filesOrNull;
            LinkedHashMap result = new LinkedHashMap();
            files.forceAndIterateMemberValues((key2, member, value2) -> {
                assert (member.isEntry());
                result.put((String)key2, new FileOutputImpl(this, (VmTyped)value2));
                return true;
            });
            return result;
        });
    }

    @Override
    public Object evaluateExpression(ModuleSource moduleSource, String expression) {
        if (expression.equals("output.text")) {
            return this.evaluateOutputText(moduleSource);
        }
        if (expression.equals("output.value")) {
            return this.evaluateOutputValue(moduleSource);
        }
        return this.doEvaluate(moduleSource, module -> {
            Object expressionResult = VmUtils.evaluateExpression(module, expression, this.securityManager, this.moduleResolver);
            if (expressionResult instanceof VmValue) {
                VmValue value2 = (VmValue)expressionResult;
                value2.force(false);
                return value2.export();
            }
            return expressionResult;
        });
    }

    @Override
    public String evaluateExpressionString(ModuleSource moduleSource, String expression) {
        if (expression.equals("output.text")) {
            return this.evaluateOutputText(moduleSource);
        }
        return this.doEvaluate(moduleSource, module -> {
            Object expressionResult = VmUtils.evaluateExpression(module, expression, this.securityManager, this.moduleResolver);
            ToStringNode toStringNode = ToStringNodeGen.create(VmUtils.unavailableSourceSection(), new ConstantValueNode(expressionResult));
            Object stringified = toStringNode.executeGeneric(VmUtils.createEmptyMaterializedFrame());
            return (String)stringified;
        });
    }

    @Override
    public ModuleSchema evaluateSchema(ModuleSource moduleSource) {
        return this.doEvaluate(moduleSource, module -> module.getModuleInfo().getModuleSchema((VmTyped)module));
    }

    @Override
    public TestResults evaluateTest(ModuleSource moduleSource, boolean overwrite) {
        return this.doEvaluate(moduleSource, module -> {
            TestRunner testRunner = new TestRunner(this.logger, this.frameTransformer, overwrite);
            return testRunner.run((VmTyped)module);
        });
    }

    @Override
    public <T> T evaluateOutputValueAs(ModuleSource moduleSource, PClassInfo<T> classInfo) {
        return (T)this.doEvaluate(moduleSource, module -> {
            VmTyped output = (VmTyped)VmUtils.readMember(module, Identifier.OUTPUT);
            Object value2 = VmUtils.readMember(output, Identifier.VALUE);
            PClassInfo<?> valueClassInfo = VmUtils.getClass(value2).getPClassInfo();
            if (valueClassInfo.equals(classInfo)) {
                if (value2 instanceof VmValue) {
                    VmValue vmValue = (VmValue)value2;
                    vmValue.force(false);
                    return vmValue.export();
                }
                return value2;
            }
            throw this.moduleOutputValueTypeMismatch((VmTyped)module, classInfo, value2, output);
        });
    }

    @Override
    public void close() {
        this.polyglotContext.close(true);
        try {
            this.packageResolver.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.timeoutExecutor != null) {
            this.timeoutExecutor.shutdown();
        }
    }

    String evaluateOutputText(VmTyped fileOutput) {
        return this.doEvaluate(() -> VmUtils.readTextProperty(fileOutput));
    }

    private <T> T doEvaluate(Supplier<T> supplier) {
        T evalResult;
        @Nullable TimeoutTask timeoutTask = null;
        this.logger.clear();
        if (this.timeout != null) {
            assert (this.timeoutExecutor != null);
            timeoutTask = new TimeoutTask();
            this.timeoutExecutor.schedule(timeoutTask, this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        this.polyglotContext.enter();
        try {
            evalResult = supplier.get();
        }
        catch (VmStackOverflowException e2) {
            if (this.isPklBug(e2)) {
                throw new VmExceptionBuilder().bug("Stack overflow", new Object[0]).withCause(e2.getCause()).build().toPklException(this.frameTransformer);
            }
            this.handleTimeout(timeoutTask);
            throw e2.toPklException(this.frameTransformer);
        }
        catch (VmException e3) {
            this.handleTimeout(timeoutTask);
            throw e3.toPklException(this.frameTransformer);
        }
        catch (Exception e4) {
            throw new PklBugException(e4);
        }
        catch (ExceptionInInitializerError e5) {
            Throwable throwable = e5.getCause();
            if (!(throwable instanceof VmException)) {
                throw new PklBugException(e5);
            }
            VmException vmException = (VmException)throwable;
            PklException pklException = vmException.toPklException(this.frameTransformer);
            ExceptionInInitializerError error = new ExceptionInInitializerError(pklException);
            error.setStackTrace(e5.getStackTrace());
            throw new PklBugException(error);
        }
        catch (ThreadDeath e6) {
            if (e6.getClass().getName().equals("com.oracle.truffle.polyglot.PolyglotEngineImpl$CancelExecution")) {
                this.handleTimeout(timeoutTask);
                throw PklBugException.unreachableCode();
            }
            throw e6;
        }
        finally {
            try {
                this.polyglotContext.leave();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.handleTimeout(timeoutTask);
        return evalResult;
    }

    protected <T> T doEvaluate(ModuleSource moduleSource, Function<VmTyped, T> doEvaluate) {
        return (T)this.doEvaluate(() -> {
            ModuleKey moduleKey = this.moduleResolver.resolve(moduleSource);
            VmTyped module = VmLanguage.get(null).loadModule(moduleKey);
            return doEvaluate.apply(module);
        });
    }

    private void handleTimeout(@Nullable TimeoutTask timeoutTask) {
        if (timeoutTask == null || timeoutTask.cancel()) {
            return;
        }
        assert (this.timeout != null);
        throw new PklException(ErrorMessages.create("evaluationTimedOut", (double)this.timeout.getSeconds() + (double)this.timeout.getNano() / 1.0E9));
    }

    private VmException moduleOutputValueTypeMismatch(VmTyped module, PClassInfo<?> expectedClassInfo, Object value2, VmTyped output) {
        URI moduleUri = module.getModuleInfo().getModuleKey().getUri();
        VmExceptionBuilder builder = new VmExceptionBuilder().evalError("invalidModuleOutputValue", expectedClassInfo.getDisplayName(), VmUtils.getClass(value2).getPClassInfo().getDisplayName(), moduleUri);
        ObjectMember outputValueMember = output.getMember(Identifier.VALUE);
        assert (outputValueMember != null);
        URI uriOfValueMember = outputValueMember.getSourceSection().getSource().getURI();
        if (!uriOfValueMember.equals(PClassInfo.pklBaseUri)) {
            return builder.withSourceSection(outputValueMember.getBodySection()).withMemberName("value").build();
        }
        if (module.getParent() != null && module.getParent().getVmClass().equals(BaseModule.getModuleClass()) && expectedClassInfo.isModuleClass()) {
            builder.withHint(String.format("Try adding `amends %s` to the module header.", this.vmValueRenderer.render(expectedClassInfo.getModuleUri().toString())));
        }
        return builder.withSourceSection(module.getModuleInfo().getHeaderSection()).withMemberName(module.getModuleInfo().getModuleName()).build();
    }

    private boolean isPklBug(VmStackOverflowException e2) {
        List<TruffleStackTraceElement> truffleStackTraceElements = TruffleStackTrace.getStackTrace(e2);
        return truffleStackTraceElements != null && truffleStackTraceElements.size() < 100;
    }

    private final class TimeoutTask
    implements Runnable {
        private boolean started = false;
        private boolean cancelled = false;

        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimeoutTask timeoutTask = this;
            synchronized (timeoutTask) {
                if (this.cancelled) {
                    return;
                }
                this.started = true;
            }
            EvaluatorImpl.this.close();
        }

        public synchronized boolean cancel() {
            if (this.started) {
                return false;
            }
            this.cancelled = true;
            return true;
        }
    }
}

