/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;

final class FinalIntMap {
    @CompilerDirectives.CompilationFinal
    Entry first;

    FinalIntMap() {
    }

    @ExplodeLoop
    int get(Object key2) {
        Entry current2 = this.first;
        while (current2 != null) {
            if (current2.key == key2) {
                return current2.value;
            }
            current2 = current2.next;
        }
        return -1;
    }

    void put(Object key2, int value2) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.get(key2) == -1) : "replace not supported by this map implementation";
        assert (value2 >= 0) : "only positive integers supported";
        Entry prev = null;
        Entry current2 = this.first;
        while (current2 != null) {
            prev = current2;
            current2 = current2.next;
        }
        Entry entry = new Entry(key2, value2);
        if (prev == null) {
            assert (current2 == this.first);
            this.first = entry;
        } else {
            prev.next = entry;
        }
    }

    static final class Entry {
        final Object key;
        final int value;
        @CompilerDirectives.CompilationFinal
        Entry next;

        Entry(Object key2, int value2) {
            this.key = key2;
            this.value = value2;
        }
    }
}

