/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TruffleString;

final class TSCodeRange {
    private static final int FLAG_MULTIBYTE = 8;
    private static final int FLAG_IMPRECISE = 16;
    private static final int MASK_ORDINAL = 7;
    private static final int MASK_ORDINAL_MULTIBYTE = 15;
    private static final int CR_7BIT = 0;
    private static final int CR_8BIT = 1;
    private static final int CR_16BIT = 2;
    private static final int CR_VALID = 3;
    private static final int CR_BROKEN = 4;
    private static final int CR_VALID_MULTIBYTE = 11;
    private static final int CR_BROKEN_MULTIBYTE = 12;

    TSCodeRange() {
    }

    static int ordinal(int codeRange) {
        return codeRange & 7;
    }

    static int ordinalAndMultibyteFlag(int codeRange) {
        return codeRange & 0xF;
    }

    private static int maxCodePoint(int codeRange) {
        int ordinal = TSCodeRange.ordinal(codeRange);
        return ordinal == 0 ? 127 : (ordinal == 1 ? 255 : (ordinal == 2 ? 65535 : 0x10FFFF));
    }

    static boolean isCodeRange(int codeRange) {
        return 0 <= TSCodeRange.ordinal(codeRange) && TSCodeRange.ordinal(codeRange) <= 4 && codeRange >>> 6 == 0;
    }

    static int markImprecise(int codeRange) {
        return codeRange | 0x10;
    }

    static boolean isFixedWidth(int codeRange) {
        return (codeRange & 8) == 0;
    }

    static boolean isFixedWidth(int codeRangeA, int codeRangeB) {
        return ((codeRangeA | codeRangeB) & 8) == 0;
    }

    static boolean isPrecise(int codeRange) {
        return (codeRange & 0x10) == 0;
    }

    static boolean isPrecise(int codeRangeA, int codeRangeB) {
        return ((codeRangeA | codeRangeB) & 0x10) == 0;
    }

    static int get7Bit() {
        return 0;
    }

    static int get8Bit() {
        return 1;
    }

    static int get16Bit() {
        return 2;
    }

    static int getValid(boolean fixedWidth) {
        return fixedWidth ? TSCodeRange.getValidFixedWidth() : TSCodeRange.getValidMultiByte();
    }

    static int getBroken(boolean fixedWidth) {
        return fixedWidth ? TSCodeRange.getBrokenFixedWidth() : TSCodeRange.getBrokenMultiByte();
    }

    static int getValidFixedWidth() {
        return 3;
    }

    static int getBrokenFixedWidth() {
        return 4;
    }

    static int getValidMultiByte() {
        return 11;
    }

    static int getBrokenMultiByte() {
        return 12;
    }

    static boolean is7Bit(int codeRange) {
        return TSCodeRange.ordinal(codeRange) == 0;
    }

    static boolean is7Or8Bit(int codeRange) {
        return TSCodeRange.ordinal(codeRange) <= 1;
    }

    static boolean isUpTo16Bit(int codeRange) {
        return TSCodeRange.ordinal(codeRange) <= 2;
    }

    static boolean is8Bit(int codeRange) {
        return TSCodeRange.ordinal(codeRange) == 1;
    }

    static boolean is16Bit(int codeRange) {
        return TSCodeRange.ordinal(codeRange) == 2;
    }

    static boolean isValid(int codeRange) {
        return TSCodeRange.ordinal(codeRange) == 3;
    }

    static boolean isBroken(int codeRange) {
        return TSCodeRange.ordinal(codeRange) == 4;
    }

    static boolean isValidFixedWidth(int codeRange) {
        return TSCodeRange.ordinalAndMultibyteFlag(codeRange) == TSCodeRange.getValidFixedWidth();
    }

    static boolean isBrokenFixedWidth(int codeRange) {
        return TSCodeRange.ordinalAndMultibyteFlag(codeRange) == TSCodeRange.getBrokenFixedWidth();
    }

    static boolean isValidMultiByte(int codeRange) {
        return TSCodeRange.ordinalAndMultibyteFlag(codeRange) == TSCodeRange.getValidMultiByte();
    }

    static boolean isBrokenMultiByte(int codeRange) {
        return TSCodeRange.ordinalAndMultibyteFlag(codeRange) == TSCodeRange.getBrokenMultiByte();
    }

    static boolean isValidOrBrokenMultiByte(int codeRange) {
        return TSCodeRange.isValidMultiByte(codeRange) || TSCodeRange.isBrokenMultiByte(codeRange);
    }

    static int commonCodeRange(int a, int b2) {
        return TSCodeRange.isMoreGeneralThan(a, b2) ? a : b2;
    }

    static boolean isMoreRestrictiveThan(int a, int b2) {
        return TSCodeRange.ordinal(a) < TSCodeRange.ordinal(b2);
    }

    static boolean isMoreRestrictiveOrEqual(int a, int b2) {
        return TSCodeRange.ordinal(a) <= TSCodeRange.ordinal(b2);
    }

    static boolean isMoreGeneralThan(int a, int b2) {
        return TSCodeRange.ordinal(a) > TSCodeRange.ordinal(b2);
    }

    static boolean isUpToValidFixedWidth(int codeRange) {
        return TSCodeRange.ordinal(codeRange) <= 3 && TSCodeRange.isFixedWidth(codeRange);
    }

    static boolean isInCodeRange(int codepoint, int codeRange) {
        return Integer.toUnsignedLong(codepoint) <= (long)TSCodeRange.maxCodePoint(codeRange);
    }

    static int toStrideUTF16(int codeRange) {
        assert (TSCodeRange.is7Or8Bit(codeRange) || TSCodeRange.isPrecise(codeRange));
        return TSCodeRange.toStrideUTF16AllowImprecise(codeRange);
    }

    static int toStrideUTF16AllowImprecise(int codeRange) {
        return TSCodeRange.is7Or8Bit(codeRange) ? 0 : 1;
    }

    static int toStrideUTF32(int codeRange) {
        assert (TSCodeRange.is7Or8Bit(codeRange) || TSCodeRange.isPrecise(codeRange));
        return TSCodeRange.toStrideUTF32AllowImprecise(codeRange);
    }

    static int toStrideUTF32AllowImprecise(int codeRange) {
        assert (TSCodeRange.isFixedWidth(codeRange));
        int ordinal = TSCodeRange.ordinal(codeRange);
        if (ordinal > 2) {
            return 2;
        }
        if (ordinal == 2) {
            return 1;
        }
        return 0;
    }

    static int asciiLatinBytesNonAsciiCodeRange(int encoding) {
        if (TStringGuards.isAscii(encoding)) {
            return TSCodeRange.getBrokenFixedWidth();
        }
        if (TStringGuards.isLatin1(encoding)) {
            return TSCodeRange.get8Bit();
        }
        assert (TStringGuards.isBytes(encoding));
        return TSCodeRange.getValidFixedWidth();
    }

    static int asciiLatinBytesNonAsciiCodeRange(TruffleString.Encoding encoding) {
        if (TStringGuards.isAscii(encoding)) {
            return TSCodeRange.getBrokenFixedWidth();
        }
        if (TStringGuards.isLatin1(encoding)) {
            return TSCodeRange.get8Bit();
        }
        if (TStringGuards.isBytes(encoding)) {
            return TSCodeRange.getValidFixedWidth();
        }
        return TSCodeRange.getUnknownCodeRangeForEncoding(encoding.id);
    }

    static int getAsciiCodeRange(TruffleString.Encoding encoding) {
        if (TStringGuards.is7BitCompatible(encoding)) {
            return TSCodeRange.get7Bit();
        }
        if (JCodings.getInstance().isSingleByte(encoding.jCoding)) {
            return TSCodeRange.getValidFixedWidth();
        }
        return TSCodeRange.getValidMultiByte();
    }

    static byte getUnknownCodeRangeForEncoding(int encoding) {
        if (TStringGuards.isLatin1(encoding)) {
            return (byte)TSCodeRange.markImprecise(TSCodeRange.get8Bit());
        }
        if (TStringGuards.isBytes(encoding)) {
            return (byte)TSCodeRange.markImprecise(TSCodeRange.getValidFixedWidth());
        }
        return (byte)TSCodeRange.markImprecise(TSCodeRange.getBroken(TruffleString.Encoding.isFixedWidth(encoding)));
    }

    private static void staticAssertions() {
        assert (TSCodeRange.toStrideUTF32(0) == 0);
        assert (TSCodeRange.toStrideUTF32(TSCodeRange.get7Bit()) == 0);
        assert (TSCodeRange.toStrideUTF32(1) == 0);
        assert (TSCodeRange.toStrideUTF32(TSCodeRange.get8Bit()) == 0);
        assert (TSCodeRange.toStrideUTF32(2) == 1);
        assert (TSCodeRange.toStrideUTF32(TSCodeRange.get16Bit()) == 1);
        assert (TSCodeRange.toStrideUTF32(3) == 2);
        assert (TSCodeRange.toStrideUTF32(4) == 2);
        assert (TSCodeRange.maxCodePoint(0) == 127);
        assert (TSCodeRange.maxCodePoint(TSCodeRange.get7Bit()) == 127);
        assert (TSCodeRange.maxCodePoint(1) == 255);
        assert (TSCodeRange.maxCodePoint(TSCodeRange.get8Bit()) == 255);
        assert (TSCodeRange.maxCodePoint(2) == 65535);
        assert (TSCodeRange.maxCodePoint(TSCodeRange.get16Bit()) == 65535);
        assert (TSCodeRange.maxCodePoint(3) == 0x10FFFF);
        assert (TSCodeRange.maxCodePoint(TSCodeRange.getValidFixedWidth()) == 0x10FFFF);
        assert (TSCodeRange.maxCodePoint(TSCodeRange.getValidMultiByte()) == 0x10FFFF);
        assert (TSCodeRange.maxCodePoint(4) == 0x10FFFF);
        assert (TSCodeRange.maxCodePoint(TSCodeRange.getBrokenFixedWidth()) == 0x10FFFF);
        assert (TSCodeRange.maxCodePoint(TSCodeRange.getBrokenMultiByte()) == 0x10FFFF);
    }

    @CompilerDirectives.TruffleBoundary
    static String toString(int codeRange) {
        switch (TSCodeRange.ordinal(codeRange)) {
            case 0: {
                return "7Bit" + TSCodeRange.preciseFlagToString(codeRange);
            }
            case 1: {
                return "8Bit" + TSCodeRange.preciseFlagToString(codeRange);
            }
            case 2: {
                return "16Bit" + TSCodeRange.preciseFlagToString(codeRange);
            }
            case 3: {
                return "Valid" + TSCodeRange.flagsToString(codeRange);
            }
            case 4: {
                return "Broken" + TSCodeRange.flagsToString(codeRange);
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private static String preciseFlagToString(int codeRange) {
        return TSCodeRange.isPrecise(codeRange) ? "" : "(imprecise)";
    }

    private static String flagsToString(int codeRange) {
        if (TSCodeRange.isFixedWidth(codeRange)) {
            if (TSCodeRange.isPrecise(codeRange)) {
                return "(fixedWidth)";
            }
            return "(fixedWidth, imprecise)";
        }
        if (TSCodeRange.isPrecise(codeRange)) {
            return "(multibyte)";
        }
        return "(multibyte, imprecise)";
    }

    static {
        TSCodeRange.staticAssertions();
    }
}

