/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.ParserException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.tools.WebService;
import org.jdom2.JDOMException;
import org.json.JSONObject;

@Path(value="/Validation")
@Api(value="/Validation", description="Validate HELM input string")
public class RestValidation {
    @Path(value="{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Check for conformance to the specification & availability of monomers in the current monomer database. Be careful with special cases in the url", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation is valid"), @ApiResponse(code=400, message="HELMNotation is not valid")})
    public Response validateInputHELM(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            webservice.validateHELM(helmNotation);
            json.put("HELMNotation", (Object)helmNotation);
            json.put("Validation", (Object)"valid");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Check for conformance to the specification & availability of monomers in the current monomer database.", httpMethod="POST", response=Response.class, responseContainer="KJSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation is valid"), @ApiResponse(code=400, message="HELMNotation is not valid")})
    public Response validateInputHELMPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            webservice.validateHELM(helm);
            json.put("HELMNotation", (Object)helm);
            json.put("Validation", (Object)"valid");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="Syntax/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Check for conformance to the specification. Be careful with special cases in the url", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation is valid"), @ApiResponse(code=400, message="HELMNotation is not valid")})
    public Response validateSyntaxInputHELM(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            webservice.validateSyntaxHELM(helmNotation);
            json.put("HELMNotation", (Object)helmNotation);
            json.put("Validation", (Object)"valid");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | MonomerException | ParserException | JDOMException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="Syntax")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Check for conformance to the specification.", httpMethod="POST", response=Response.class, responseContainer="KJSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation is valid"), @ApiResponse(code=400, message="HELMNotation is not valid")})
    public Response validateSyntaxInputHELMPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            webservice.validateSyntaxHELM(helm);
            json.put("HELMNotation", (Object)helm);
            json.put("Validation", (Object)"valid");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | MonomerException | ParserException | JDOMException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

