/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Chemistry;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.HELM1FormatException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.tools.WebService;
import org.json.JSONObject;

@Path(value="/Conversion")
@Api(value="/Conversion", description="Converts HELM into standard/canonical HELM and JSON-Output")
public class RestConversion {
    @Path(value="/Canonical/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Converts HELM Input into canonical HELM", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully converted into canonical HELMNotation"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response convertHELMCanonical(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            String result = webservice.convertStandardHELMToCanonicalHELM(helmNotation);
            json.put("CanonicalHELM", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | HELM1FormatException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="Canonical/")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Converts HELM Input into canonical HELM", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully converted into canonical HELMNotation"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response convertHELMCanonicalPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            String result = webservice.convertStandardHELMToCanonicalHELM(helm);
            json.put("CanonicalHELM", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | HELM1FormatException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="Standard/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Converts HELM Input into standard HELM", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully converted into standard HELMNotation"), @ApiResponse(code=400, message="Error in HLEM input")})
    public Response convertHELMStandard(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            String result = webservice.convertIntoStandardHELM(helmNotation);
            json.put("HELMNotation", (Object)helmNotation);
            json.put("StandardHELM", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | ChemistryException | HELM1FormatException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="Standard/")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Converts HELM Input into standard HELM", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully converted into standard HELMNotation"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response convertHELMStandardPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            String result = webservice.convertIntoStandardHELM(helm);
            json.put("StandardHELM", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | ChemistryException | HELM1FormatException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="Molfile/{smiles}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Converts SMILES input into Molfile", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="SMILES was successfully converted into Molfile"), @ApiResponse(code=400, message="Error in SMILES input")})
    public Response convertMolfile(@ApiParam(value="SMILES", required=true) @PathParam(value="smiles") String smiles) {
        JSONObject json = new JSONObject();
        try {
            String atomMapSmiles = Chemistry.getInstance().getManipulator().convertExtendedSmiles(smiles);
            String result = Chemistry.getInstance().getManipulator().convert(atomMapSmiles, AbstractChemistryManipulator.StType.SMILES);
            json.put("SMILES", (Object)smiles);
            json.put("Molfile", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (CTKException | ChemistryException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
        }
    }

    @Path(value="Molfile/")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Converts SMILES input into Molfile", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="SMILES was successfully converted into Molfile"), @ApiResponse(code=400, message="Error in SMILES input")})
    public Response convertMolfilePost(@ApiParam(value="SMILES", required=true) @FormParam(value="SMILES") String smiles) {
        JSONObject json = new JSONObject();
        try {
            String atomMapSmiles = Chemistry.getInstance().getManipulator().convertExtendedSmiles(smiles);
            String result = Chemistry.getInstance().getManipulator().convert(atomMapSmiles, AbstractChemistryManipulator.StType.SMILES);
            json.put("SMILES", (Object)smiles);
            json.put("Molfile", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (CTKException | ChemistryException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
        }
    }

    @Path(value="JSON/")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Converts HELM Input into JSON-Output", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="JSON-Output was successfully generated from the HELMNotation"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response createJSON(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            String result = webservice.generateJSON(helm);
            json.put("JSON", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

