/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.ExtinctionCoefficientException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.helm.notation2.tools.HELM2NotationUtils;
import org.helm.notation2.tools.WebService;
import org.json.JSONObject;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.Fingerprinter;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.Similarity;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.Subset;

@Path(value="/Calculation")
@Api(value="/Calculation", description="Calculates something from the HELM Notation")
public class RestCalculation {
    @Path(value="/MolecularWeight/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Calculates the molecular weight of a non-ambiguous HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Molecular weight was successfully calculated from HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateMolecularWeight(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            Double result = webservice.calculateMolecularWeight(helmNotation);
            json.put("MolecularWeight", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)("" + e.getMessage()));
            json.put("ErrorClass", (Object)("" + e.getClass()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MolecularWeight")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the molecular weight of a non-ambiguous HELM string", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Molecular weight was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateMolecularWeightPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            Double result = webservice.calculateMolecularWeight(helm);
            json.put("MolecularWeight", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)("" + e.getMessage()));
            json.put("ErrorClass", (Object)("" + e.getClass()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MolecularFormula/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Calculates the molecular formula of a non-ambiguous  HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Moleuclar formula was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateMolecularFormula(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            String result = webservice.getMolecularFormula(helmNotation);
            json.put("MoleculcarFormula", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MolecularFormula")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the molecular formula of a non-ambiguous HELM string", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Molecular Formula was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateMolecularFormulaPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            String result = webservice.getMolecularFormula(helm);
            json.put("MolecularFormula", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/ExtinctionCoefficient/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Calculates the extinction coefficient of a non-ambiguous  HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Extinction coefficient was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateExtinctionCoefficient(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            Float result = webservice.calculateExtinctionCoefficient(helmNotation);
            json.put("ExtinctionCoefficient", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | ExtinctionCoefficientException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/ExtinctionCoefficient")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the extinction coefficient of a non-ambiguous  HELM string", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Extinction coefficient was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateExtinctionCoefficientPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            Float result = webservice.calculateExtinctionCoefficient(helm);
            json.put("ExtinctionCoefficient", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | ExtinctionCoefficientException | ValidationException e) {
            json = new JSONObject();
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MoleculeProperties/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the extinction coefficient of a non-ambiguous HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="MoleculeProperties were successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateCombined(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            List result = webservice.getMolecularProperties(helm);
            json.put("MolecularFormula", result.get(0));
            json.put("MolecularWeight", result.get(1));
            json.put("ExtinctionCoefficient", result.get(3));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ExtinctionCoefficientException | ValidationException e) {
            json = new JSONObject();
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MoleculeProperties")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates molecule properties of a non-ambiguous HELM string", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Molecule properties were successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateCombinedPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            List result = webservice.getMolecularProperties(helm);
            json.put("MolecularFormula", result.get(0));
            json.put("MolecularWeight", result.get(1));
            json.put("ExtinctionCoefficient", result.get(3));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ExtinctionCoefficientException | ValidationException e) {
            json = new JSONObject();
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Fingerprints/original/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates a hashed fingerprint of a non-ambiguous HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Fingerprint of HELM input was successfully calculated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateFingerprint(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            webservice.validateHELM(helm);
            BitSet fingerprint = Fingerprinter.calculateFingerprint((HELM2Notation)HELM2NotationUtils.readNotation((String)helm));
            json.put("Fingerprint", (Object)fingerprint);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Fingerprints/original")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates a hashed fingerprint of a non-ambiguous HELM string", httpMethod="PUT", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Fingerprint of HELM input was successfully calculated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateFingerprintPut(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            webservice.validateHELM(helm);
            BitSet fingerprint = Fingerprinter.calculateFingerprint((HELM2Notation)HELM2NotationUtils.readNotation((String)helm));
            json.put("Fingerprint", (Object)fingerprint);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json = new JSONObject();
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Fingerprints/naturalAnalogs/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates a hashed fingerprint of a non-ambiguous HELM string and takes natural analogs ofmodified monomers into account", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Fingerprint natural analogs of HELM input was successfully calculated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateFingerprintNaturalAnalogs(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            webservice.validateHELM(helm);
            BitSet fingerprint = Fingerprinter.calculateFingerprintNaturalAnalogs((HELM2Notation)HELM2NotationUtils.readNotation((String)helm));
            json.put("Fingerprint", (Object)fingerprint);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Fingerprints/naturalAnalogs")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates a hashed fingerprint of a non-ambiguous HELM string and takes natural analogs ofmodified monomers into account", httpMethod="PUT", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Fingerprint natural analogs of HELM input was successfully calculated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateFingerprintNaturalAnalogsPut(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            webservice.validateHELM(helm);
            BitSet fingerprint = Fingerprinter.calculateFingerprintNaturalAnalogs((HELM2Notation)HELM2NotationUtils.readNotation((String)helm));
            json.put("Fingerprint", (Object)fingerprint);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Similarity/original/{c}/{v}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the similarity of two HELM notations", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Similarity was successfully calculated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateSimilarity(@ApiParam(value="HELMNotation1", required=true) @PathParam(value="c") String helm1, @ApiParam(value="HELMNotation2", required=true) @PathParam(value="v") String helm2) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation1", (Object)helm1);
            json.put("HELMNotation2", (Object)helm2);
            webservice.validateHELM(helm1);
            webservice.validateHELM(helm2);
            Double similarity = Similarity.calculateSimilarity((HELM2Notation)HELM2NotationUtils.readNotation((String)helm1), (HELM2Notation)HELM2NotationUtils.readNotation((String)helm2));
            json.put("Similarity", (Object)similarity);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Similarity/original")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the similarity of two HELM notations", httpMethod="PUT", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Similarity was successfully calculated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateSimilarityPut(@ApiParam(value="HELMNotation1", required=true) @FormParam(value="HELMNotation1") String helm1, @ApiParam(value="HELMNotation2", required=true) @FormParam(value="HELMNotation2") String helm2) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation1", (Object)helm1);
            json.put("HELMNotation2", (Object)helm2);
            webservice.validateHELM(helm1);
            webservice.validateHELM(helm2);
            Double similarity = Similarity.calculateSimilarity((HELM2Notation)HELM2NotationUtils.readNotation((String)helm1), (HELM2Notation)HELM2NotationUtils.readNotation((String)helm2));
            json.put("Similarity", (Object)similarity);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Similarity/naturalAnalogs/{c}/{v}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the similarity of two HELM notations with natural analogs taken into account", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Similarity was successfully calculated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateSimilarityNaturalAnalogs(@ApiParam(value="HELMNotation1", required=true) @PathParam(value="c") String helm1, @ApiParam(value="HELMNotation2", required=true) @PathParam(value="v") String helm2) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation1", (Object)helm1);
            json.put("HELMNotation2", (Object)helm2);
            webservice.validateHELM(helm1);
            webservice.validateHELM(helm2);
            Double similarity = Similarity.calculateSimilarityNatAnalogs((HELM2Notation)HELM2NotationUtils.readNotation((String)helm1), (HELM2Notation)HELM2NotationUtils.readNotation((String)helm2));
            json.put("Similarity", (Object)similarity);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Similarity/naturalAnalogs")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the similarity of two HELM notations with natural analogs taken into account", httpMethod="PUT", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Similarity was successfully calculated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateSimilarityNaturalAnalogsPut(@ApiParam(value="HELMNotation1", required=true) @FormParam(value="HELMNotation1") String helm1, @ApiParam(value="HELMNotation2", required=true) @FormParam(value="HELMNotation2") String helm2) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation1", (Object)helm1);
            json.put("HELMNotation2", (Object)helm2);
            webservice.validateHELM(helm1);
            webservice.validateHELM(helm2);
            Double similarity = Similarity.calculateSimilarityNatAnalogs((HELM2Notation)HELM2NotationUtils.readNotation((String)helm1), (HELM2Notation)HELM2NotationUtils.readNotation((String)helm2));
            json.put("Similarity", (Object)similarity);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Substructure/{c}/{v}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Checks if a parent notation is a substructure of a child notationmodified monomers into account", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELM substructure relationship was successfully calculated."), @ApiResponse(code=400, message="Error in HELM input")})
    public Response checkSubstructureRelationship(@ApiParam(value="parent notation", required=true) @PathParam(value="c") String parentHelm, @ApiParam(value="child notation", required=true) @PathParam(value="v") String childHelm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation1", (Object)parentHelm);
            json.put("HELMNotation2", (Object)childHelm);
            webservice.validateHELM(parentHelm);
            webservice.validateHELM(childHelm);
            Boolean isSubset = Subset.checkHelmRelationship((HELM2Notation)HELM2NotationUtils.readNotation((String)parentHelm), (HELM2Notation)HELM2NotationUtils.readNotation((String)childHelm));
            json.put("SubstructureRelationship", (Object)isSubset);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Substructure")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Checks if a parent notation is a substructure of a child notationmodified monomers into account", httpMethod="PUT", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELM substructure relationship was successfully calculated."), @ApiResponse(code=400, message="Error in HELM input")})
    public Response checkSubstructureRelationshipPut(@ApiParam(value="parent notation", required=true) @FormParam(value="parentNotation") String parentHelm, @ApiParam(value="child notation", required=true) @FormParam(value="childNotation") String childHelm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation1", (Object)parentHelm);
            json.put("HELMNotation2", (Object)childHelm);
            webservice.validateHELM(parentHelm);
            webservice.validateHELM(childHelm);
            Boolean isSubset = Subset.checkHelmRelationship((HELM2Notation)HELM2NotationUtils.readNotation((String)parentHelm), (HELM2Notation)HELM2NotationUtils.readNotation((String)childHelm));
            json.put("SubstructureRelationship", (Object)isSubset);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (Exception e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

