/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.NotationException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.tools.WebService;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="SMILES")
@Api(value="/SMILES", description="SMILES Generation")
public class RestSMILES {
    private static final Logger LOG = LoggerFactory.getLogger(RestSMILES.class);

    @Path(value="{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="SMILES generation for the whole HELM molecule", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="SMILES was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response generateSMILESForHELM(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            String result = webservice.generateSMILESForHELM2(helmNotation);
            json.put("SMILES", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (CTKException | BuilderMoleculeException | ChemistryException | MonomerLoadingException | ValidationException e) {
            json.put("ErrorMessage", (Object)("" + e.getMessage()));
            json.put("ErrorClass", (Object)("" + e.getClass()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="SMILES generation for  the whole HELM molecule", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="SMILES was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response generateSMILESForHELMPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            String result = webservice.generateSMILESForHELM2(helmNotation);
            json.put("SMILES", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (CTKException | BuilderMoleculeException | ChemistryException | MonomerLoadingException | ValidationException e) {
            json.put("ErrorMessage", (Object)("" + e.getMessage()));
            json.put("ErrorClass", (Object)("" + e.getClass()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Canonical/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Canonical SMILES generation for the whole HELM molecule", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="SMILES was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response generateCanSMILESForHELM(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            String result = webservice.generateCanSMILESForHELM2(helmNotation);
            json.put("SMILES", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (CTKException | BuilderMoleculeException | ChemistryException | MonomerLoadingException | NotationException | ValidationException e) {
            json.put("ErrorMessage", (Object)("" + e.getMessage()));
            json.put("ErrorClass", (Object)("" + e.getClass()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).build();
        }
    }

    @Path(value="/Canonical")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Canonical SMILES generation for  the whole HELM molecule", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="SMILES was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response generateCanSMILESForHELMPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            String result = webservice.generateCanSMILESForHELM2(helmNotation);
            json.put("SMILES", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (CTKException | BuilderMoleculeException | ChemistryException | MonomerLoadingException | NotationException | ValidationException e) {
            json.put("ErrorMessage", (Object)("" + e.getMessage()));
            json.put("ErrorClass", (Object)("" + e.getClass()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

