/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.tools.WebService;
import org.json.JSONObject;

@Path(value="/Refresh")
@Api(value="/Refresh", description="Refresh monomer cache")
public class RestRefresh {
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Refresh the monomers in the current monomer database.", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Monomer cache was refreshed"), @ApiResponse(code=400, message="Monomer cache was not refreshed")})
    public Response refreshMonomerCache() {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            webservice.refreshMonomerCache();
            json.put("Refresh", (Object)"valid");
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

