/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.tomcat.util.codec.binary.StringUtils;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.MonomerException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.tools.WebService;
import org.jdom2.JDOMException;

@Path(value="Image")
@Api(value="/Image", description="Image Generation")
public class RestImages {
    @Path(value="Monomer")
    @GET
    @Produces(value={"image/png"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Image generation of the atom/bond representation of monomer", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Monomer image was successfully generated"), @ApiResponse(code=400, message="Error ininput")})
    public Response generateImageForMonomer(@ApiParam(value="monomerId", required=true) @QueryParam(value="monomerId") String monomerID, @ApiParam(value="polymerType", required=true) @QueryParam(value="polymerType") String polymerType, @ApiParam(value="showRgroups") @QueryParam(value="showRgroups") boolean showRgroups) throws ChemistryException {
        Monomer monomer;
        WebService webservice = new WebService();
        try {
            monomer = MonomerFactory.getInstance().getMonomerStore().getMonomer(polymerType, monomerID);
        }
        catch (MonomerLoadingException e) {
            String message = ((Object)((Object)e)).getClass() + " " + e.getMessage();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)webservice.generateImageForMonomer(monomer, showRgroups)).build();
        }
        catch (CTKException | BuilderMoleculeException | ChemistryException e) {
            String message = e.getClass() + " " + e.getMessage();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
    }

    @Path(value="Monomer")
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Image generation of the atom/bond representation of monomer", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Monomer image was successfully generated"), @ApiResponse(code=400, message="Error in input")})
    public Response generateImageForMonomerPost(@ApiParam(value="monomerId", required=true) @FormParam(value="monomerId") String monomerID, @ApiParam(value="polymerType", required=true) @FormParam(value="polymerType") String polymerType, @FormParam(value="showRgroups") boolean showRgroups) throws ChemistryException {
        Monomer monomer;
        WebService webservice = new WebService();
        try {
            monomer = MonomerFactory.getInstance().getMonomerStore().getMonomer(polymerType, monomerID);
        }
        catch (MonomerLoadingException e) {
            String message = ((Object)((Object)e)).getClass() + " " + e.getMessage();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        try {
            byte[] result = webservice.generateImageForMonomer(monomer, showRgroups);
            StringBuilder sb = new StringBuilder();
            sb.append("data:image/png;base64,");
            sb.append(StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])result, (boolean)false)));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)sb.toString()).build();
        }
        catch (CTKException | BuilderMoleculeException | ChemistryException e) {
            String message = e.getClass() + " " + e.getMessage();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
    }

    @Path(value="HELM/{c}")
    @GET
    @Produces(value={"image/png"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Image generation of the atom/bond representation of the HELM molecule", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation image was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response generateImageForHELM(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) throws JDOMException, MonomerException {
        WebService webservice = new WebService();
        try {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)webservice.generateImageForHELMMolecule(helmNotation)).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            String message = e.getClass() + " " + e.getMessage();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
    }

    @Path(value="HELM")
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Image generation of the atom/bond representation of the HELM molecule", httpMethod="POST", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation image was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response generateImageForHELMPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) throws JDOMException, MonomerException {
        WebService webservice = new WebService();
        try {
            byte[] result = webservice.generateImageForHELMMolecule(helm);
            StringBuilder sb = new StringBuilder();
            sb.append("data:image/png;base64,");
            sb.append(StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])result, (boolean)false)));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)sb.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            String message = e.getClass() + " " + e.getMessage();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
    }
}

