/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.helm.chemtoolkit.AbstractChemistryManipulator;
import org.helm.chemtoolkit.cdk.CDKManipulator;
import org.helm.notation2.Attachment;
import org.helm.notation2.Monomer;
import org.helm.notation2.MonomerFactory;
import org.helm.notation2.tools.WebService;
import org.helm.rest.Database;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/ajaxtool")
public class AjaxTool {
    private static final String DEFAULT_HELM_DIR = System.getProperty("catalina.base") + System.getProperty("file.separator") + "webapps" + System.getProperty("file.separator") + "WebService" + System.getProperty("file.separator") + "hwe" + System.getProperty("file.separator") + "db";
    private static final String DEFAULT_MONOMERS_FILE_NAME = "monomers.txt";
    private static final String DEFAULT_RULES_FILE_NAME = "rules.txt";
    Database monomers = null;
    Database rules = null;

    @GET
    @Consumes(value={"application/json", "application/x-www-form-urlencoded", "text/html", "text/plain", "multipart/form-data"})
    @Produces(value={"text/plain", "application/json"})
    @Path(value="/get")
    public Response CmdGet(@Context HttpServletRequest request) {
        Map args = this.getQueryParameters(request);
        try {
            return this.OnCmd((String)args.get("cmd"), args, request);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)AjaxTool.wrapAjaxError((String)("ERROR: " + e.getMessage() + ", " + AjaxTool.GetTrace((Exception)e)))).build();
        }
    }

    @POST
    @Consumes(value={"application/json", "application/x-www-form-urlencoded", "text/html", "text/plain", "multipart/form-data"})
    @Produces(value={"text/plain", "text/html", "application/json"})
    @Path(value="/post")
    public Response CmdPost(@Context HttpServletRequest request) {
        String cmd = (String)this.getQueryParameters(request).get("cmd");
        Map args = cmd.equals("openjsd") ? null : this.getFormParameters(request);
        try {
            return this.OnCmd(cmd, args, request);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)AjaxTool.wrapAjaxError((String)("ERROR: " + e.getMessage() + ", " + AjaxTool.GetTrace((Exception)e)))).build();
        }
    }

    Response OnCmd(String cmd, Map<String, String> items, HttpServletRequest request) throws Exception {
        JSONObject ret = new JSONObject();
        switch (cmd) {
            case "helm.toolkit.monomer.json": {
                ArrayList ret2 = this.getToolkitMonomers();
                ret.put("list", (Collection)ret2);
                break;
            }
            case "helm.toolkit.monomer.downloadjson": {
                ArrayList ret2 = this.getToolkitMonomers();
                String s = "org.helm.webeditor.Monomers.loadDB(" + ret2.toString() + ");";
                return Response.status((Response.Status)Response.Status.OK).entity((Object)s).build();
            }
            case "helm.monomer.del": {
                this.LoadRules();
                ret = this.monomers.DelRecord(items.get("id"));
                if (ret == null) break;
                this.monomers.Save();
                break;
            }
            case "helm.monomer.load": {
                this.LoadMonomers();
                ret = this.monomers.LoadRow(items.get("id"));
                break;
            }
            case "helm.monomer.save": {
                this.LoadMonomers();
                String[] keys = this.monomers.getKeys();
                String[] row = new String[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    row[i] = items.get(keys[i]);
                }
                ret = this.monomers.SaveRecord(row);
                if (ret == null) break;
                this.monomers.Save();
                break;
            }
            case "helm.monomer.suggest": {
                break;
            }
            case "helm.monomer.list": {
                this.LoadMonomers();
                int page = AjaxTool.ToInt((String)items.get("page"));
                int countperpage = AjaxTool.ToInt((String)items.get("countperpage"));
                String polymertype = items.get("polymertype");
                String monomertype = items.get("monomertype");
                String symbol = items.get("symbol");
                ret = this.monomers.List(page, countperpage, "polymertype", polymertype, "monomertype", monomertype, "symbol", symbol);
                break;
            }
            case "helm.monomer.all": {
                this.LoadMonomers();
                ret.put("monomers", (Collection)this.monomers.AsJSON());
                break;
            }
            case "helm.monomer.json": {
                this.LoadMonomers();
                ArrayList ret2 = this.monomers.AsJSON();
                ret.put("list", (Collection)ret2);
                break;
            }
            case "helm.monomer.downloadjson": {
                this.LoadMonomers();
                ArrayList ret2 = this.monomers.AsJSON();
                String s = "org.helm.webeditor.Monomers.loadDB(" + ret2.toString() + ");";
                return Response.status((Response.Status)Response.Status.OK).entity((Object)s).build();
            }
            case "helm.monomer.filelocation": {
                ret = new JSONObject();
                ret.put("momomers", (Object)(DEFAULT_HELM_DIR + System.getProperty("file.separator") + "monomers.txt"));
                break;
            }
            case "helm.rule.del": {
                this.LoadRules();
                ret = this.rules.DelRecord(items.get("id"));
                if (ret == null) break;
                this.rules.Save();
                break;
            }
            case "helm.rule.load": {
                this.LoadRules();
                ret = this.rules.LoadRow(items.get("id"));
                break;
            }
            case "helm.rule.save": {
                this.LoadRules();
                String[] keys = this.rules.getKeys();
                String[] row = new String[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    row[i] = items.get(keys[i]);
                }
                ret = this.rules.SaveRecord(row);
                if (ret == null) break;
                this.rules.Save();
                break;
            }
            case "helm.rule.list": {
                this.LoadRules();
                int page = AjaxTool.ToInt((String)items.get("page"));
                int countperpage = AjaxTool.ToInt((String)items.get("countperpage"));
                String category = items.get("category");
                ret = this.rules.List(page, countperpage, "category", category, null, null, null, null);
                break;
            }
            case "helm.rule.all": {
                this.LoadRules();
                ret.put("rules", (Collection)this.rules.AsJSON());
                break;
            }
            case "helm.rule.downloadjson": 
            case "helm.rules.downloadjson": {
                this.LoadRules();
                ArrayList ret2 = this.rules.AsJSON();
                String s = "org.helm.webeditor.RuleSet.loadDB(" + ret2.toString() + ");";
                return Response.status((Response.Status)Response.Status.OK).entity((Object)s).build();
            }
            case "openjsd": {
                ret = new JSONObject();
                Part part = request.getPart("file");
                String filename = this.getFileName(part);
                String contents = AjaxTool.getValue((Part)part);
                ret.put("filename", (Object)filename);
                ret.put("base64", (Object)Database.EncodeBase64((String)contents));
                String s = "<html><head></head><body><textarea>" + AjaxTool.wrapAjaxResult((JSONObject)ret) + "</textarea></body></html>";
                return Response.status((Response.Status)Response.Status.OK).entity((Object)s).type("text/html").build();
            }
            case "savefile": {
                String filename = items.get("filename");
                String contents = items.get("contents");
                return Response.ok((Object)contents, (String)"application/unknown").header("content-disposition", (Object)("attachment;filename=" + filename)).build();
            }
            case "helm.properties": {
                ret = AjaxTool.CalculateProperties((String)items.get("helm"));
                break;
            }
            case "cleanup": {
                ret = AjaxTool.Cleanup((String)items.get("input"), (String)items.get("inputformat"));
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)AjaxTool.wrapAjaxError((String)("Unknown cmd: " + cmd))).build();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)AjaxTool.wrapAjaxResult((JSONObject)ret)).build();
    }

    ArrayList<JSONObject> getToolkitMonomers() {
        ArrayList<JSONObject> ret = new ArrayList<JSONObject>();
        try {
            Map allMonomers = MonomerFactory.getInstance().getMonomerDB();
            Set polymerTypes = allMonomers.keySet();
            for (String polymerType : polymerTypes) {
                Map monomers = (Map)allMonomers.get(polymerType);
                Set monomerIds = monomers.keySet();
                for (String monomerId : monomerIds) {
                    Monomer monomer = (Monomer)monomers.get(monomerId);
                    ret.add(this.monomer2Json(monomer));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    JSONObject monomer2Json(Monomer m) {
        JSONObject ret = new JSONObject();
        ret.put("id", m.getId());
        ret.put("symbol", (Object)m.getAlternateId());
        ret.put("name", (Object)m.getName());
        ret.put("naturalanalog", (Object)m.getNaturalAnalog());
        ret.put("molfile", (Object)m.getMolfile());
        ret.put("smiles", (Object)m.getCanSMILES());
        ret.put("polymertype", (Object)m.getPolymerType());
        ret.put("monomertype", (Object)m.getMonomerType());
        List al = m.getAttachmentList();
        ArrayList l = new ArrayList();
        for (Attachment a : al) {
            ret.put(a.getLabel().toLowerCase(), (Object)a.getCapGroupName());
        }
        return ret;
    }

    private String getFileName(Part part) {
        String partHeader = part.getHeader("content-disposition");
        for (String content : part.getHeader("content-disposition").split(";")) {
            if (!content.trim().startsWith("filename")) continue;
            return content.substring(content.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }

    static JSONObject Cleanup(String q, String inputformat) {
        if (StringUtils.isEmpty((String)q)) {
            return null;
        }
        JSONObject ret = new JSONObject();
        try {
            CDKManipulator m = new CDKManipulator();
            String molfile = null;
            if (inputformat != null && (inputformat.equals("mol") || inputformat.equals("molfile"))) {
                String smiles = m.convert(q, AbstractChemistryManipulator.StType.MOLFILE);
                molfile = m.convert(smiles, AbstractChemistryManipulator.StType.SMILES);
            } else {
                molfile = m.convert(q, AbstractChemistryManipulator.StType.SMILES);
            }
            ret.put("output", (Object)molfile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    static JSONObject CalculateProperties(String helm) {
        if (StringUtils.isEmpty((String)helm)) {
            return null;
        }
        WebService webservice = new WebService();
        JSONObject ret = new JSONObject();
        try {
            ret.put("helm", (Object)helm);
            ret.put("mw", (Object)webservice.calculateMolecularWeight(helm));
            ret.put("mf", (Object)webservice.getMolecularFormula(helm));
            ret.put("ec", (Object)webservice.calculateExtinctionCoefficient(helm));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    static String getValue(Part part) throws IOException {
        if (part == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(part.getInputStream(), "UTF-8"));
        StringBuilder value = new StringBuilder();
        char[] buffer = new char[1024];
        int length = 0;
        while ((length = reader.read(buffer)) > 0) {
            value.append(buffer, 0, length);
        }
        return value.toString();
    }

    static String GetTrace(Exception e) {
        StackTraceElement[] list = e.getStackTrace();
        if (list == null) {
            return null;
        }
        String s = "";
        for (int i = 0; i < list.length; ++i) {
            s = s + list[i].getFileName() + "->" + list[i].getClassName() + "->" + list[i].getMethodName() + ": line " + list[i].getLineNumber() + "|";
        }
        return s;
    }

    void LoadMonomers() {
        if (this.monomers == null) {
            String[] cols = new String[]{"id", "symbol", "name", "naturalanalog", "molfile", "smiles", "polymertype", "monomertype", "r1", "r2", "r3", "r4", "r5", "author", "createddate"};
            this.seedDatabase("monomers.txt");
            this.monomers = new Database(DEFAULT_HELM_DIR + System.getProperty("file.separator") + "monomers.txt", cols);
        }
    }

    void LoadRules() {
        if (this.rules == null) {
            String[] cols = new String[]{"id", "name", "description", "script", "author", "category"};
            this.seedDatabase("rules.txt");
            this.rules = new Database(DEFAULT_HELM_DIR + System.getProperty("file.separator") + "rules.txt", cols);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void seedDatabase(String fileName) {
        File f = new File(DEFAULT_HELM_DIR + System.getProperty("file.separator") + fileName);
        BufferedReader reader = null;
        BufferedWriter writer = null;
        if (!f.exists()) {
            try {
                String line;
                File dir = new File(DEFAULT_HELM_DIR);
                if (!dir.exists()) {
                    dir.mkdir();
                }
                f.createNewFile();
                InputStream in = AjaxTool.class.getResourceAsStream("/" + fileName);
                reader = new BufferedReader(new InputStreamReader(in));
                writer = new BufferedWriter(new FileWriter(f));
                while ((line = reader.readLine()) != null) {
                    writer.write(line + System.getProperty("line.separator"));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(AjaxTool.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    if (null != reader) {
                        reader.close();
                    }
                    if (null != writer) {
                        writer.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    Map<String, String> getFormParameters(HttpServletRequest request) {
        Map dict = new HashMap();
        HashMap<String, String> ret = new HashMap<String, String>();
        String q = null;
        try {
            q = IOUtils.toString((InputStream)request.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (q != null && q.length() > 0) {
            dict = this.parseQueryString(q);
        }
        Iterator iterator = dict.keySet().iterator();
        while (iterator.hasNext()) {
            String k;
            String v = (String)dict.get(k = (String)iterator.next());
            ret.put(k, v == null || v.isEmpty() ? null : v);
        }
        return ret;
    }

    Map<String, String> getQueryParameters(HttpServletRequest request) {
        String queryString = request.getQueryString();
        return this.parseQueryString(queryString);
    }

    Map<String, String> parseQueryString(String queryString) {
        String[] parameters;
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)queryString)) {
            return queryParameters;
        }
        for (String parameter : parameters = queryString.split("&")) {
            String v;
            String[] keyValuePair = parameter.split("=");
            String string = v = keyValuePair.length < 2 ? null : keyValuePair[1];
            if (v != null) {
                try {
                    v = URLDecoder.decode(v, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            queryParameters.put(keyValuePair[0], v);
        }
        return queryParameters;
    }

    static int ToInt(String s) {
        try {
            if (s == null || s.length() == 0) {
                return 0;
            }
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String wrapAjaxResult(JSONObject ret) {
        JSONObject json = new JSONObject();
        json.put("succeed", true);
        json.put("ret", (Object)ret);
        return json.toString();
    }

    public static String wrapAjaxResult(ArrayList ret) {
        JSONObject json = new JSONObject();
        json.put("succeed", true);
        json.put("ret", (Collection)ret);
        return json.toString();
    }

    public static String wrapAjaxError(String error) {
        JSONObject json = new JSONObject();
        json.put("succeed", false);
        json.put("error", (Object)error);
        return json.toString();
    }
}

