/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.FastaFormatException;
import org.helm.notation2.exception.HELM2HandledException;
import org.helm.notation2.exception.MonomerLoadingException;
import org.helm.notation2.exception.PeptideUtilsException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.parser.exceptionparser.NotationException;
import org.helm.notation2.tools.WebService;
import org.jdom2.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/Fasta")
@Api(value="/Fasta", description="Fasta-Services")
public class RestFasta {
    @Path(value="/Produce/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Converts HELM Input into Fasta", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="FastaFile was successfully generated from the HELMNotation "), @ApiResponse(code=400, message="Error in HELM input")})
    public Response generateFasta(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            String result = webservice.generateFasta(helmNotation);
            json.put("HELMNotation", (Object)helmNotation);
            json.put("FastaFile", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | FastaFormatException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Produce")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Converts HELM Input into Fasta", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="FastaFile was successfully generated from the HELMNotation"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response generateFastaPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            String result = webservice.generateFasta(helm);
            json.put("FastaFile", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | FastaFormatException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Read")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Reads peptide Fasta-Sequence(s) and generates HELMNotation", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully generated"), @ApiResponse(code=400, message="Error in sequence input")})
    public Response generateHELMInput(@ApiParam(value="peptide", required=false) @QueryParam(value="PEPTIDE") String peptide, @ApiParam(value="rna", required=false) @QueryParam(value="RNA") String rna) throws NotationException, IOException, JDOMException, ChemistryException {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        if (peptide != null && rna == null) {
            try {
                json.put("HELMNotation", (Object)webservice.generateHELMFromFastaPeptide(peptide));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
            }
            catch (FastaFormatException | MonomerLoadingException | JSONException e) {
                json.put("ErrorMessage", (Object)e.getMessage());
                json.put("ErrorClass", e.getClass());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        if (peptide == null && rna != null) {
            try {
                json.put("HELMNotation", (Object)webservice.generateHELMFromFastaNucleotide(rna));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
            }
            catch (FastaFormatException | MonomerLoadingException | JSONException e) {
                json.put("ErrorMessage", (Object)e.getMessage());
                json.put("ErrorClass", e.getClass());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        json.put("ErrorMessage", (Object)"Specify only one typ: RNA or PEPTIDE");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Specify only one typ: RNA or PEPTIDE").build();
    }

    @Path(value="Read/RNA")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Reads rna Fasta-Sequence(s) and generates HELMNotation", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully generated"), @ApiResponse(code=400, message="Error in input rna sequence")})
    public Response generateHELMInputPostRNA(@ApiParam(value="rna", required=true) @FormParam(value="RNA") String rna) throws NotationException, IOException, JDOMException, ChemistryException {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)webservice.generateHELMFromFastaNucleotide(rna));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (FastaFormatException | MonomerLoadingException | JSONException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="Read/PEPTIDE")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Reads peptide Fasta-Sequence(s) and generates HELMNotation", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully generated"), @ApiResponse(code=400, message="Error in input peptide sequence")})
    public Response generateHELMInputPostPEPTIDE(@ApiParam(value="peptide", required=true) @FormParam(value="PEPTIDE") String peptide) throws ChemistryException {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)webservice.generateHELMFromFastaPeptide(peptide));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (FastaFormatException | MonomerLoadingException | JSONException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Convert/RNA/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Reads HELMNotation and converts it into rna analogue sequence", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Natural analogue rna sequence was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response convertIntoRNAAnalogSequence(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String notation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("Sequence", (Object)webservice.generateNaturalAnalogSequenceRNA(notation));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | HELM2HandledException | ValidationException | NotationException | JSONException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Convert/PEPTIDE/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Reads HELMNotation and converts it into peptide analogue sequence", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Natural analogue peptide sequence was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response convertIntoPEPTIDEAnalogSequence(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String notation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("Sequence", (Object)webservice.generateNaturalAnalogSequencePeptide(notation));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | HELM2HandledException | PeptideUtilsException | ValidationException | NotationException | JSONException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Convert/RNA")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Reads HELMNotation and converts it into rna analogue sequence", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Natural analogue rna sequence was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response convertIntoRNAAnalogSequencePost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("Sequence", (Object)webservice.generateNaturalAnalogSequenceRNA(helm));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | HELM2HandledException | ValidationException | NotationException | JSONException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/Convert/PEPTIDE")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Reads HELMNotation and converts it into peptide analogue sequence", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Natural analogue peptide sequence was successfully generated"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response convertIntoPEPTIDEAnalogSequencePost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("Sequence", (Object)webservice.generateNaturalAnalogSequencePeptide(helm));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | HELM2HandledException | PeptideUtilsException | ValidationException | NotationException | JSONException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

