/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.helm.chemtoolkit.CTKException;
import org.helm.notation2.exception.BuilderMoleculeException;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.ExtinctionCoefficientException;
import org.helm.notation2.exception.ValidationException;
import org.helm.notation2.tools.WebService;
import org.json.JSONObject;

@Path(value="/Calculation")
@Api(value="/Calculation", description="Calculates something from the HELM Notation")
public class RestCalculation {
    @Path(value="/MolecularWeight/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Calculates the molecular weight of a non-ambiguous HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Molecular weight was successfully calculated from HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateMolecularWeight(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            Double result = webservice.calculateMolecularWeight(helmNotation);
            json.put("MolecularWeight", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)("" + e.getMessage()));
            json.put("ErrorClass", (Object)("" + e.getClass()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MolecularWeight")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the molecular weight of a non-ambiguous HELM string", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Molecular weight was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateMolecularWeightPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            Double result = webservice.calculateMolecularWeight(helm);
            json.put("MolecularWeight", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)("" + e.getMessage()));
            json.put("ErrorClass", (Object)("" + e.getClass()));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MolecularFormula/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Calculates the molecular formula of a non-ambiguous  HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Moleuclar formula was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateMolecularFormula(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            String result = webservice.getMolecularFormula(helmNotation);
            json.put("MoleculcarFormula", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MolecularFormula")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the molecular formula of a non-ambiguous HELM string", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Molecular Formula was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateMolecularFormulaPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            String result = webservice.getMolecularFormula(helm);
            json.put("MolecularFormula", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/ExtinctionCoefficient/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Calculates the extinction coefficient of a non-ambiguous  HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Extinction coefficient was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateExtinctionCoefficient(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helmNotation) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helmNotation);
            Float result = webservice.calculateExtinctionCoefficient(helmNotation);
            json.put("ExtinctionCoefficient", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | ExtinctionCoefficientException | ValidationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/ExtinctionCoefficient")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the extinction coefficient of a non-ambiguous  HELM string", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Extinction coefficient was successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateExtinctionCoefficientPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            Float result = webservice.calculateExtinctionCoefficient(helm);
            json.put("ExtinctionCoefficient", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | ChemistryException | ExtinctionCoefficientException | ValidationException e) {
            json = new JSONObject();
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MoleculeProperties/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates the extinction coefficient of a non-ambiguous HELM string", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="MoleculeProperties were successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateCombined(@ApiParam(value="HELMNotation", required=true) @PathParam(value="c") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            List result = webservice.getMolecularProperties(helm);
            json.put("MolecularFormula", result.get(0));
            json.put("MolecularWeight", result.get(1));
            json.put("ExtinctionCoefficient", result.get(3));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ExtinctionCoefficientException | ValidationException e) {
            json = new JSONObject();
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/MoleculeProperties")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    @ApiOperation(value="Calculates molecule properties of a non-ambiguous HELM string", httpMethod="POST", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="Molecule properties were successfully calculated from the HELM input"), @ApiResponse(code=400, message="Error in HELM input")})
    public Response calculateCombinedPost(@ApiParam(value="HELMNotation", required=true) @FormParam(value="HELMNotation") String helm) {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            json.put("HELMNotation", (Object)helm);
            List result = webservice.getMolecularProperties(helm);
            json.put("MolecularFormula", result.get(0));
            json.put("MolecularWeight", result.get(1));
            json.put("ExtinctionCoefficient", result.get(3));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | CTKException | BuilderMoleculeException | ChemistryException | ExtinctionCoefficientException | ValidationException e) {
            json = new JSONObject();
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

