/*
 * Decompiled with CFR 0.152.
 */
package org.helm.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.helm.notation2.exception.ChemistryException;
import org.helm.notation2.exception.FastaFormatException;
import org.helm.notation2.parser.exceptionparser.NotationException;
import org.helm.notation2.tools.WebService;
import org.json.JSONObject;

@Path(value="/Sequence")
@Api(value="/Sequence", description="Reads peptide/rna sequence and converts the input into HELMNotation")
public class ReadSequence {
    @Path(value="/PEPTIDE/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Reads peptide sequence and generates HELMNotation", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully generated"), @ApiResponse(code=400, message="Error in peptide sequence input")})
    public Response generateHELMPeptide(@ApiParam(value="peptide", required=true) @PathParam(value="c") String peptide) throws ChemistryException {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            String result = webservice.readPeptide(peptide);
            json.put("HELMNotation", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (FastaFormatException | NotationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/RNA/{c}")
    @GET
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Reads rna sequence and generates HELMNotation", httpMethod="GET", response=Response.class, responseContainer="JSON")
    @ApiResponses(value={@ApiResponse(code=200, message="HELMNotation was successfully generated"), @ApiResponse(code=400, message="Error in rna sequence input")})
    public Response generateHELMRNA(@ApiParam(value="rna", required=true) @PathParam(value="c") String rna) throws ChemistryException {
        WebService webservice = new WebService();
        JSONObject json = new JSONObject();
        try {
            String result = webservice.readRNA(rna);
            json.put("HELMNotation", (Object)result);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)json.toString()).build();
        }
        catch (IOException | FastaFormatException | NotationException e) {
            json.put("ErrorMessage", (Object)e.getMessage());
            json.put("ErrorClass", e.getClass());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }
}

